/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal.terminalinterface.jna;

import com.github.ajalt.mordant.rendering.Size;
import com.github.ajalt.mordant.terminal.terminalinterface.TerminalInterfaceWindows;
import com.github.ajalt.mordant.terminal.terminalinterface.jna.WinKernel32Lib;
import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.UShort;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0002J\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u000f\u0010\u0012\u001a\u00020\u0013H\u0014\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013H\u0014\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/github/ajalt/mordant/terminal/terminalinterface/jna/TerminalInterfaceJnaWindows;", "Lcom/github/ajalt/mordant/terminal/terminalinterface/TerminalInterfaceWindows;", "<init>", "()V", "kernel", "Lcom/github/ajalt/mordant/terminal/terminalinterface/jna/WinKernel32Lib;", "kotlin.jvm.PlatformType", "Lcom/github/ajalt/mordant/terminal/terminalinterface/jna/WinKernel32Lib;", "stdoutHandle", "Lcom/github/ajalt/mordant/terminal/terminalinterface/jna/WinKernel32Lib$HANDLE;", "stdinHandle", "handleInteractive", "", "handle", "stdoutInteractive", "stdinInteractive", "getTerminalSize", "Lcom/github/ajalt/mordant/rendering/Size;", "getStdinConsoleMode", "Lkotlin/UInt;", "getStdinConsoleMode-pVg5ArA", "()I", "setStdinConsoleMode", "", "dwMode", "setStdinConsoleMode-WZ4Q5Ns", "(I)V", "readRawEvent", "Lcom/github/ajalt/mordant/terminal/terminalinterface/TerminalInterfaceWindows$EventRecord;", "dwMilliseconds", "", "mordant-jvm-jna"})
@SourceDebugExtension(value={"SMAP\nTerminalInterface.jna.windows.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalInterface.jna.windows.kt\ncom/github/ajalt/mordant/terminal/terminalinterface/jna/TerminalInterfaceJnaWindows\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,312:1\n1#2:313\n*E\n"})
public final class TerminalInterfaceJnaWindows
extends TerminalInterfaceWindows {
    private final WinKernel32Lib kernel = Native.load("kernel32", WinKernel32Lib.class, W32APIOptions.DEFAULT_OPTIONS);
    @NotNull
    private final WinKernel32Lib.HANDLE stdoutHandle = this.kernel.GetStdHandle(-11);
    @NotNull
    private final WinKernel32Lib.HANDLE stdinHandle = this.kernel.GetStdHandle(-10);

    private final boolean handleInteractive(WinKernel32Lib.HANDLE handle) {
        boolean bl;
        try {
            this.kernel.GetConsoleMode(handle, new IntByReference());
            bl = true;
        }
        catch (LastErrorException e) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean stdoutInteractive() {
        return this.handleInteractive(this.stdoutHandle);
    }

    @Override
    public boolean stdinInteractive() {
        return this.handleInteractive(this.stdinHandle);
    }

    @Override
    @Nullable
    public Size getTerminalSize() {
        Size size2;
        WinKernel32Lib.CONSOLE_SCREEN_BUFFER_INFO csbi = new WinKernel32Lib.CONSOLE_SCREEN_BUFFER_INFO();
        if (!this.kernel.GetConsoleScreenBufferInfo(this.stdoutHandle, csbi)) {
            return null;
        }
        WinKernel32Lib.SMALL_RECT sMALL_RECT = csbi.srWindow;
        if (sMALL_RECT != null) {
            WinKernel32Lib.SMALL_RECT $this$getTerminalSize_u24lambda_u240 = sMALL_RECT;
            boolean bl = false;
            size2 = new Size($this$getTerminalSize_u24lambda_u240.Right - $this$getTerminalSize_u24lambda_u240.Left + 1, $this$getTerminalSize_u24lambda_u240.Bottom - $this$getTerminalSize_u24lambda_u240.Top + 1);
        } else {
            size2 = null;
        }
        return size2;
    }

    @Override
    protected int getStdinConsoleMode-pVg5ArA() {
        IntByReference originalMode = new IntByReference();
        this.kernel.GetConsoleMode(this.stdinHandle, originalMode);
        return UInt.constructor-impl(originalMode.getValue());
    }

    @Override
    protected void setStdinConsoleMode-WZ4Q5Ns(int dwMode) {
        this.kernel.SetConsoleMode(this.stdinHandle, dwMode);
    }

    @Override
    @Nullable
    protected TerminalInterfaceWindows.EventRecord readRawEvent(int dwMilliseconds) {
        TerminalInterfaceWindows.EventRecord eventRecord;
        Pointer pointer = this.stdinHandle.getPointer();
        Intrinsics.checkNotNullExpressionValue(pointer, "getPointer(...)");
        int waitResult = this.kernel.WaitForSingleObject(pointer, dwMilliseconds);
        if (waitResult != 0) {
            throw new RuntimeException("Timeout reading from console input");
        }
        WinKernel32Lib.INPUT_RECORD[] inputEvents = new WinKernel32Lib.INPUT_RECORD[1];
        IntByReference eventsRead = new IntByReference();
        this.kernel.ReadConsoleInput(this.stdinHandle, inputEvents, inputEvents.length, eventsRead);
        WinKernel32Lib.INPUT_RECORD iNPUT_RECORD = inputEvents[0];
        if (iNPUT_RECORD == null) {
            throw new RuntimeException("Error reading from console input");
        }
        WinKernel32Lib.INPUT_RECORD inputEvent2 = iNPUT_RECORD;
        short s = inputEvent2.EventType;
        if (s == 1) {
            WinKernel32Lib.INPUT_RECORD.EventUnion eventUnion = inputEvent2.Event;
            Intrinsics.checkNotNull(eventUnion);
            WinKernel32Lib.KEY_EVENT_RECORD kEY_EVENT_RECORD = eventUnion.KeyEvent;
            Intrinsics.checkNotNull(kEY_EVENT_RECORD);
            WinKernel32Lib.KEY_EVENT_RECORD keyEvent = kEY_EVENT_RECORD;
            boolean bl = keyEvent.bKeyDown;
            short s2 = UShort.constructor-impl(keyEvent.wVirtualKeyCode);
            WinKernel32Lib.UnionChar unionChar = keyEvent.uChar;
            Intrinsics.checkNotNull(unionChar);
            eventRecord = new TerminalInterfaceWindows.EventRecord.Key(bl, s2, unionChar.UnicodeChar, UInt.constructor-impl(keyEvent.dwControlKeyState), null);
        } else if (s == 2) {
            WinKernel32Lib.INPUT_RECORD.EventUnion eventUnion = inputEvent2.Event;
            Intrinsics.checkNotNull(eventUnion);
            WinKernel32Lib.MOUSE_EVENT_RECORD mOUSE_EVENT_RECORD = eventUnion.MouseEvent;
            Intrinsics.checkNotNull(mOUSE_EVENT_RECORD);
            WinKernel32Lib.MOUSE_EVENT_RECORD mouseEvent = mOUSE_EVENT_RECORD;
            WinKernel32Lib.COORD cOORD = mouseEvent.dwMousePosition;
            Intrinsics.checkNotNull(cOORD);
            short s3 = cOORD.X;
            WinKernel32Lib.COORD cOORD2 = mouseEvent.dwMousePosition;
            Intrinsics.checkNotNull(cOORD2);
            eventRecord = new TerminalInterfaceWindows.EventRecord.Mouse(s3, cOORD2.Y, UInt.constructor-impl(mouseEvent.dwButtonState), UInt.constructor-impl(mouseEvent.dwControlKeyState), UInt.constructor-impl(mouseEvent.dwEventFlags), null);
        } else {
            eventRecord = null;
        }
        return eventRecord;
    }
}

