# specInfo.tcl -- PDF-like information for DVI files with TkDVI
# Copyright  2001 Anselm Lingnau <anselm@strathspey.org>
# See file COPYING for conditions on use and distribution.
# $Id: specInfo.tcl,v 1.2 2001/08/10 09:22:21 anselm Exp $

namespace eval ::tkdvi::browser::special {}

option add *m.file.l_info {Document &Info} userDefault
option add *m.file.t_info cascade userDefault
option add *m.file.m_info info userDefault

option add *m.file.info.entrylist {general - fonts} userDefault
option add *m.file.info.l_general {&General ...} userDefault
option add *m.file.info.c_general {::tkdvi::browser::info::general %T} userDefault
option add *m.file.info.l_fonts {&Fonts ...} userDefault
option add *m.file.info.c_fonts {::tkdvi::browser::info::fonts %T} userDefault

::tkdvi::menu::extra file info

proc ::tkdvi::browser::special::info {name key x y cookie s} {
    variable ::tkdvi::browser::State

    if {[scan $s {info %[^ ]} key] != 1} {
	return
    }
    set State($name-info,$key) \
	    [string range $s [expr {6+[string length $key]}] end]
}

namespace eval ::tkdvi::browser::info {}

proc ::tkdvi::browser::info::general {name} {
    variable ::tkdvi::browser::State

    set c $State($name-code)
    set f [$c info filename]
    set State($name-info,file) $f
    set State($name-info,comment) [$c info comment]
    set State($name-info,modified) [clock format [file mtime $f] -format %c]
    set State($name-info,size) [file size $f]

    set keys {file title subject author keywords producer modified size}

    destroy $State($name-top).info
    set t [toplevel $State($name-top).info]
    wm title $t [::msgcat::mc {Info: %s} [file tail [file rootname $f]]]

    set row 0
    foreach kk [concat $keys [array names State $name-info,*]] {
	regsub "^$name-info," $kk {} k
	if {[info exists seen($k)] || ![info exists State($name-info,$k)]} {
	    continue
	}
	if {[catch {set title [string totitle $k]}]} {
	    set title $k
	}
	label $t.k$row -anchor e -text [::msgcat::mc $title:]
	label $t.v$row -anchor w -text $State($name-info,$k)
	grid $t.k$row $t.v$row -sticky we -padx 3
	set seen($k) 1
	incr row
    }

    frame $t.sep -relief sunken -borderwidth 1 -height 2
    grid $t.sep -row $row -column 0 -columnspan 2 -sticky we -pady 3
    incr row

    frame $t.button
    button $t.button.ok -text OK -command [list destroy $t]
    pack $t.button.ok -pady 5
    grid $t.button -row $row -column 0 -columnspan 2 -sticky we
}

proc ::tkdvi::browser::info::fonts {name} {
    variable ::tkdvi::browser::State

    destroy $State($name-top).finfo
    set t [toplevel $State($name-top).finfo -class FontInfo]
    wm title $t [::msgcat::mc {Fonts: %s} \
	    [file tail [file rootname [$State($name-code) info filename]]]]

    frame $t.button
    button $t.button.ok -text OK -command [list destroy $t]
    pack $t.button.ok -side top -pady 5
    pack $t.button -side bottom

    listbox $t.list -width 40 -background white -yscrollcommand "$t.sy set"
    scrollbar $t.sy -orient vertical -command "$t.list yview"
    foreach f [$State($name-dvi0,i) fonts] {
	foreach {num info} $f break
	foreach {name dpi atsize size format refcount file} $info break
	set scale [expr {double($atsize)/double($size)}]
	$t.list insert end [format \
		{%-12s %6.3f %-2s %d %s} \
		$name $scale $format $refcount $file]
    }
    pack $t.sy -side right -fill y
    pack $t.list -side top -fill both -expand yes

    # frame $t.sep -relief sunken -borderwidth 1 -height 2
    # pack $t.sep -side top -fill x -pady 3
}

package provide tkdvi::browser::special::info 1.0
