/*	$NetBSD: gfx_7_0_d.h,v 1.3 2021/12/18 23:45:14 riastradh Exp $	*/

/*
 * GFX_7_0 Register documentation
 *
 * Copyright (C) 2014  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef GFX_7_0_D_H
#define GFX_7_0_D_H

#define mmCB_BLEND_RED                                                          0xa105
#define mmCB_BLEND_GREEN                                                        0xa106
#define mmCB_BLEND_BLUE                                                         0xa107
#define mmCB_BLEND_ALPHA                                                        0xa108
#define mmCB_COLOR_CONTROL                                                      0xa202
#define mmCB_BLEND0_CONTROL                                                     0xa1e0
#define mmCB_BLEND1_CONTROL                                                     0xa1e1
#define mmCB_BLEND2_CONTROL                                                     0xa1e2
#define mmCB_BLEND3_CONTROL                                                     0xa1e3
#define mmCB_BLEND4_CONTROL                                                     0xa1e4
#define mmCB_BLEND5_CONTROL                                                     0xa1e5
#define mmCB_BLEND6_CONTROL                                                     0xa1e6
#define mmCB_BLEND7_CONTROL                                                     0xa1e7
#define mmCB_COLOR0_BASE                                                        0xa318
#define mmCB_COLOR1_BASE                                                        0xa327
#define mmCB_COLOR2_BASE                                                        0xa336
#define mmCB_COLOR3_BASE                                                        0xa345
#define mmCB_COLOR4_BASE                                                        0xa354
#define mmCB_COLOR5_BASE                                                        0xa363
#define mmCB_COLOR6_BASE                                                        0xa372
#define mmCB_COLOR7_BASE                                                        0xa381
#define mmCB_COLOR0_PITCH                                                       0xa319
#define mmCB_COLOR1_PITCH                                                       0xa328
#define mmCB_COLOR2_PITCH                                                       0xa337
#define mmCB_COLOR3_PITCH                                                       0xa346
#define mmCB_COLOR4_PITCH                                                       0xa355
#define mmCB_COLOR5_PITCH                                                       0xa364
#define mmCB_COLOR6_PITCH                                                       0xa373
#define mmCB_COLOR7_PITCH                                                       0xa382
#define mmCB_COLOR0_SLICE                                                       0xa31a
#define mmCB_COLOR1_SLICE                                                       0xa329
#define mmCB_COLOR2_SLICE                                                       0xa338
#define mmCB_COLOR3_SLICE                                                       0xa347
#define mmCB_COLOR4_SLICE                                                       0xa356
#define mmCB_COLOR5_SLICE                                                       0xa365
#define mmCB_COLOR6_SLICE                                                       0xa374
#define mmCB_COLOR7_SLICE                                                       0xa383
#define mmCB_COLOR0_VIEW                                                        0xa31b
#define mmCB_COLOR1_VIEW                                                        0xa32a
#define mmCB_COLOR2_VIEW                                                        0xa339
#define mmCB_COLOR3_VIEW                                                        0xa348
#define mmCB_COLOR4_VIEW                                                        0xa357
#define mmCB_COLOR5_VIEW                                                        0xa366
#define mmCB_COLOR6_VIEW                                                        0xa375
#define mmCB_COLOR7_VIEW                                                        0xa384
#define mmCB_COLOR0_INFO                                                        0xa31c
#define mmCB_COLOR1_INFO                                                        0xa32b
#define mmCB_COLOR2_INFO                                                        0xa33a
#define mmCB_COLOR3_INFO                                                        0xa349
#define mmCB_COLOR4_INFO                                                        0xa358
#define mmCB_COLOR5_INFO                                                        0xa367
#define mmCB_COLOR6_INFO                                                        0xa376
#define mmCB_COLOR7_INFO                                                        0xa385
#define mmCB_COLOR0_ATTRIB                                                      0xa31d
#define mmCB_COLOR1_ATTRIB                                                      0xa32c
#define mmCB_COLOR2_ATTRIB                                                      0xa33b
#define mmCB_COLOR3_ATTRIB                                                      0xa34a
#define mmCB_COLOR4_ATTRIB                                                      0xa359
#define mmCB_COLOR5_ATTRIB                                                      0xa368
#define mmCB_COLOR6_ATTRIB                                                      0xa377
#define mmCB_COLOR7_ATTRIB                                                      0xa386
#define mmCB_COLOR0_CMASK                                                       0xa31f
#define mmCB_COLOR1_CMASK                                                       0xa32e
#define mmCB_COLOR2_CMASK                                                       0xa33d
#define mmCB_COLOR3_CMASK                                                       0xa34c
#define mmCB_COLOR4_CMASK                                                       0xa35b
#define mmCB_COLOR5_CMASK                                                       0xa36a
#define mmCB_COLOR6_CMASK                                                       0xa379
#define mmCB_COLOR7_CMASK                                                       0xa388
#define mmCB_COLOR0_CMASK_SLICE                                                 0xa320
#define mmCB_COLOR1_CMASK_SLICE                                                 0xa32f
#define mmCB_COLOR2_CMASK_SLICE                                                 0xa33e
#define mmCB_COLOR3_CMASK_SLICE                                                 0xa34d
#define mmCB_COLOR4_CMASK_SLICE                                                 0xa35c
#define mmCB_COLOR5_CMASK_SLICE                                                 0xa36b
#define mmCB_COLOR6_CMASK_SLICE                                                 0xa37a
#define mmCB_COLOR7_CMASK_SLICE                                                 0xa389
#define mmCB_COLOR0_FMASK                                                       0xa321
#define mmCB_COLOR1_FMASK                                                       0xa330
#define mmCB_COLOR2_FMASK                                                       0xa33f
#define mmCB_COLOR3_FMASK                                                       0xa34e
#define mmCB_COLOR4_FMASK                                                       0xa35d
#define mmCB_COLOR5_FMASK                                                       0xa36c
#define mmCB_COLOR6_FMASK                                                       0xa37b
#define mmCB_COLOR7_FMASK                                                       0xa38a
#define mmCB_COLOR0_FMASK_SLICE                                                 0xa322
#define mmCB_COLOR1_FMASK_SLICE                                                 0xa331
#define mmCB_COLOR2_FMASK_SLICE                                                 0xa340
#define mmCB_COLOR3_FMASK_SLICE                                                 0xa34f
#define mmCB_COLOR4_FMASK_SLICE                                                 0xa35e
#define mmCB_COLOR5_FMASK_SLICE                                                 0xa36d
#define mmCB_COLOR6_FMASK_SLICE                                                 0xa37c
#define mmCB_COLOR7_FMASK_SLICE                                                 0xa38b
#define mmCB_COLOR0_CLEAR_WORD0                                                 0xa323
#define mmCB_COLOR1_CLEAR_WORD0                                                 0xa332
#define mmCB_COLOR2_CLEAR_WORD0                                                 0xa341
#define mmCB_COLOR3_CLEAR_WORD0                                                 0xa350
#define mmCB_COLOR4_CLEAR_WORD0                                                 0xa35f
#define mmCB_COLOR5_CLEAR_WORD0                                                 0xa36e
#define mmCB_COLOR6_CLEAR_WORD0                                                 0xa37d
#define mmCB_COLOR7_CLEAR_WORD0                                                 0xa38c
#define mmCB_COLOR0_CLEAR_WORD1                                                 0xa324
#define mmCB_COLOR1_CLEAR_WORD1                                                 0xa333
#define mmCB_COLOR2_CLEAR_WORD1                                                 0xa342
#define mmCB_COLOR3_CLEAR_WORD1                                                 0xa351
#define mmCB_COLOR4_CLEAR_WORD1                                                 0xa360
#define mmCB_COLOR5_CLEAR_WORD1                                                 0xa36f
#define mmCB_COLOR6_CLEAR_WORD1                                                 0xa37e
#define mmCB_COLOR7_CLEAR_WORD1                                                 0xa38d
#define mmCB_TARGET_MASK                                                        0xa08e
#define mmCB_SHADER_MASK                                                        0xa08f
#define mmCB_HW_CONTROL                                                         0x2684
#define mmCB_HW_CONTROL_1                                                       0x2685
#define mmCB_HW_CONTROL_2                                                       0x2686
#define mmCB_HW_CONTROL_3                                                       0x2683
#define mmCB_PERFCOUNTER_FILTER                                                 0xdc00
#define mmCB_PERFCOUNTER0_SELECT                                                0xdc01
#define mmCB_PERFCOUNTER0_SELECT1                                               0xdc02
#define mmCB_PERFCOUNTER1_SELECT                                                0xdc03
#define mmCB_PERFCOUNTER2_SELECT                                                0xdc04
#define mmCB_PERFCOUNTER3_SELECT                                                0xdc05
#define mmCB_PERFCOUNTER0_LO                                                    0xd406
#define mmCB_PERFCOUNTER1_LO                                                    0xd408
#define mmCB_PERFCOUNTER2_LO                                                    0xd40a
#define mmCB_PERFCOUNTER3_LO                                                    0xd40c
#define mmCB_PERFCOUNTER0_HI                                                    0xd407
#define mmCB_PERFCOUNTER1_HI                                                    0xd409
#define mmCB_PERFCOUNTER2_HI                                                    0xd40b
#define mmCB_PERFCOUNTER3_HI                                                    0xd40d
#define mmCB_CGTT_SCLK_CTRL                                                     0xf0a8
#define mmCB_DEBUG_BUS_1                                                        0x2699
#define mmCB_DEBUG_BUS_2                                                        0x269a
#define mmCB_DEBUG_BUS_3                                                        0x269b
#define mmCB_DEBUG_BUS_4                                                        0x269c
#define mmCB_DEBUG_BUS_5                                                        0x269d
#define mmCB_DEBUG_BUS_6                                                        0x269e
#define mmCB_DEBUG_BUS_7                                                        0x269f
#define mmCB_DEBUG_BUS_8                                                        0x26a0
#define mmCB_DEBUG_BUS_9                                                        0x26a1
#define mmCB_DEBUG_BUS_10                                                       0x26a2
#define mmCB_DEBUG_BUS_11                                                       0x26a3
#define mmCB_DEBUG_BUS_12                                                       0x26a4
#define mmCB_DEBUG_BUS_13                                                       0x26a5
#define mmCB_DEBUG_BUS_14                                                       0x26a6
#define mmCB_DEBUG_BUS_15                                                       0x26a7
#define mmCB_DEBUG_BUS_16                                                       0x26a8
#define mmCB_DEBUG_BUS_17                                                       0x26a9
#define mmCB_DEBUG_BUS_18                                                       0x26aa
#define mmCP_DFY_CNTL                                                           0x3020
#define mmCP_DFY_STAT                                                           0x3021
#define mmCP_DFY_ADDR_HI                                                        0x3022
#define mmCP_DFY_ADDR_LO                                                        0x3023
#define mmCP_DFY_DATA_0                                                         0x3024
#define mmCP_DFY_DATA_1                                                         0x3025
#define mmCP_DFY_DATA_2                                                         0x3026
#define mmCP_DFY_DATA_3                                                         0x3027
#define mmCP_DFY_DATA_4                                                         0x3028
#define mmCP_DFY_DATA_5                                                         0x3029
#define mmCP_DFY_DATA_6                                                         0x302a
#define mmCP_DFY_DATA_7                                                         0x302b
#define mmCP_DFY_DATA_8                                                         0x302c
#define mmCP_DFY_DATA_9                                                         0x302d
#define mmCP_DFY_DATA_10                                                        0x302e
#define mmCP_DFY_DATA_11                                                        0x302f
#define mmCP_DFY_DATA_12                                                        0x3030
#define mmCP_DFY_DATA_13                                                        0x3031
#define mmCP_DFY_DATA_14                                                        0x3032
#define mmCP_DFY_DATA_15                                                        0x3033
#define mmCP_RB0_BASE                                                           0x3040
#define mmCP_RB0_BASE_HI                                                        0x30b1
#define mmCP_RB_BASE                                                            0x3040
#define mmCP_RB1_BASE                                                           0x3060
#define mmCP_RB1_BASE_HI                                                        0x30b2
#define mmCP_RB2_BASE                                                           0x3065
#define mmCP_RB0_CNTL                                                           0x3041
#define mmCP_RB_CNTL                                                            0x3041
#define mmCP_RB1_CNTL                                                           0x3061
#define mmCP_RB2_CNTL                                                           0x3066
#define mmCP_RB_RPTR_WR                                                         0x3042
#define mmCP_RB0_RPTR_ADDR                                                      0x3043
#define mmCP_RB_RPTR_ADDR                                                       0x3043
#define mmCP_RB1_RPTR_ADDR                                                      0x3062
#define mmCP_RB2_RPTR_ADDR                                                      0x3067
#define mmCP_RB0_RPTR_ADDR_HI                                                   0x3044
#define mmCP_RB_RPTR_ADDR_HI                                                    0x3044
#define mmCP_RB1_RPTR_ADDR_HI                                                   0x3063
#define mmCP_RB2_RPTR_ADDR_HI                                                   0x3068
#define mmCP_RB0_WPTR                                                           0x3045
#define mmCP_RB_WPTR                                                            0x3045
#define mmCP_RB1_WPTR                                                           0x3064
#define mmCP_RB2_WPTR                                                           0x3069
#define mmCP_RB_WPTR_POLL_ADDR_LO                                               0x3046
#define mmCP_RB_WPTR_POLL_ADDR_HI                                               0x3047
#define mmGC_PRIV_MODE                                                          0x3048
#define mmCP_INT_CNTL                                                           0x3049
#define mmCP_INT_CNTL_RING0                                                     0x306a
#define mmCP_INT_CNTL_RING1                                                     0x306b
#define mmCP_INT_CNTL_RING2                                                     0x306c
#define mmCP_INT_STATUS                                                         0x304a
#define mmCP_INT_STATUS_RING0                                                   0x306d
#define mmCP_INT_STATUS_RING1                                                   0x306e
#define mmCP_INT_STATUS_RING2                                                   0x306f
#define mmCP_DEVICE_ID                                                          0x304b
#define mmCP_RING_PRIORITY_CNTS                                                 0x304c
#define mmCP_ME0_PIPE_PRIORITY_CNTS                                             0x304c
#define mmCP_RING0_PRIORITY                                                     0x304d
#define mmCP_ME0_PIPE0_PRIORITY                                                 0x304d
#define mmCP_RING1_PRIORITY                                                     0x304e
#define mmCP_ME0_PIPE1_PRIORITY                                                 0x304e
#define mmCP_RING2_PRIORITY                                                     0x304f
#define mmCP_ME0_PIPE2_PRIORITY                                                 0x304f
#define mmCP_ENDIAN_SWAP                                                        0x3050
#define mmCP_RB_VMID                                                            0x3051
#define mmCP_PFP_UCODE_ADDR                                                     0x3054
#define mmCP_PFP_UCODE_DATA                                                     0x3055
#define mmCP_ME_RAM_RADDR                                                       0x3056
#define mmCP_ME_RAM_WADDR                                                       0x3057
#define mmCP_ME_RAM_DATA                                                        0x3058
#define mmCGTT_CPC_CLK_CTRL                                                     0xf0b2
#define mmCGTT_CPF_CLK_CTRL                                                     0xf0b1
#define mmCGTT_CP_CLK_CTRL                                                      0xf0b0
#define mmCP_CE_UCODE_ADDR                                                      0x305a
#define mmCP_CE_UCODE_DATA                                                      0x305b
#define mmCP_MEC_ME1_UCODE_ADDR                                                 0x305c
#define mmCP_MEC_ME1_UCODE_DATA                                                 0x305d
#define mmCP_MEC_ME2_UCODE_ADDR                                                 0x305e
#define mmCP_MEC_ME2_UCODE_DATA                                                 0x305f
#define mmCP_PWR_CNTL                                                           0x3078
#define mmCP_MEM_SLP_CNTL                                                       0x3079
#define mmCP_ECC_FIRSTOCCURRENCE                                                0x307a
#define mmCP_ECC_FIRSTOCCURRENCE_RING0                                          0x307b
#define mmCP_ECC_FIRSTOCCURRENCE_RING1                                          0x307c
#define mmCP_ECC_FIRSTOCCURRENCE_RING2                                          0x307d
#define mmCP_CPF_DEBUG                                                          0x3080
#define mmCP_FETCHER_SOURCE                                                     0x3082
#define mmCP_PQ_WPTR_POLL_CNTL                                                  0x3083
#define mmCP_PQ_WPTR_POLL_CNTL1                                                 0x3084
#define mmCPC_INT_CNTL                                                          0x30b4
#define mmCP_ME1_PIPE0_INT_CNTL                                                 0x3085
#define mmCP_ME1_PIPE1_INT_CNTL                                                 0x3086
#define mmCP_ME1_PIPE2_INT_CNTL                                                 0x3087
#define mmCP_ME1_PIPE3_INT_CNTL                                                 0x3088
#define mmCP_ME2_PIPE0_INT_CNTL                                                 0x3089
#define mmCP_ME2_PIPE1_INT_CNTL                                                 0x308a
#define mmCP_ME2_PIPE2_INT_CNTL                                                 0x308b
#define mmCP_ME2_PIPE3_INT_CNTL                                                 0x308c
#define mmCPC_INT_STATUS                                                        0x30b5
#define mmCP_ME1_PIPE0_INT_STATUS                                               0x308d
#define mmCP_ME1_PIPE1_INT_STATUS                                               0x308e
#define mmCP_ME1_PIPE2_INT_STATUS                                               0x308f
#define mmCP_ME1_PIPE3_INT_STATUS                                               0x3090
#define mmCP_ME2_PIPE0_INT_STATUS                                               0x3091
#define mmCP_ME2_PIPE1_INT_STATUS                                               0x3092
#define mmCP_ME2_PIPE2_INT_STATUS                                               0x3093
#define mmCP_ME2_PIPE3_INT_STATUS                                               0x3094
#define mmCP_ME1_INT_STAT_DEBUG                                                 0x3095
#define mmCP_ME2_INT_STAT_DEBUG                                                 0x3096
#define mmCP_ME1_PIPE_PRIORITY_CNTS                                             0x3099
#define mmCP_ME1_PIPE0_PRIORITY                                                 0x309a
#define mmCP_ME1_PIPE1_PRIORITY                                                 0x309b
#define mmCP_ME1_PIPE2_PRIORITY                                                 0x309c
#define mmCP_ME1_PIPE3_PRIORITY                                                 0x309d
#define mmCP_ME2_PIPE_PRIORITY_CNTS                                             0x309e
#define mmCP_ME2_PIPE0_PRIORITY                                                 0x309f
#define mmCP_ME2_PIPE1_PRIORITY                                                 0x30a0
#define mmCP_ME2_PIPE2_PRIORITY                                                 0x30a1
#define mmCP_ME2_PIPE3_PRIORITY                                                 0x30a2
#define mmCP_CE_PRGRM_CNTR_START                                                0x30a3
#define mmCP_PFP_PRGRM_CNTR_START                                               0x30a4
#define mmCP_ME_PRGRM_CNTR_START                                                0x30a5
#define mmCP_MEC1_PRGRM_CNTR_START                                              0x30a6
#define mmCP_MEC2_PRGRM_CNTR_START                                              0x30a7
#define mmCP_CE_INTR_ROUTINE_START                                              0x30a8
#define mmCP_PFP_INTR_ROUTINE_START                                             0x30a9
#define mmCP_ME_INTR_ROUTINE_START                                              0x30aa
#define mmCP_MEC1_INTR_ROUTINE_START                                            0x30ab
#define mmCP_MEC2_INTR_ROUTINE_START                                            0x30ac
#define mmCP_CONTEXT_CNTL                                                       0x30ad
#define mmCP_MAX_CONTEXT                                                        0x30ae
#define mmCP_IQ_WAIT_TIME1                                                      0x30af
#define mmCP_IQ_WAIT_TIME2                                                      0x30b0
#define mmCP_VMID_RESET                                                         0x30b3
#define mmCP_VMID_PREEMPT                                                       0x30b6
#define mmCP_PQ_STATUS                                                          0x30b8
#define mmCP_CPC_STATUS                                                         0x2084
#define mmCP_CPC_BUSY_STAT                                                      0x2085
#define mmCP_CPC_STALLED_STAT1                                                  0x2086
#define mmCP_CPF_STATUS                                                         0x2087
#define mmCP_CPF_BUSY_STAT                                                      0x2088
#define mmCP_CPF_STALLED_STAT1                                                  0x2089
#define mmCP_CPC_MC_CNTL                                                        0x208a
#define mmCP_CPC_GRBM_FREE_COUNT                                                0x208b
#define mmCP_MEC_CNTL                                                           0x208d
#define mmCP_MEC_ME1_HEADER_DUMP                                                0x208e
#define mmCP_MEC_ME2_HEADER_DUMP                                                0x208f
#define mmCP_CPC_SCRATCH_INDEX                                                  0x2090
#define mmCP_CPC_SCRATCH_DATA                                                   0x2091
#define mmCPG_PERFCOUNTER1_SELECT                                               0xd800
#define mmCPG_PERFCOUNTER1_LO                                                   0xd000
#define mmCPG_PERFCOUNTER1_HI                                                   0xd001
#define mmCPG_PERFCOUNTER0_SELECT1                                              0xd801
#define mmCPG_PERFCOUNTER0_SELECT                                               0xd802
#define mmCPG_PERFCOUNTER0_LO                                                   0xd002
#define mmCPG_PERFCOUNTER0_HI                                                   0xd003
#define mmCPC_PERFCOUNTER1_SELECT                                               0xd803
#define mmCPC_PERFCOUNTER1_LO                                                   0xd004
#define mmCPC_PERFCOUNTER1_HI                                                   0xd005
#define mmCPC_PERFCOUNTER0_SELECT1                                              0xd804
#define mmCPC_PERFCOUNTER0_SELECT                                               0xd809
#define mmCPC_PERFCOUNTER0_LO                                                   0xd006
#define mmCPC_PERFCOUNTER0_HI                                                   0xd007
#define mmCPF_PERFCOUNTER1_SELECT                                               0xd805
#define mmCPF_PERFCOUNTER1_LO                                                   0xd008
#define mmCPF_PERFCOUNTER1_HI                                                   0xd009
#define mmCPF_PERFCOUNTER0_SELECT1                                              0xd806
#define mmCPF_PERFCOUNTER0_SELECT                                               0xd807
#define mmCPF_PERFCOUNTER0_LO                                                   0xd00a
#define mmCPF_PERFCOUNTER0_HI                                                   0xd00b
#define mmCP_CPC_HALT_HYST_COUNT                                                0x20a7
#define mmCP_CE_COMPARE_COUNT                                                   0x20c0
#define mmCP_CE_DE_COUNT                                                        0x20c1
#define mmCP_DE_CE_COUNT                                                        0x20c2
#define mmCP_DE_LAST_INVAL_COUNT                                                0x20c3
#define mmCP_DE_DE_COUNT                                                        0x20c4
#define mmCP_EOP_DONE_EVENT_CNTL                                                0xc0d5
#define mmCP_EOP_DONE_DATA_CNTL                                                 0xc0d6
#define mmCP_EOP_DONE_ADDR_LO                                                   0xc000
#define mmCP_EOP_DONE_ADDR_HI                                                   0xc001
#define mmCP_EOP_DONE_DATA_LO                                                   0xc002
#define mmCP_EOP_DONE_DATA_HI                                                   0xc003
#define mmCP_EOP_LAST_FENCE_LO                                                  0xc004
#define mmCP_EOP_LAST_FENCE_HI                                                  0xc005
#define mmCP_STREAM_OUT_ADDR_LO                                                 0xc006
#define mmCP_STREAM_OUT_ADDR_HI                                                 0xc007
#define mmCP_NUM_PRIM_WRITTEN_COUNT0_LO                                         0xc008
#define mmCP_NUM_PRIM_WRITTEN_COUNT0_HI                                         0xc009
#define mmCP_NUM_PRIM_NEEDED_COUNT0_LO                                          0xc00a
#define mmCP_NUM_PRIM_NEEDED_COUNT0_HI                                          0xc00b
#define mmCP_NUM_PRIM_WRITTEN_COUNT1_LO                                         0xc00c
#define mmCP_NUM_PRIM_WRITTEN_COUNT1_HI                                         0xc00d
#define mmCP_NUM_PRIM_NEEDED_COUNT1_LO                                          0xc00e
#define mmCP_NUM_PRIM_NEEDED_COUNT1_HI                                          0xc00f
#define mmCP_NUM_PRIM_WRITTEN_COUNT2_LO                                         0xc010
#define mmCP_NUM_PRIM_WRITTEN_COUNT2_HI                                         0xc011
#define mmCP_NUM_PRIM_NEEDED_COUNT2_LO                                          0xc012
#define mmCP_NUM_PRIM_NEEDED_COUNT2_HI                                          0xc013
#define mmCP_NUM_PRIM_WRITTEN_COUNT3_LO                                         0xc014
#define mmCP_NUM_PRIM_WRITTEN_COUNT3_HI                                         0xc015
#define mmCP_NUM_PRIM_NEEDED_COUNT3_LO                                          0xc016
#define mmCP_NUM_PRIM_NEEDED_COUNT3_HI                                          0xc017
#define mmCP_PIPE_STATS_ADDR_LO                                                 0xc018
#define mmCP_PIPE_STATS_ADDR_HI                                                 0xc019
#define mmCP_VGT_IAVERT_COUNT_LO                                                0xc01a
#define mmCP_VGT_IAVERT_COUNT_HI                                                0xc01b
#define mmCP_VGT_IAPRIM_COUNT_LO                                                0xc01c
#define mmCP_VGT_IAPRIM_COUNT_HI                                                0xc01d
#define mmCP_VGT_GSPRIM_COUNT_LO                                                0xc01e
#define mmCP_VGT_GSPRIM_COUNT_HI                                                0xc01f
#define mmCP_VGT_VSINVOC_COUNT_LO                                               0xc020
#define mmCP_VGT_VSINVOC_COUNT_HI                                               0xc021
#define mmCP_VGT_GSINVOC_COUNT_LO                                               0xc022
#define mmCP_VGT_GSINVOC_COUNT_HI                                               0xc023
#define mmCP_VGT_HSINVOC_COUNT_LO                                               0xc024
#define mmCP_VGT_HSINVOC_COUNT_HI                                               0xc025
#define mmCP_VGT_DSINVOC_COUNT_LO                                               0xc026
#define mmCP_VGT_DSINVOC_COUNT_HI                                               0xc027
#define mmCP_PA_CINVOC_COUNT_LO                                                 0xc028
#define mmCP_PA_CINVOC_COUNT_HI                                                 0xc029
#define mmCP_PA_CPRIM_COUNT_LO                                                  0xc02a
#define mmCP_PA_CPRIM_COUNT_HI                                                  0xc02b
#define mmCP_SC_PSINVOC_COUNT0_LO                                               0xc02c
#define mmCP_SC_PSINVOC_COUNT0_HI                                               0xc02d
#define mmCP_SC_PSINVOC_COUNT1_LO                                               0xc02e
#define mmCP_SC_PSINVOC_COUNT1_HI                                               0xc02f
#define mmCP_VGT_CSINVOC_COUNT_LO                                               0xc030
#define mmCP_VGT_CSINVOC_COUNT_HI                                               0xc031
#define mmCP_STRMOUT_CNTL                                                       0xc03f
#define mmSCRATCH_REG0                                                          0xc040
#define mmSCRATCH_REG1                                                          0xc041
#define mmSCRATCH_REG2                                                          0xc042
#define mmSCRATCH_REG3                                                          0xc043
#define mmSCRATCH_REG4                                                          0xc044
#define mmSCRATCH_REG5                                                          0xc045
#define mmSCRATCH_REG6                                                          0xc046
#define mmSCRATCH_REG7                                                          0xc047
#define mmSCRATCH_UMSK                                                          0xc050
#define mmSCRATCH_ADDR                                                          0xc051
#define mmCP_PFP_ATOMIC_PREOP_LO                                                0xc052
#define mmCP_PFP_ATOMIC_PREOP_HI                                                0xc053
#define mmCP_PFP_GDS_ATOMIC0_PREOP_LO                                           0xc054
#define mmCP_PFP_GDS_ATOMIC0_PREOP_HI                                           0xc055
#define mmCP_PFP_GDS_ATOMIC1_PREOP_LO                                           0xc056
#define mmCP_PFP_GDS_ATOMIC1_PREOP_HI                                           0xc057
#define mmCP_APPEND_ADDR_LO                                                     0xc058
#define mmCP_APPEND_ADDR_HI                                                     0xc059
#define mmCP_APPEND_DATA                                                        0xc05a
#define mmCP_APPEND_LAST_CS_FENCE                                               0xc05b
#define mmCP_APPEND_LAST_PS_FENCE                                               0xc05c
#define mmCP_ATOMIC_PREOP_LO                                                    0xc05d
#define mmCP_ME_ATOMIC_PREOP_LO                                                 0xc05d
#define mmCP_ATOMIC_PREOP_HI                                                    0xc05e
#define mmCP_ME_ATOMIC_PREOP_HI                                                 0xc05e
#define mmCP_GDS_ATOMIC0_PREOP_LO                                               0xc05f
#define mmCP_ME_GDS_ATOMIC0_PREOP_LO                                            0xc05f
#define mmCP_GDS_ATOMIC0_PREOP_HI                                               0xc060
#define mmCP_ME_GDS_ATOMIC0_PREOP_HI                                            0xc060
#define mmCP_GDS_ATOMIC1_PREOP_LO                                               0xc061
#define mmCP_ME_GDS_ATOMIC1_PREOP_LO                                            0xc061
#define mmCP_GDS_ATOMIC1_PREOP_HI                                               0xc062
#define mmCP_ME_GDS_ATOMIC1_PREOP_HI                                            0xc062
#define mmCP_ME_MC_WADDR_LO                                                     0xc069
#define mmCP_ME_MC_WADDR_HI                                                     0xc06a
#define mmCP_ME_MC_WDATA_LO                                                     0xc06b
#define mmCP_ME_MC_WDATA_HI                                                     0xc06c
#define mmCP_ME_MC_RADDR_LO                                                     0xc06d
#define mmCP_ME_MC_RADDR_HI                                                     0xc06e
#define mmCP_SEM_WAIT_TIMER                                                     0xc06f
#define mmCP_SIG_SEM_ADDR_LO                                                    0xc070
#define mmCP_SIG_SEM_ADDR_HI                                                    0xc071
#define mmCP_SEM_INCOMPLETE_TIMER_CNTL                                          0xc072
#define mmCP_WAIT_SEM_STATUS                                                    0xc073
#define mmCP_WAIT_SEM_ADDR_LO                                                   0xc075
#define mmCP_WAIT_SEM_ADDR_HI                                                   0xc076
#define mmCP_WAIT_REG_MEM_TIMEOUT                                               0xc074
#define mmCP_COHER_START_DELAY                                                  0xc07b
#define mmCP_COHER_CNTL                                                         0xc07c
#define mmCP_COHER_SIZE                                                         0xc07d
#define mmCP_COHER_SIZE_HI                                                      0xc08c
#define mmCP_COHER_BASE                                                         0xc07e
#define mmCP_COHER_BASE_HI                                                      0xc079
#define mmCP_COHER_STATUS                                                       0xc07f
#define mmCOHER_DEST_BASE_0                                                     0xa092
#define mmCOHER_DEST_BASE_1                                                     0xa093
#define mmCOHER_DEST_BASE_2                                                     0xa07e
#define mmCOHER_DEST_BASE_3                                                     0xa07f
#define mmCOHER_DEST_BASE_HI_0                                                  0xa07a
#define mmCOHER_DEST_BASE_HI_1                                                  0xa07b
#define mmCOHER_DEST_BASE_HI_2                                                  0xa07c
#define mmCOHER_DEST_BASE_HI_3                                                  0xa07d
#define mmCP_DMA_ME_SRC_ADDR                                                    0xc080
#define mmCP_DMA_ME_SRC_ADDR_HI                                                 0xc081
#define mmCP_DMA_ME_DST_ADDR                                                    0xc082
#define mmCP_DMA_ME_DST_ADDR_HI                                                 0xc083
#define mmCP_DMA_ME_CONTROL                                                     0xc078
#define mmCP_DMA_ME_COMMAND                                                     0xc084
#define mmCP_DMA_PFP_SRC_ADDR                                                   0xc085
#define mmCP_DMA_PFP_SRC_ADDR_HI                                                0xc086
#define mmCP_DMA_PFP_DST_ADDR                                                   0xc087
#define mmCP_DMA_PFP_DST_ADDR_HI                                                0xc088
#define mmCP_DMA_PFP_CONTROL                                                    0xc077
#define mmCP_DMA_PFP_COMMAND                                                    0xc089
#define mmCP_DMA_CNTL                                                           0xc08a
#define mmCP_DMA_READ_TAGS                                                      0xc08b
#define mmCP_PFP_IB_CONTROL                                                     0xc08d
#define mmCP_PFP_LOAD_CONTROL                                                   0xc08e
#define mmCP_SCRATCH_INDEX                                                      0xc08f
#define mmCP_SCRATCH_DATA                                                       0xc090
#define mmCP_RB_OFFSET                                                          0xc091
#define mmCP_IB1_OFFSET                                                         0xc092
#define mmCP_IB2_OFFSET                                                         0xc093
#define mmCP_IB1_PREAMBLE_BEGIN                                                 0xc094
#define mmCP_IB1_PREAMBLE_END                                                   0xc095
#define mmCP_IB2_PREAMBLE_BEGIN                                                 0xc096
#define mmCP_IB2_PREAMBLE_END                                                   0xc097
#define mmCP_STALLED_STAT1                                                      0x219d
#define mmCP_STALLED_STAT2                                                      0x219e
#define mmCP_STALLED_STAT3                                                      0x219c
#define mmCP_BUSY_STAT                                                          0x219f
#define mmCP_STAT                                                               0x21a0
#define mmCP_ME_HEADER_DUMP                                                     0x21a1
#define mmCP_PFP_HEADER_DUMP                                                    0x21a2
#define mmCP_GRBM_FREE_COUNT                                                    0x21a3
#define mmCP_CE_HEADER_DUMP                                                     0x21a4
#define mmCP_MC_PACK_DELAY_CNT                                                  0x21a7
#define mmCP_MC_TAG_CNTL                                                        0x21a8
#define mmCP_MC_TAG_DATA                                                        0x21a9
#define mmCP_CSF_STAT                                                           0x21b4
#define mmCP_CSF_CNTL                                                           0x21b5
#define mmCP_ME_CNTL                                                            0x21b6
#define mmCP_CNTX_STAT                                                          0x21b8
#define mmCP_ME_PREEMPTION                                                      0x21b9
#define mmCP_RB0_RPTR                                                           0x21c0
#define mmCP_RB_RPTR                                                            0x21c0
#define mmCP_RB1_RPTR                                                           0x21bf
#define mmCP_RB2_RPTR                                                           0x21be
#define mmCP_RB_WPTR_DELAY                                                      0x21c1
#define mmCP_RB_WPTR_POLL_CNTL                                                  0x21c2
#define mmCP_CE_INIT_BASE_LO                                                    0xc0c3
#define mmCP_CE_INIT_BASE_HI                                                    0xc0c4
#define mmCP_CE_INIT_BUFSZ                                                      0xc0c5
#define mmCP_CE_IB1_BASE_LO                                                     0xc0c6
#define mmCP_CE_IB1_BASE_HI                                                     0xc0c7
#define mmCP_CE_IB1_BUFSZ                                                       0xc0c8
#define mmCP_CE_IB2_BASE_LO                                                     0xc0c9
#define mmCP_CE_IB2_BASE_HI                                                     0xc0ca
#define mmCP_CE_IB2_BUFSZ                                                       0xc0cb
#define mmCP_IB1_BASE_LO                                                        0xc0cc
#define mmCP_IB1_BASE_HI                                                        0xc0cd
#define mmCP_IB1_BUFSZ                                                          0xc0ce
#define mmCP_IB2_BASE_LO                                                        0xc0cf
#define mmCP_IB2_BASE_HI                                                        0xc0d0
#define mmCP_IB2_BUFSZ                                                          0xc0d1
#define mmCP_ST_BASE_LO                                                         0xc0d2
#define mmCP_ST_BASE_HI                                                         0xc0d3
#define mmCP_ST_BUFSZ                                                           0xc0d4
#define mmCP_ROQ_THRESHOLDS                                                     0x21bc
#define mmCP_MEQ_STQ_THRESHOLD                                                  0x21bd
#define mmCP_ROQ1_THRESHOLDS                                                    0x21d5
#define mmCP_ROQ2_THRESHOLDS                                                    0x21d6
#define mmCP_STQ_THRESHOLDS                                                     0x21d7
#define mmCP_QUEUE_THRESHOLDS                                                   0x21d8
#define mmCP_MEQ_THRESHOLDS                                                     0x21d9
#define mmCP_ROQ_AVAIL                                                          0x21da
#define mmCP_STQ_AVAIL                                                          0x21db
#define mmCP_ROQ2_AVAIL                                                         0x21dc
#define mmCP_MEQ_AVAIL                                                          0x21dd
#define mmCP_CMD_INDEX                                                          0x21de
#define mmCP_CMD_DATA                                                           0x21df
#define mmCP_ROQ_RB_STAT                                                        0x21e0
#define mmCP_ROQ_IB1_STAT                                                       0x21e1
#define mmCP_ROQ_IB2_STAT                                                       0x21e2
#define mmCP_STQ_STAT                                                           0x21e3
#define mmCP_STQ_WR_STAT                                                        0x21e4
#define mmCP_MEQ_STAT                                                           0x21e5
#define mmCP_CEQ1_AVAIL                                                         0x21e6
#define mmCP_CEQ2_AVAIL                                                         0x21e7
#define mmCP_CE_ROQ_RB_STAT                                                     0x21e8
#define mmCP_CE_ROQ_IB1_STAT                                                    0x21e9
#define mmCP_CE_ROQ_IB2_STAT                                                    0x21ea
#define mmCP_INT_STAT_DEBUG                                                     0x21f7
#define mmCP_PERFMON_CNTL                                                       0xd808
#define mmCP_PERFMON_CNTX_CNTL                                                  0xa0d8
#define mmCP_RINGID                                                             0xa0d9
#define mmCP_PIPEID                                                             0xa0d9
#define mmCP_VMID                                                               0xa0da
#define mmCP_HPD_ROQ_OFFSETS                                                    0x3240
#define mmCP_HPD_EOP_BASE_ADDR                                                  0x3241
#define mmCP_HPD_EOP_BASE_ADDR_HI                                               0x3242
#define mmCP_HPD_EOP_VMID                                                       0x3243
#define mmCP_HPD_EOP_CONTROL                                                    0x3244
#define mmCP_MQD_BASE_ADDR                                                      0x3245
#define mmCP_MQD_BASE_ADDR_HI                                                   0x3246
#define mmCP_HQD_ACTIVE                                                         0x3247
#define mmCP_HQD_VMID                                                           0x3248
#define mmCP_HQD_PERSISTENT_STATE                                               0x3249
#define mmCP_HQD_PIPE_PRIORITY                                                  0x324a
#define mmCP_HQD_QUEUE_PRIORITY                                                 0x324b
#define mmCP_HQD_QUANTUM                                                        0x324c
#define mmCP_HQD_PQ_BASE                                                        0x324d
#define mmCP_HQD_PQ_BASE_HI                                                     0x324e
#define mmCP_HQD_PQ_RPTR                                                        0x324f
#define mmCP_HQD_PQ_RPTR_REPORT_ADDR                                            0x3250
#define mmCP_HQD_PQ_RPTR_REPORT_ADDR_HI                                         0x3251
#define mmCP_HQD_PQ_WPTR_POLL_ADDR                                              0x3252
#define mmCP_HQD_PQ_WPTR_POLL_ADDR_HI                                           0x3253
#define mmCP_HQD_PQ_DOORBELL_CONTROL                                            0x3254
#define mmCP_HQD_PQ_WPTR                                                        0x3255
#define mmCP_HQD_PQ_CONTROL                                                     0x3256
#define mmCP_HQD_IB_BASE_ADDR                                                   0x3257
#define mmCP_HQD_IB_BASE_ADDR_HI                                                0x3258
#define mmCP_HQD_IB_RPTR                                                        0x3259
#define mmCP_HQD_IB_CONTROL                                                     0x325a
#define mmCP_HQD_IQ_TIMER                                                       0x325b
#define mmCP_HQD_IQ_RPTR                                                        0x325c
#define mmCP_HQD_DEQUEUE_REQUEST                                                0x325d
#define mmCP_HQD_DMA_OFFLOAD                                                    0x325e
#define mmCP_HQD_SEMA_CMD                                                       0x325f
#define mmCP_HQD_MSG_TYPE                                                       0x3260
#define mmCP_HQD_ATOMIC0_PREOP_LO                                               0x3261
#define mmCP_HQD_ATOMIC0_PREOP_HI                                               0x3262
#define mmCP_HQD_ATOMIC1_PREOP_LO                                               0x3263
#define mmCP_HQD_ATOMIC1_PREOP_HI                                               0x3264
#define mmCP_HQD_HQ_SCHEDULER0                                                  0x3265
#define mmCP_HQD_HQ_SCHEDULER1                                                  0x3266
#define mmCP_MQD_CONTROL                                                        0x3267
#define mmDB_Z_READ_BASE                                                        0xa012
#define mmDB_STENCIL_READ_BASE                                                  0xa013
#define mmDB_Z_WRITE_BASE                                                       0xa014
#define mmDB_STENCIL_WRITE_BASE                                                 0xa015
#define mmDB_DEPTH_INFO                                                         0xa00f
#define mmDB_Z_INFO                                                             0xa010
#define mmDB_STENCIL_INFO                                                       0xa011
#define mmDB_DEPTH_SIZE                                                         0xa016
#define mmDB_DEPTH_SLICE                                                        0xa017
#define mmDB_DEPTH_VIEW                                                         0xa002
#define mmDB_RENDER_CONTROL                                                     0xa000
#define mmDB_COUNT_CONTROL                                                      0xa001
#define mmDB_RENDER_OVERRIDE                                                    0xa003
#define mmDB_RENDER_OVERRIDE2                                                   0xa004
#define mmDB_EQAA                                                               0xa201
#define mmDB_SHADER_CONTROL                                                     0xa203
#define mmDB_DEPTH_BOUNDS_MIN                                                   0xa008
#define mmDB_DEPTH_BOUNDS_MAX                                                   0xa009
#define mmDB_STENCIL_CLEAR                                                      0xa00a
#define mmDB_DEPTH_CLEAR                                                        0xa00b
#define mmDB_HTILE_DATA_BASE                                                    0xa005
#define mmDB_HTILE_SURFACE                                                      0xa2af
#define mmDB_PRELOAD_CONTROL                                                    0xa2b2
#define mmDB_STENCILREFMASK                                                     0xa10c
#define mmDB_STENCILREFMASK_BF                                                  0xa10d
#define mmDB_SRESULTS_COMPARE_STATE0                                            0xa2b0
#define mmDB_SRESULTS_COMPARE_STATE1                                            0xa2b1
#define mmDB_DEPTH_CONTROL                                                      0xa200
#define mmDB_STENCIL_CONTROL                                                    0xa10b
#define mmDB_ALPHA_TO_MASK                                                      0xa2dc
#define mmDB_PERFCOUNTER0_SELECT                                                0xdc40
#define mmDB_PERFCOUNTER1_SELECT                                                0xdc42
#define mmDB_PERFCOUNTER2_SELECT                                                0xdc44
#define mmDB_PERFCOUNTER3_SELECT                                                0xdc46
#define mmDB_PERFCOUNTER0_SELECT1                                               0xdc41
#define mmDB_PERFCOUNTER1_SELECT1                                               0xdc43
#define mmDB_PERFCOUNTER0_LO                                                    0xd440
#define mmDB_PERFCOUNTER1_LO                                                    0xd442
#define mmDB_PERFCOUNTER2_LO                                                    0xd444
#define mmDB_PERFCOUNTER3_LO                                                    0xd446
#define mmDB_PERFCOUNTER0_HI                                                    0xd441
#define mmDB_PERFCOUNTER1_HI                                                    0xd443
#define mmDB_PERFCOUNTER2_HI                                                    0xd445
#define mmDB_PERFCOUNTER3_HI                                                    0xd447
#define mmDB_DEBUG                                                              0x260c
#define mmDB_DEBUG2                                                             0x260d
#define mmDB_DEBUG3                                                             0x260e
#define mmDB_DEBUG4                                                             0x260f
#define mmDB_CREDIT_LIMIT                                                       0x2614
#define mmDB_WATERMARKS                                                         0x2615
#define mmDB_SUBTILE_CONTROL                                                    0x2616
#define mmDB_FREE_CACHELINES                                                    0x2617
#define mmDB_FIFO_DEPTH1                                                        0x2618
#define mmDB_FIFO_DEPTH2                                                        0x2619
#define mmDB_CGTT_CLK_CTRL_0                                                    0xf0a4
#define mmDB_ZPASS_COUNT_LOW                                                    0xc3fe
#define mmDB_ZPASS_COUNT_HI                                                     0xc3ff
#define mmDB_RING_CONTROL                                                       0x261b
#define mmDB_READ_DEBUG_0                                                       0x2620
#define mmDB_READ_DEBUG_1                                                       0x2621
#define mmDB_READ_DEBUG_2                                                       0x2622
#define mmDB_READ_DEBUG_3                                                       0x2623
#define mmDB_READ_DEBUG_4                                                       0x2624
#define mmDB_READ_DEBUG_5                                                       0x2625
#define mmDB_READ_DEBUG_6                                                       0x2626
#define mmDB_READ_DEBUG_7                                                       0x2627
#define mmDB_READ_DEBUG_8                                                       0x2628
#define mmDB_READ_DEBUG_9                                                       0x2629
#define mmDB_READ_DEBUG_A                                                       0x262a
#define mmDB_READ_DEBUG_B                                                       0x262b
#define mmDB_READ_DEBUG_C                                                       0x262c
#define mmDB_READ_DEBUG_D                                                       0x262d
#define mmDB_READ_DEBUG_E                                                       0x262e
#define mmDB_READ_DEBUG_F                                                       0x262f
#define mmDB_OCCLUSION_COUNT0_LOW                                               0xc3c0
#define mmDB_OCCLUSION_COUNT0_HI                                                0xc3c1
#define mmDB_OCCLUSION_COUNT1_LOW                                               0xc3c2
#define mmDB_OCCLUSION_COUNT1_HI                                                0xc3c3
#define mmDB_OCCLUSION_COUNT2_LOW                                               0xc3c4
#define mmDB_OCCLUSION_COUNT2_HI                                                0xc3c5
#define mmDB_OCCLUSION_COUNT3_LOW                                               0xc3c6
#define mmDB_OCCLUSION_COUNT3_HI                                                0xc3c7
#define mmCC_RB_REDUNDANCY                                                      0x263c
#define mmCC_RB_BACKEND_DISABLE                                                 0x263d
#define mmGC_USER_RB_REDUNDANCY                                                 0x26de
#define mmGC_USER_RB_BACKEND_DISABLE                                            0x26df
#define mmGB_ADDR_CONFIG                                                        0x263e
#define mmGB_BACKEND_MAP                                                        0x263f
#define mmGB_GPU_ID                                                             0x2640
#define mmCC_RB_DAISY_CHAIN                                                     0x2641
#define mmGB_TILE_MODE0                                                         0x2644
#define mmGB_TILE_MODE1                                                         0x2645
#define mmGB_TILE_MODE2                                                         0x2646
#define mmGB_TILE_MODE3                                                         0x2647
#define mmGB_TILE_MODE4                                                         0x2648
#define mmGB_TILE_MODE5                                                         0x2649
#define mmGB_TILE_MODE6                                                         0x264a
#define mmGB_TILE_MODE7                                                         0x264b
#define mmGB_TILE_MODE8                                                         0x264c
#define mmGB_TILE_MODE9                                                         0x264d
#define mmGB_TILE_MODE10                                                        0x264e
#define mmGB_TILE_MODE11                                                        0x264f
#define mmGB_TILE_MODE12                                                        0x2650
#define mmGB_TILE_MODE13                                                        0x2651
#define mmGB_TILE_MODE14                                                        0x2652
#define mmGB_TILE_MODE15                                                        0x2653
#define mmGB_TILE_MODE16                                                        0x2654
#define mmGB_TILE_MODE17                                                        0x2655
#define mmGB_TILE_MODE18                                                        0x2656
#define mmGB_TILE_MODE19                                                        0x2657
#define mmGB_TILE_MODE20                                                        0x2658
#define mmGB_TILE_MODE21                                                        0x2659
#define mmGB_TILE_MODE22                                                        0x265a
#define mmGB_TILE_MODE23                                                        0x265b
#define mmGB_TILE_MODE24                                                        0x265c
#define mmGB_TILE_MODE25                                                        0x265d
#define mmGB_TILE_MODE26                                                        0x265e
#define mmGB_TILE_MODE27                                                        0x265f
#define mmGB_TILE_MODE28                                                        0x2660
#define mmGB_TILE_MODE29                                                        0x2661
#define mmGB_TILE_MODE30                                                        0x2662
#define mmGB_TILE_MODE31                                                        0x2663
#define mmGB_MACROTILE_MODE0                                                    0x2664
#define mmGB_MACROTILE_MODE1                                                    0x2665
#define mmGB_MACROTILE_MODE2                                                    0x2666
#define mmGB_MACROTILE_MODE3                                                    0x2667
#define mmGB_MACROTILE_MODE4                                                    0x2668
#define mmGB_MACROTILE_MODE5                                                    0x2669
#define mmGB_MACROTILE_MODE6                                                    0x266a
#define mmGB_MACROTILE_MODE7                                                    0x266b
#define mmGB_MACROTILE_MODE8                                                    0x266c
#define mmGB_MACROTILE_MODE9                                                    0x266d
#define mmGB_MACROTILE_MODE10                                                   0x266e
#define mmGB_MACROTILE_MODE11                                                   0x266f
#define mmGB_MACROTILE_MODE12                                                   0x2670
#define mmGB_MACROTILE_MODE13                                                   0x2671
#define mmGB_MACROTILE_MODE14                                                   0x2672
#define mmGB_MACROTILE_MODE15                                                   0x2673
#define mmGB_EDC_MODE                                                           0x307e
#define mmCC_GC_EDC_CONFIG                                                      0x3098
#define mmRAS_SIGNATURE_CONTROL                                                 0x3380
#define mmRAS_SIGNATURE_MASK                                                    0x3381
#define mmRAS_SX_SIGNATURE0                                                     0x3382
#define mmRAS_SX_SIGNATURE1                                                     0x3383
#define mmRAS_SX_SIGNATURE2                                                     0x3384
#define mmRAS_SX_SIGNATURE3                                                     0x3385
#define mmRAS_DB_SIGNATURE0                                                     0x338b
#define mmRAS_PA_SIGNATURE0                                                     0x338c
#define mmRAS_VGT_SIGNATURE0                                                    0x338d
#define mmRAS_SQ_SIGNATURE0                                                     0x338e
#define mmRAS_SC_SIGNATURE0                                                     0x338f
#define mmRAS_SC_SIGNATURE1                                                     0x3390
#define mmRAS_SC_SIGNATURE2                                                     0x3391
#define mmRAS_SC_SIGNATURE3                                                     0x3392
#define mmRAS_SC_SIGNATURE4                                                     0x3393
#define mmRAS_SC_SIGNATURE5                                                     0x3394
#define mmRAS_SC_SIGNATURE6                                                     0x3395
#define mmRAS_SC_SIGNATURE7                                                     0x3396
#define mmRAS_IA_SIGNATURE0                                                     0x3397
#define mmRAS_IA_SIGNATURE1                                                     0x3398
#define mmRAS_SPI_SIGNATURE0                                                    0x3399
#define mmRAS_SPI_SIGNATURE1                                                    0x339a
#define mmRAS_TA_SIGNATURE0                                                     0x339b
#define mmRAS_TD_SIGNATURE0                                                     0x339c
#define mmRAS_CB_SIGNATURE0                                                     0x339d
#define mmRAS_BCI_SIGNATURE0                                                    0x339e
#define mmRAS_BCI_SIGNATURE1                                                    0x339f
#define mmGRBM_CAM_INDEX                                                        0x3000
#define mmGRBM_CAM_DATA                                                         0x3001
#define mmGRBM_CNTL                                                             0x2000
#define mmGRBM_SKEW_CNTL                                                        0x2001
#define mmGRBM_PWR_CNTL                                                         0x2003
#define mmGRBM_STATUS                                                           0x2004
#define mmGRBM_STATUS2                                                          0x2002
#define mmGRBM_STATUS_SE0                                                       0x2005
#define mmGRBM_STATUS_SE1                                                       0x2006
#define mmGRBM_STATUS_SE2                                                       0x200e
#define mmGRBM_STATUS_SE3                                                       0x200f
#define mmGRBM_SOFT_RESET                                                       0x2008
#define mmGRBM_DEBUG_CNTL                                                       0x2009
#define mmGRBM_DEBUG_DATA                                                       0x200a
#define mmGRBM_GFX_INDEX                                                        0xc200
#define mmGRBM_GFX_CLKEN_CNTL                                                   0x200c
#define mmGRBM_WAIT_IDLE_CLOCKS                                                 0x200d
#define mmGRBM_DEBUG                                                            0x2014
#define mmGRBM_DEBUG_SNAPSHOT                                                   0x2015
#define mmGRBM_READ_ERROR                                                       0x2016
#define mmGRBM_READ_ERROR2                                                      0x2017
#define mmGRBM_INT_CNTL                                                         0x2018
#define mmGRBM_PERFCOUNTER0_SELECT                                              0xd840
#define mmGRBM_PERFCOUNTER1_SELECT                                              0xd841
#define mmGRBM_SE0_PERFCOUNTER_SELECT                                           0xd842
#define mmGRBM_SE1_PERFCOUNTER_SELECT                                           0xd843
#define mmGRBM_SE2_PERFCOUNTER_SELECT                                           0xd844
#define mmGRBM_SE3_PERFCOUNTER_SELECT                                           0xd845
#define mmGRBM_PERFCOUNTER0_LO                                                  0xd040
#define mmGRBM_PERFCOUNTER0_HI                                                  0xd041
#define mmGRBM_PERFCOUNTER1_LO                                                  0xd043
#define mmGRBM_PERFCOUNTER1_HI                                                  0xd044
#define mmGRBM_SE0_PERFCOUNTER_LO                                               0xd045
#define mmGRBM_SE0_PERFCOUNTER_HI                                               0xd046
#define mmGRBM_SE1_PERFCOUNTER_LO                                               0xd047
#define mmGRBM_SE1_PERFCOUNTER_HI                                               0xd048
#define mmGRBM_SE2_PERFCOUNTER_LO                                               0xd049
#define mmGRBM_SE2_PERFCOUNTER_HI                                               0xd04a
#define mmGRBM_SE3_PERFCOUNTER_LO                                               0xd04b
#define mmGRBM_SE3_PERFCOUNTER_HI                                               0xd04c
#define mmGRBM_SCRATCH_REG0                                                     0x2040
#define mmGRBM_SCRATCH_REG1                                                     0x2041
#define mmGRBM_SCRATCH_REG2                                                     0x2042
#define mmGRBM_SCRATCH_REG3                                                     0x2043
#define mmGRBM_SCRATCH_REG4                                                     0x2044
#define mmGRBM_SCRATCH_REG5                                                     0x2045
#define mmGRBM_SCRATCH_REG6                                                     0x2046
#define mmGRBM_SCRATCH_REG7                                                     0x2047
#define mmDEBUG_INDEX                                                           0x203c
#define mmDEBUG_DATA                                                            0x203d
#define mmGRBM_NOWHERE                                                          0x203f
#define mmPA_CL_VPORT_XSCALE                                                    0xa10f
#define mmPA_CL_VPORT_XOFFSET                                                   0xa110
#define mmPA_CL_VPORT_YSCALE                                                    0xa111
#define mmPA_CL_VPORT_YOFFSET                                                   0xa112
#define mmPA_CL_VPORT_ZSCALE                                                    0xa113
#define mmPA_CL_VPORT_ZOFFSET                                                   0xa114
#define mmPA_CL_VPORT_XSCALE_1                                                  0xa115
#define mmPA_CL_VPORT_XSCALE_2                                                  0xa11b
#define mmPA_CL_VPORT_XSCALE_3                                                  0xa121
#define mmPA_CL_VPORT_XSCALE_4                                                  0xa127
#define mmPA_CL_VPORT_XSCALE_5                                                  0xa12d
#define mmPA_CL_VPORT_XSCALE_6                                                  0xa133
#define mmPA_CL_VPORT_XSCALE_7                                                  0xa139
#define mmPA_CL_VPORT_XSCALE_8                                                  0xa13f
#define mmPA_CL_VPORT_XSCALE_9                                                  0xa145
#define mmPA_CL_VPORT_XSCALE_10                                                 0xa14b
#define mmPA_CL_VPORT_XSCALE_11                                                 0xa151
#define mmPA_CL_VPORT_XSCALE_12                                                 0xa157
#define mmPA_CL_VPORT_XSCALE_13                                                 0xa15d
#define mmPA_CL_VPORT_XSCALE_14                                                 0xa163
#define mmPA_CL_VPORT_XSCALE_15                                                 0xa169
#define mmPA_CL_VPORT_XOFFSET_1                                                 0xa116
#define mmPA_CL_VPORT_XOFFSET_2                                                 0xa11c
#define mmPA_CL_VPORT_XOFFSET_3                                                 0xa122
#define mmPA_CL_VPORT_XOFFSET_4                                                 0xa128
#define mmPA_CL_VPORT_XOFFSET_5                                                 0xa12e
#define mmPA_CL_VPORT_XOFFSET_6                                                 0xa134
#define mmPA_CL_VPORT_XOFFSET_7                                                 0xa13a
#define mmPA_CL_VPORT_XOFFSET_8                                                 0xa140
#define mmPA_CL_VPORT_XOFFSET_9                                                 0xa146
#define mmPA_CL_VPORT_XOFFSET_10                                                0xa14c
#define mmPA_CL_VPORT_XOFFSET_11                                                0xa152
#define mmPA_CL_VPORT_XOFFSET_12                                                0xa158
#define mmPA_CL_VPORT_XOFFSET_13                                                0xa15e
#define mmPA_CL_VPORT_XOFFSET_14                                                0xa164
#define mmPA_CL_VPORT_XOFFSET_15                                                0xa16a
#define mmPA_CL_VPORT_YSCALE_1                                                  0xa117
#define mmPA_CL_VPORT_YSCALE_2                                                  0xa11d
#define mmPA_CL_VPORT_YSCALE_3                                                  0xa123
#define mmPA_CL_VPORT_YSCALE_4                                                  0xa129
#define mmPA_CL_VPORT_YSCALE_5                                                  0xa12f
#define mmPA_CL_VPORT_YSCALE_6                                                  0xa135
#define mmPA_CL_VPORT_YSCALE_7                                                  0xa13b
#define mmPA_CL_VPORT_YSCALE_8                                                  0xa141
#define mmPA_CL_VPORT_YSCALE_9                                                  0xa147
#define mmPA_CL_VPORT_YSCALE_10                                                 0xa14d
#define mmPA_CL_VPORT_YSCALE_11                                                 0xa153
#define mmPA_CL_VPORT_YSCALE_12                                                 0xa159
#define mmPA_CL_VPORT_YSCALE_13                                                 0xa15f
#define mmPA_CL_VPORT_YSCALE_14                                                 0xa165
#define mmPA_CL_VPORT_YSCALE_15                                                 0xa16b
#define mmPA_CL_VPORT_YOFFSET_1                                                 0xa118
#define mmPA_CL_VPORT_YOFFSET_2                                                 0xa11e
#define mmPA_CL_VPORT_YOFFSET_3                                                 0xa124
#define mmPA_CL_VPORT_YOFFSET_4                                                 0xa12a
#define mmPA_CL_VPORT_YOFFSET_5                                                 0xa130
#define mmPA_CL_VPORT_YOFFSET_6                                                 0xa136
#define mmPA_CL_VPORT_YOFFSET_7                                                 0xa13c
#define mmPA_CL_VPORT_YOFFSET_8                                                 0xa142
#define mmPA_CL_VPORT_YOFFSET_9                                                 0xa148
#define mmPA_CL_VPORT_YOFFSET_10                                                0xa14e
#define mmPA_CL_VPORT_YOFFSET_11                                                0xa154
#define mmPA_CL_VPORT_YOFFSET_12                                                0xa15a
#define mmPA_CL_VPORT_YOFFSET_13                                                0xa160
#define mmPA_CL_VPORT_YOFFSET_14                                                0xa166
#define mmPA_CL_VPORT_YOFFSET_15                                                0xa16c
#define mmPA_CL_VPORT_ZSCALE_1                                                  0xa119
#define mmPA_CL_VPORT_ZSCALE_2                                                  0xa11f
#define mmPA_CL_VPORT_ZSCALE_3                                                  0xa125
#define mmPA_CL_VPORT_ZSCALE_4                                                  0xa12b
#define mmPA_CL_VPORT_ZSCALE_5                                                  0xa131
#define mmPA_CL_VPORT_ZSCALE_6                                                  0xa137
#define mmPA_CL_VPORT_ZSCALE_7                                                  0xa13d
#define mmPA_CL_VPORT_ZSCALE_8                                                  0xa143
#define mmPA_CL_VPORT_ZSCALE_9                                                  0xa149
#define mmPA_CL_VPORT_ZSCALE_10                                                 0xa14f
#define mmPA_CL_VPORT_ZSCALE_11                                                 0xa155
#define mmPA_CL_VPORT_ZSCALE_12                                                 0xa15b
#define mmPA_CL_VPORT_ZSCALE_13                                                 0xa161
#define mmPA_CL_VPORT_ZSCALE_14                                                 0xa167
#define mmPA_CL_VPORT_ZSCALE_15                                                 0xa16d
#define mmPA_CL_VPORT_ZOFFSET_1                                                 0xa11a
#define mmPA_CL_VPORT_ZOFFSET_2                                                 0xa120
#define mmPA_CL_VPORT_ZOFFSET_3                                                 0xa126
#define mmPA_CL_VPORT_ZOFFSET_4                                                 0xa12c
#define mmPA_CL_VPORT_ZOFFSET_5                                                 0xa132
#define mmPA_CL_VPORT_ZOFFSET_6                                                 0xa138
#define mmPA_CL_VPORT_ZOFFSET_7                                                 0xa13e
#define mmPA_CL_VPORT_ZOFFSET_8                                                 0xa144
#define mmPA_CL_VPORT_ZOFFSET_9                                                 0xa14a
#define mmPA_CL_VPORT_ZOFFSET_10                                                0xa150
#define mmPA_CL_VPORT_ZOFFSET_11                                                0xa156
#define mmPA_CL_VPORT_ZOFFSET_12                                                0xa15c
#define mmPA_CL_VPORT_ZOFFSET_13                                                0xa162
#define mmPA_CL_VPORT_ZOFFSET_14                                                0xa168
#define mmPA_CL_VPORT_ZOFFSET_15                                                0xa16e
#define mmPA_CL_VTE_CNTL                                                        0xa206
#define mmPA_CL_VS_OUT_CNTL                                                     0xa207
#define mmPA_CL_NANINF_CNTL                                                     0xa208
#define mmPA_CL_CLIP_CNTL                                                       0xa204
#define mmPA_CL_GB_VERT_CLIP_ADJ                                                0xa2fa
#define mmPA_CL_GB_VERT_DISC_ADJ                                                0xa2fb
#define mmPA_CL_GB_HORZ_CLIP_ADJ                                                0xa2fc
#define mmPA_CL_GB_HORZ_DISC_ADJ                                                0xa2fd
#define mmPA_CL_UCP_0_X                                                         0xa16f
#define mmPA_CL_UCP_0_Y                                                         0xa170
#define mmPA_CL_UCP_0_Z                                                         0xa171
#define mmPA_CL_UCP_0_W                                                         0xa172
#define mmPA_CL_UCP_1_X                                                         0xa173
#define mmPA_CL_UCP_1_Y                                                         0xa174
#define mmPA_CL_UCP_1_Z                                                         0xa175
#define mmPA_CL_UCP_1_W                                                         0xa176
#define mmPA_CL_UCP_2_X                                                         0xa177
#define mmPA_CL_UCP_2_Y                                                         0xa178
#define mmPA_CL_UCP_2_Z                                                         0xa179
#define mmPA_CL_UCP_2_W                                                         0xa17a
#define mmPA_CL_UCP_3_X                                                         0xa17b
#define mmPA_CL_UCP_3_Y                                                         0xa17c
#define mmPA_CL_UCP_3_Z                                                         0xa17d
#define mmPA_CL_UCP_3_W                                                         0xa17e
#define mmPA_CL_UCP_4_X                                                         0xa17f
#define mmPA_CL_UCP_4_Y                                                         0xa180
#define mmPA_CL_UCP_4_Z                                                         0xa181
#define mmPA_CL_UCP_4_W                                                         0xa182
#define mmPA_CL_UCP_5_X                                                         0xa183
#define mmPA_CL_UCP_5_Y                                                         0xa184
#define mmPA_CL_UCP_5_Z                                                         0xa185
#define mmPA_CL_UCP_5_W                                                         0xa186
#define mmPA_CL_POINT_X_RAD                                                     0xa1f5
#define mmPA_CL_POINT_Y_RAD                                                     0xa1f6
#define mmPA_CL_POINT_SIZE                                                      0xa1f7
#define mmPA_CL_POINT_CULL_RAD                                                  0xa1f8
#define mmPA_CL_ENHANCE                                                         0x2285
#define mmPA_CL_RESET_DEBUG                                                     0x2286
#define mmPA_SU_VTX_CNTL                                                        0xa2f9
#define mmPA_SU_POINT_SIZE                                                      0xa280
#define mmPA_SU_POINT_MINMAX                                                    0xa281
#define mmPA_SU_LINE_CNTL                                                       0xa282
#define mmPA_SU_LINE_STIPPLE_CNTL                                               0xa209
#define mmPA_SU_LINE_STIPPLE_SCALE                                              0xa20a
#define mmPA_SU_PRIM_FILTER_CNTL                                                0xa20b
#define mmPA_SU_SC_MODE_CNTL                                                    0xa205
#define mmPA_SU_POLY_OFFSET_DB_FMT_CNTL                                         0xa2de
#define mmPA_SU_POLY_OFFSET_CLAMP                                               0xa2df
#define mmPA_SU_POLY_OFFSET_FRONT_SCALE                                         0xa2e0
#define mmPA_SU_POLY_OFFSET_FRONT_OFFSET                                        0xa2e1
#define mmPA_SU_POLY_OFFSET_BACK_SCALE                                          0xa2e2
#define mmPA_SU_POLY_OFFSET_BACK_OFFSET                                         0xa2e3
#define mmPA_SU_HARDWARE_SCREEN_OFFSET                                          0xa08d
#define mmPA_SU_LINE_STIPPLE_VALUE                                              0xc280
#define mmPA_SU_PERFCOUNTER0_SELECT                                             0xd900
#define mmPA_SU_PERFCOUNTER0_SELECT1                                            0xd901
#define mmPA_SU_PERFCOUNTER1_SELECT                                             0xd902
#define mmPA_SU_PERFCOUNTER1_SELECT1                                            0xd903
#define mmPA_SU_PERFCOUNTER2_SELECT                                             0xd904
#define mmPA_SU_PERFCOUNTER3_SELECT                                             0xd905
#define mmPA_SU_PERFCOUNTER0_LO                                                 0xd100
#define mmPA_SU_PERFCOUNTER0_HI                                                 0xd101
#define mmPA_SU_PERFCOUNTER1_LO                                                 0xd102
#define mmPA_SU_PERFCOUNTER1_HI                                                 0xd103
#define mmPA_SU_PERFCOUNTER2_LO                                                 0xd104
#define mmPA_SU_PERFCOUNTER2_HI                                                 0xd105
#define mmPA_SU_PERFCOUNTER3_LO                                                 0xd106
#define mmPA_SU_PERFCOUNTER3_HI                                                 0xd107
#define mmPA_SC_AA_CONFIG                                                       0xa2f8
#define mmPA_SC_AA_MASK_X0Y0_X1Y0                                               0xa30e
#define mmPA_SC_AA_MASK_X0Y1_X1Y1                                               0xa30f
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0                                     0xa2fe
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1                                     0xa2ff
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2                                     0xa300
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3                                     0xa301
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0                                     0xa302
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1                                     0xa303
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2                                     0xa304
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3                                     0xa305
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0                                     0xa306
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1                                     0xa307
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2                                     0xa308
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3                                     0xa309
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0                                     0xa30a
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1                                     0xa30b
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2                                     0xa30c
#define mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3                                     0xa30d
#define mmPA_SC_CENTROID_PRIORITY_0                                             0xa2f5
#define mmPA_SC_CENTROID_PRIORITY_1                                             0xa2f6
#define mmPA_SC_CLIPRECT_0_TL                                                   0xa084
#define mmPA_SC_CLIPRECT_0_BR                                                   0xa085
#define mmPA_SC_CLIPRECT_1_TL                                                   0xa086
#define mmPA_SC_CLIPRECT_1_BR                                                   0xa087
#define mmPA_SC_CLIPRECT_2_TL                                                   0xa088
#define mmPA_SC_CLIPRECT_2_BR                                                   0xa089
#define mmPA_SC_CLIPRECT_3_TL                                                   0xa08a
#define mmPA_SC_CLIPRECT_3_BR                                                   0xa08b
#define mmPA_SC_CLIPRECT_RULE                                                   0xa083
#define mmPA_SC_EDGERULE                                                        0xa08c
#define mmPA_SC_LINE_CNTL                                                       0xa2f7
#define mmPA_SC_LINE_STIPPLE                                                    0xa283
#define mmPA_SC_MODE_CNTL_0                                                     0xa292
#define mmPA_SC_MODE_CNTL_1                                                     0xa293
#define mmPA_SC_RASTER_CONFIG                                                   0xa0d4
#define mmPA_SC_RASTER_CONFIG_1                                                 0xa0d5
#define mmPA_SC_SCREEN_EXTENT_CONTROL                                           0xa0d6
#define mmPA_SC_GENERIC_SCISSOR_TL                                              0xa090
#define mmPA_SC_GENERIC_SCISSOR_BR                                              0xa091
#define mmPA_SC_SCREEN_SCISSOR_TL                                               0xa00c
#define mmPA_SC_SCREEN_SCISSOR_BR                                               0xa00d
#define mmPA_SC_WINDOW_OFFSET                                                   0xa080
#define mmPA_SC_WINDOW_SCISSOR_TL                                               0xa081
#define mmPA_SC_WINDOW_SCISSOR_BR                                               0xa082
#define mmPA_SC_VPORT_SCISSOR_0_TL                                              0xa094
#define mmPA_SC_VPORT_SCISSOR_1_TL                                              0xa096
#define mmPA_SC_VPORT_SCISSOR_2_TL                                              0xa098
#define mmPA_SC_VPORT_SCISSOR_3_TL                                              0xa09a
#define mmPA_SC_VPORT_SCISSOR_4_TL                                              0xa09c
#define mmPA_SC_VPORT_SCISSOR_5_TL                                              0xa09e
#define mmPA_SC_VPORT_SCISSOR_6_TL                                              0xa0a0
#define mmPA_SC_VPORT_SCISSOR_7_TL                                              0xa0a2
#define mmPA_SC_VPORT_SCISSOR_8_TL                                              0xa0a4
#define mmPA_SC_VPORT_SCISSOR_9_TL                                              0xa0a6
#define mmPA_SC_VPORT_SCISSOR_10_TL                                             0xa0a8
#define mmPA_SC_VPORT_SCISSOR_11_TL                                             0xa0aa
#define mmPA_SC_VPORT_SCISSOR_12_TL                                             0xa0ac
#define mmPA_SC_VPORT_SCISSOR_13_TL                                             0xa0ae
#define mmPA_SC_VPORT_SCISSOR_14_TL                                             0xa0b0
#define mmPA_SC_VPORT_SCISSOR_15_TL                                             0xa0b2
#define mmPA_SC_VPORT_SCISSOR_0_BR                                              0xa095
#define mmPA_SC_VPORT_SCISSOR_1_BR                                              0xa097
#define mmPA_SC_VPORT_SCISSOR_2_BR                                              0xa099
#define mmPA_SC_VPORT_SCISSOR_3_BR                                              0xa09b
#define mmPA_SC_VPORT_SCISSOR_4_BR                                              0xa09d
#define mmPA_SC_VPORT_SCISSOR_5_BR                                              0xa09f
#define mmPA_SC_VPORT_SCISSOR_6_BR                                              0xa0a1
#define mmPA_SC_VPORT_SCISSOR_7_BR                                              0xa0a3
#define mmPA_SC_VPORT_SCISSOR_8_BR                                              0xa0a5
#define mmPA_SC_VPORT_SCISSOR_9_BR                                              0xa0a7
#define mmPA_SC_VPORT_SCISSOR_10_BR                                             0xa0a9
#define mmPA_SC_VPORT_SCISSOR_11_BR                                             0xa0ab
#define mmPA_SC_VPORT_SCISSOR_12_BR                                             0xa0ad
#define mmPA_SC_VPORT_SCISSOR_13_BR                                             0xa0af
#define mmPA_SC_VPORT_SCISSOR_14_BR                                             0xa0b1
#define mmPA_SC_VPORT_SCISSOR_15_BR                                             0xa0b3
#define mmPA_SC_VPORT_ZMIN_0                                                    0xa0b4
#define mmPA_SC_VPORT_ZMIN_1                                                    0xa0b6
#define mmPA_SC_VPORT_ZMIN_2                                                    0xa0b8
#define mmPA_SC_VPORT_ZMIN_3                                                    0xa0ba
#define mmPA_SC_VPORT_ZMIN_4                                                    0xa0bc
#define mmPA_SC_VPORT_ZMIN_5                                                    0xa0be
#define mmPA_SC_VPORT_ZMIN_6                                                    0xa0c0
#define mmPA_SC_VPORT_ZMIN_7                                                    0xa0c2
#define mmPA_SC_VPORT_ZMIN_8                                                    0xa0c4
#define mmPA_SC_VPORT_ZMIN_9                                                    0xa0c6
#define mmPA_SC_VPORT_ZMIN_10                                                   0xa0c8
#define mmPA_SC_VPORT_ZMIN_11                                                   0xa0ca
#define mmPA_SC_VPORT_ZMIN_12                                                   0xa0cc
#define mmPA_SC_VPORT_ZMIN_13                                                   0xa0ce
#define mmPA_SC_VPORT_ZMIN_14                                                   0xa0d0
#define mmPA_SC_VPORT_ZMIN_15                                                   0xa0d2
#define mmPA_SC_VPORT_ZMAX_0                                                    0xa0b5
#define mmPA_SC_VPORT_ZMAX_1                                                    0xa0b7
#define mmPA_SC_VPORT_ZMAX_2                                                    0xa0b9
#define mmPA_SC_VPORT_ZMAX_3                                                    0xa0bb
#define mmPA_SC_VPORT_ZMAX_4                                                    0xa0bd
#define mmPA_SC_VPORT_ZMAX_5                                                    0xa0bf
#define mmPA_SC_VPORT_ZMAX_6                                                    0xa0c1
#define mmPA_SC_VPORT_ZMAX_7                                                    0xa0c3
#define mmPA_SC_VPORT_ZMAX_8                                                    0xa0c5
#define mmPA_SC_VPORT_ZMAX_9                                                    0xa0c7
#define mmPA_SC_VPORT_ZMAX_10                                                   0xa0c9
#define mmPA_SC_VPORT_ZMAX_11                                                   0xa0cb
#define mmPA_SC_VPORT_ZMAX_12                                                   0xa0cd
#define mmPA_SC_VPORT_ZMAX_13                                                   0xa0cf
#define mmPA_SC_VPORT_ZMAX_14                                                   0xa0d1
#define mmPA_SC_VPORT_ZMAX_15                                                   0xa0d3
#define mmPA_SC_ENHANCE                                                         0x22fc
#define mmPA_SC_FIFO_SIZE                                                       0x22f3
#define mmPA_SC_IF_FIFO_SIZE                                                    0x22f5
#define mmPA_SC_FORCE_EOV_MAX_CNTS                                              0x22c9
#define mmPA_SC_LINE_STIPPLE_STATE                                              0xc281
#define mmPA_SC_SCREEN_EXTENT_MIN_0                                             0xc284
#define mmPA_SC_SCREEN_EXTENT_MAX_0                                             0xc285
#define mmPA_SC_SCREEN_EXTENT_MIN_1                                             0xc286
#define mmPA_SC_SCREEN_EXTENT_MAX_1                                             0xc28b
#define mmPA_SC_PERFCOUNTER0_SELECT                                             0xd940
#define mmPA_SC_PERFCOUNTER0_SELECT1                                            0xd941
#define mmPA_SC_PERFCOUNTER1_SELECT                                             0xd942
#define mmPA_SC_PERFCOUNTER2_SELECT                                             0xd943
#define mmPA_SC_PERFCOUNTER3_SELECT                                             0xd944
#define mmPA_SC_PERFCOUNTER4_SELECT                                             0xd945
#define mmPA_SC_PERFCOUNTER5_SELECT                                             0xd946
#define mmPA_SC_PERFCOUNTER6_SELECT                                             0xd947
#define mmPA_SC_PERFCOUNTER7_SELECT                                             0xd948
#define mmPA_SC_PERFCOUNTER0_LO                                                 0xd140
#define mmPA_SC_PERFCOUNTER0_HI                                                 0xd141
#define mmPA_SC_PERFCOUNTER1_LO                                                 0xd142
#define mmPA_SC_PERFCOUNTER1_HI                                                 0xd143
#define mmPA_SC_PERFCOUNTER2_LO                                                 0xd144
#define mmPA_SC_PERFCOUNTER2_HI                                                 0xd145
#define mmPA_SC_PERFCOUNTER3_LO                                                 0xd146
#define mmPA_SC_PERFCOUNTER3_HI                                                 0xd147
#define mmPA_SC_PERFCOUNTER4_LO                                                 0xd148
#define mmPA_SC_PERFCOUNTER4_HI                                                 0xd149
#define mmPA_SC_PERFCOUNTER5_LO                                                 0xd14a
#define mmPA_SC_PERFCOUNTER5_HI                                                 0xd14b
#define mmPA_SC_PERFCOUNTER6_LO                                                 0xd14c
#define mmPA_SC_PERFCOUNTER6_HI                                                 0xd14d
#define mmPA_SC_PERFCOUNTER7_LO                                                 0xd14e
#define mmPA_SC_PERFCOUNTER7_HI                                                 0xd14f
#define mmPA_SC_P3D_TRAP_SCREEN_HV_EN                                           0xc2a0
#define mmPA_SC_P3D_TRAP_SCREEN_H                                               0xc2a1
#define mmPA_SC_P3D_TRAP_SCREEN_V                                               0xc2a2
#define mmPA_SC_P3D_TRAP_SCREEN_OCCURRENCE                                      0xc2a3
#define mmPA_SC_P3D_TRAP_SCREEN_COUNT                                           0xc2a4
#define mmPA_SC_HP3D_TRAP_SCREEN_HV_EN                                          0xc2a8
#define mmPA_SC_HP3D_TRAP_SCREEN_H                                              0xc2a9
#define mmPA_SC_HP3D_TRAP_SCREEN_V                                              0xc2aa
#define mmPA_SC_HP3D_TRAP_SCREEN_OCCURRENCE                                     0xc2ab
#define mmPA_SC_HP3D_TRAP_SCREEN_COUNT                                          0xc2ac
#define mmPA_SC_TRAP_SCREEN_HV_EN                                               0xc2b0
#define mmPA_SC_TRAP_SCREEN_H                                                   0xc2b1
#define mmPA_SC_TRAP_SCREEN_V                                                   0xc2b2
#define mmPA_SC_TRAP_SCREEN_OCCURRENCE                                          0xc2b3
#define mmPA_SC_TRAP_SCREEN_COUNT                                               0xc2b4
#define mmPA_SC_P3D_TRAP_SCREEN_HV_LOCK                                         0x22c0
#define mmPA_SC_HP3D_TRAP_SCREEN_HV_LOCK                                        0x22c1
#define mmPA_SC_TRAP_SCREEN_HV_LOCK                                             0x22c2
#define mmPA_CL_CNTL_STATUS                                                     0x2284
#define mmPA_SU_CNTL_STATUS                                                     0x2294
#define mmPA_SC_FIFO_DEPTH_CNTL                                                 0x2295
#define mmCGTT_PA_CLK_CTRL                                                      0xf088
#define mmCGTT_SC_CLK_CTRL                                                      0xf089
#define mmPA_SU_DEBUG_CNTL                                                      0x2280
#define mmPA_SU_DEBUG_DATA                                                      0x2281
#define mmPA_SC_DEBUG_CNTL                                                      0x22f6
#define mmPA_SC_DEBUG_DATA                                                      0x22f7
#define ixCLIPPER_DEBUG_REG00                                                   0x0
#define ixCLIPPER_DEBUG_REG01                                                   0x1
#define ixCLIPPER_DEBUG_REG02                                                   0x2
#define ixCLIPPER_DEBUG_REG03                                                   0x3
#define ixCLIPPER_DEBUG_REG04                                                   0x4
#define ixCLIPPER_DEBUG_REG05                                                   0x5
#define ixCLIPPER_DEBUG_REG06                                                   0x6
#define ixCLIPPER_DEBUG_REG07                                                   0x7
#define ixCLIPPER_DEBUG_REG08                                                   0x8
#define ixCLIPPER_DEBUG_REG09                                                   0x9
#define ixCLIPPER_DEBUG_REG10                                                   0xa
#define ixCLIPPER_DEBUG_REG11                                                   0xb
#define ixCLIPPER_DEBUG_REG12                                                   0xc
#define ixCLIPPER_DEBUG_REG13                                                   0xd
#define ixCLIPPER_DEBUG_REG14                                                   0xe
#define ixCLIPPER_DEBUG_REG15                                                   0xf
#define ixCLIPPER_DEBUG_REG16                                                   0x10
#define ixCLIPPER_DEBUG_REG17                                                   0x11
#define ixCLIPPER_DEBUG_REG18                                                   0x12
#define ixCLIPPER_DEBUG_REG19                                                   0x13
#define ixSXIFCCG_DEBUG_REG0                                                    0x14
#define ixSXIFCCG_DEBUG_REG1                                                    0x15
#define ixSXIFCCG_DEBUG_REG2                                                    0x16
#define ixSXIFCCG_DEBUG_REG3                                                    0x17
#define ixSETUP_DEBUG_REG0                                                      0x18
#define ixSETUP_DEBUG_REG1                                                      0x19
#define ixSETUP_DEBUG_REG2                                                      0x1a
#define ixSETUP_DEBUG_REG3                                                      0x1b
#define ixSETUP_DEBUG_REG4                                                      0x1c
#define ixSETUP_DEBUG_REG5                                                      0x1d
#define ixPA_SC_DEBUG_REG0                                                      0x0
#define ixPA_SC_DEBUG_REG1                                                      0x1
#define mmCOMPUTE_DISPATCH_INITIATOR                                            0x2e00
#define mmCOMPUTE_DIM_X                                                         0x2e01
#define mmCOMPUTE_DIM_Y                                                         0x2e02
#define mmCOMPUTE_DIM_Z                                                         0x2e03
#define mmCOMPUTE_START_X                                                       0x2e04
#define mmCOMPUTE_START_Y                                                       0x2e05
#define mmCOMPUTE_START_Z                                                       0x2e06
#define mmCOMPUTE_NUM_THREAD_X                                                  0x2e07
#define mmCOMPUTE_NUM_THREAD_Y                                                  0x2e08
#define mmCOMPUTE_NUM_THREAD_Z                                                  0x2e09
#define mmCOMPUTE_PIPELINESTAT_ENABLE                                           0x2e0a
#define mmCOMPUTE_PERFCOUNT_ENABLE                                              0x2e0b
#define mmCOMPUTE_PGM_LO                                                        0x2e0c
#define mmCOMPUTE_PGM_HI                                                        0x2e0d
#define mmCOMPUTE_TBA_LO                                                        0x2e0e
#define mmCOMPUTE_TBA_HI                                                        0x2e0f
#define mmCOMPUTE_TMA_LO                                                        0x2e10
#define mmCOMPUTE_TMA_HI                                                        0x2e11
#define mmCOMPUTE_PGM_RSRC1                                                     0x2e12
#define mmCOMPUTE_PGM_RSRC2                                                     0x2e13
#define mmCOMPUTE_VMID                                                          0x2e14
#define mmCOMPUTE_RESOURCE_LIMITS                                               0x2e15
#define mmCOMPUTE_STATIC_THREAD_MGMT_SE0                                        0x2e16
#define mmCOMPUTE_STATIC_THREAD_MGMT_SE1                                        0x2e17
#define mmCOMPUTE_TMPRING_SIZE                                                  0x2e18
#define mmCOMPUTE_STATIC_THREAD_MGMT_SE2                                        0x2e19
#define mmCOMPUTE_STATIC_THREAD_MGMT_SE3                                        0x2e1a
#define mmCOMPUTE_RESTART_X                                                     0x2e1b
#define mmCOMPUTE_RESTART_Y                                                     0x2e1c
#define mmCOMPUTE_RESTART_Z                                                     0x2e1d
#define mmCOMPUTE_THREAD_TRACE_ENABLE                                           0x2e1e
#define mmCOMPUTE_MISC_RESERVED                                                 0x2e1f
#define mmCOMPUTE_USER_DATA_0                                                   0x2e40
#define mmCOMPUTE_USER_DATA_1                                                   0x2e41
#define mmCOMPUTE_USER_DATA_2                                                   0x2e42
#define mmCOMPUTE_USER_DATA_3                                                   0x2e43
#define mmCOMPUTE_USER_DATA_4                                                   0x2e44
#define mmCOMPUTE_USER_DATA_5                                                   0x2e45
#define mmCOMPUTE_USER_DATA_6                                                   0x2e46
#define mmCOMPUTE_USER_DATA_7                                                   0x2e47
#define mmCOMPUTE_USER_DATA_8                                                   0x2e48
#define mmCOMPUTE_USER_DATA_9                                                   0x2e49
#define mmCOMPUTE_USER_DATA_10                                                  0x2e4a
#define mmCOMPUTE_USER_DATA_11                                                  0x2e4b
#define mmCOMPUTE_USER_DATA_12                                                  0x2e4c
#define mmCOMPUTE_USER_DATA_13                                                  0x2e4d
#define mmCOMPUTE_USER_DATA_14                                                  0x2e4e
#define mmCOMPUTE_USER_DATA_15                                                  0x2e4f
#define mmCSPRIV_CONNECT                                                        0x0
#define mmCSPRIV_THREAD_TRACE_TG0                                               0x1e
#define mmCSPRIV_THREAD_TRACE_TG1                                               0x1e
#define mmCSPRIV_THREAD_TRACE_TG2                                               0x1e
#define mmCSPRIV_THREAD_TRACE_TG3                                               0x1e
#define mmCSPRIV_THREAD_TRACE_EVENT                                             0x1f
#define mmRLC_CNTL                                                              0x30c0
#define mmRLC_DEBUG_SELECT                                                      0x30c1
#define mmRLC_DEBUG                                                             0x30c2
#define mmRLC_MC_CNTL                                                           0x30c3
#define mmRLC_STAT                                                              0x30c4
#define mmRLC_SAFE_MODE                                                         0x313a
#define mmRLC_SOFT_RESET_GPU                                                    0x30c5
#define mmRLC_MEM_SLP_CNTL                                                      0x30c6
#define mmRLC_PERFMON_CNTL                                                      0xdcc0
#define mmRLC_PERFCOUNTER0_SELECT                                               0xdcc1
#define mmRLC_PERFCOUNTER1_SELECT                                               0xdcc2
#define mmRLC_PERFCOUNTER0_LO                                                   0xd480
#define mmRLC_PERFCOUNTER1_LO                                                   0xd482
#define mmRLC_PERFCOUNTER0_HI                                                   0xd481
#define mmRLC_PERFCOUNTER1_HI                                                   0xd483
#define mmCGTT_RLC_CLK_CTRL                                                     0xf0b8
#define mmRLC_LB_CNTL                                                           0x30d9
#define mmRLC_LB_CNTR_MAX                                                       0x30d2
#define mmRLC_LB_CNTR_INIT                                                      0x30db
#define mmRLC_LOAD_BALANCE_CNTR                                                 0x30dc
#define mmRLC_SAVE_AND_RESTORE_BASE                                             0x30dd
#define mmRLC_JUMP_TABLE_RESTORE                                                0x30de
#define mmRLC_DRIVER_CPDMA_STATUS                                               0x30de
#define mmRLC_PG_DELAY_2                                                        0x30df
#define mmRLC_GPM_DEBUG_SELECT                                                  0x30e0
#define mmRLC_GPM_DEBUG                                                         0x30e1
#define mmRLC_GPM_UCODE_ADDR                                                    0x30e2
#define mmRLC_GPM_UCODE_DATA                                                    0x30e3
#define mmRLC_GPU_CLOCK_COUNT_LSB                                               0x30e4
#define mmRLC_GPU_CLOCK_COUNT_MSB                                               0x30e5
#define mmRLC_CAPTURE_GPU_CLOCK_COUNT                                           0x30e6
#define mmRLC_UCODE_CNTL                                                        0x30e7
#define mmRLC_GPM_STAT                                                          0x3100
#define mmRLC_GPU_CLOCK_32_RES_SEL                                              0x3101
#define mmRLC_GPU_CLOCK_32                                                      0x3102
#define mmRLC_PG_CNTL                                                           0x3103
#define mmRLC_GPM_THREAD_PRIORITY                                               0x3104
#define mmRLC_GPM_THREAD_ENABLE                                                 0x3105
#define mmRLC_GPM_VMID_THREAD0                                                  0x3106
#define mmRLC_GPM_VMID_THREAD1                                                  0x3107
#define mmRLC_CGTT_MGCG_OVERRIDE                                                0x3108
#define mmRLC_CGCG_CGLS_CTRL                                                    0x3109
#define mmRLC_CGCG_RAMP_CTRL                                                    0x310a
#define mmRLC_DYN_PG_STATUS                                                     0x310b
#define mmRLC_DYN_PG_REQUEST                                                    0x310c
#define mmRLC_PG_DELAY                                                          0x310d
#define mmRLC_CU_STATUS                                                         0x310e
#define mmRLC_LB_INIT_CU_MASK                                                   0x310f
#define mmRLC_LB_ALWAYS_ACTIVE_CU_MASK                                          0x3110
#define mmRLC_LB_PARAMS                                                         0x3111
#define mmRLC_THREAD1_DELAY                                                     0x3112
#define mmRLC_PG_ALWAYS_ON_CU_MASK                                              0x3113
#define mmRLC_MAX_PG_CU                                                         0x3114
#define mmRLC_AUTO_PG_CTRL                                                      0x3115
#define mmRLC_SMU_GRBM_REG_SAVE_CTRL                                            0x3116
#define mmRLC_SMU_PG_CTRL                                                       0x3117
#define mmRLC_SMU_PG_WAKE_UP_CTRL                                               0x3118
#define mmRLC_SERDES_RD_MASTER_INDEX                                            0x3119
#define mmRLC_SERDES_RD_DATA_0                                                  0x311a
#define mmRLC_SERDES_RD_DATA_1                                                  0x311b
#define mmRLC_SERDES_RD_DATA_2                                                  0x311c
#define mmRLC_SERDES_WR_CU_MASTER_MASK                                          0x311d
#define mmRLC_SERDES_WR_NONCU_MASTER_MASK                                       0x311e
#define mmRLC_SERDES_WR_CTRL                                                    0x311f
#define mmRLC_SERDES_WR_DATA                                                    0x3120
#define mmRLC_SERDES_CU_MASTER_BUSY                                             0x3121
#define mmRLC_SERDES_NONCU_MASTER_BUSY                                          0x3122
#define mmRLC_GPM_GENERAL_0                                                     0x3123
#define mmRLC_GPM_GENERAL_1                                                     0x3124
#define mmRLC_GPM_GENERAL_2                                                     0x3125
#define mmRLC_GPM_GENERAL_3                                                     0x3126
#define mmRLC_GPM_GENERAL_4                                                     0x3127
#define mmRLC_GPM_GENERAL_5                                                     0x3128
#define mmRLC_GPM_GENERAL_6                                                     0x3129
#define mmRLC_GPM_GENERAL_7                                                     0x312a
#define mmRLC_GPM_CU_PD_TIMEOUT                                                 0x312b
#define mmRLC_GPM_SCRATCH_ADDR                                                  0x312c
#define mmRLC_GPM_SCRATCH_DATA                                                  0x312d
#define mmRLC_STATIC_PG_STATUS                                                  0x312e
#define mmRLC_GPM_PERF_COUNT_0                                                  0x312f
#define mmRLC_GPM_PERF_COUNT_1                                                  0x3130
#define mmRLC_GPR_REG1                                                          0x3139
#define mmRLC_GPR_REG2                                                          0x313a
#define mmRLC_SPM_VMID                                                          0x3131
#define mmRLC_SPM_INT_CNTL                                                      0x3132
#define mmRLC_SPM_INT_STATUS                                                    0x3133
#define mmRLC_SPM_DEBUG_SELECT                                                  0x3134
#define mmRLC_SPM_DEBUG                                                         0x3135
#define mmRLC_GPM_LOG_ADDR                                                      0x3136
#define mmRLC_GPM_LOG_SIZE                                                      0x3137
#define mmRLC_GPM_LOG_CONT                                                      0x3138
#define mmRLC_SPM_PERFMON_CNTL                                                  0xdc80
#define mmRLC_SPM_PERFMON_RING_BASE_LO                                          0xdc81
#define mmRLC_SPM_PERFMON_RING_BASE_HI                                          0xdc82
#define mmRLC_SPM_PERFMON_RING_SIZE                                             0xdc83
#define mmRLC_SPM_PERFMON_SEGMENT_SIZE                                          0xdc84
#define mmRLC_SPM_SE_MUXSEL_ADDR                                                0xdc85
#define mmRLC_SPM_SE_MUXSEL_DATA                                                0xdc86
#define mmRLC_SPM_CPG_PERFMON_SAMPLE_DELAY                                      0xdc87
#define mmRLC_SPM_CPC_PERFMON_SAMPLE_DELAY                                      0xdc88
#define mmRLC_SPM_CPF_PERFMON_SAMPLE_DELAY                                      0xdc89
#define mmRLC_SPM_CB_PERFMON_SAMPLE_DELAY                                       0xdc8a
#define mmRLC_SPM_DB_PERFMON_SAMPLE_DELAY                                       0xdc8b
#define mmRLC_SPM_PA_PERFMON_SAMPLE_DELAY                                       0xdc8c
#define mmRLC_SPM_GDS_PERFMON_SAMPLE_DELAY                                      0xdc8d
#define mmRLC_SPM_IA_PERFMON_SAMPLE_DELAY                                       0xdc8e
#define mmRLC_SPM_SC_PERFMON_SAMPLE_DELAY                                       0xdc90
#define mmRLC_SPM_TCC_PERFMON_SAMPLE_DELAY                                      0xdc91
#define mmRLC_SPM_TCA_PERFMON_SAMPLE_DELAY                                      0xdc92
#define mmRLC_SPM_TCP_PERFMON_SAMPLE_DELAY                                      0xdc93
#define mmRLC_SPM_TA_PERFMON_SAMPLE_DELAY                                       0xdc94
#define mmRLC_SPM_TD_PERFMON_SAMPLE_DELAY                                       0xdc95
#define mmRLC_SPM_VGT_PERFMON_SAMPLE_DELAY                                      0xdc96
#define mmRLC_SPM_SPI_PERFMON_SAMPLE_DELAY                                      0xdc97
#define mmRLC_SPM_SQG_PERFMON_SAMPLE_DELAY                                      0xdc98
#define mmRLC_SPM_TCS_PERFMON_SAMPLE_DELAY                                      0xdc99
#define mmRLC_SPM_SX_PERFMON_SAMPLE_DELAY                                       0xdc9a
#define mmRLC_SPM_GLOBAL_MUXSEL_ADDR                                            0xdc9b
#define mmRLC_SPM_GLOBAL_MUXSEL_DATA                                            0xdc9c
#define mmRLC_SPM_RING_RDPTR                                                    0xdc9d
#define mmRLC_SPM_SEGMENT_THRESHOLD                                             0xdc9e
#define mmSPI_PS_INPUT_CNTL_0                                                   0xa191
#define mmSPI_PS_INPUT_CNTL_1                                                   0xa192
#define mmSPI_PS_INPUT_CNTL_2                                                   0xa193
#define mmSPI_PS_INPUT_CNTL_3                                                   0xa194
#define mmSPI_PS_INPUT_CNTL_4                                                   0xa195
#define mmSPI_PS_INPUT_CNTL_5                                                   0xa196
#define mmSPI_PS_INPUT_CNTL_6                                                   0xa197
#define mmSPI_PS_INPUT_CNTL_7                                                   0xa198
#define mmSPI_PS_INPUT_CNTL_8                                                   0xa199
#define mmSPI_PS_INPUT_CNTL_9                                                   0xa19a
#define mmSPI_PS_INPUT_CNTL_10                                                  0xa19b
#define mmSPI_PS_INPUT_CNTL_11                                                  0xa19c
#define mmSPI_PS_INPUT_CNTL_12                                                  0xa19d
#define mmSPI_PS_INPUT_CNTL_13                                                  0xa19e
#define mmSPI_PS_INPUT_CNTL_14                                                  0xa19f
#define mmSPI_PS_INPUT_CNTL_15                                                  0xa1a0
#define mmSPI_PS_INPUT_CNTL_16                                                  0xa1a1
#define mmSPI_PS_INPUT_CNTL_17                                                  0xa1a2
#define mmSPI_PS_INPUT_CNTL_18                                                  0xa1a3
#define mmSPI_PS_INPUT_CNTL_19                                                  0xa1a4
#define mmSPI_PS_INPUT_CNTL_20                                                  0xa1a5
#define mmSPI_PS_INPUT_CNTL_21                                                  0xa1a6
#define mmSPI_PS_INPUT_CNTL_22                                                  0xa1a7
#define mmSPI_PS_INPUT_CNTL_23                                                  0xa1a8
#define mmSPI_PS_INPUT_CNTL_24                                                  0xa1a9
#define mmSPI_PS_INPUT_CNTL_25                                                  0xa1aa
#define mmSPI_PS_INPUT_CNTL_26                                                  0xa1ab
#define mmSPI_PS_INPUT_CNTL_27                                                  0xa1ac
#define mmSPI_PS_INPUT_CNTL_28                                                  0xa1ad
#define mmSPI_PS_INPUT_CNTL_29                                                  0xa1ae
#define mmSPI_PS_INPUT_CNTL_30                                                  0xa1af
#define mmSPI_PS_INPUT_CNTL_31                                                  0xa1b0
#define mmSPI_VS_OUT_CONFIG                                                     0xa1b1
#define mmSPI_PS_INPUT_ENA                                                      0xa1b3
#define mmSPI_PS_INPUT_ADDR                                                     0xa1b4
#define mmSPI_INTERP_CONTROL_0                                                  0xa1b5
#define mmSPI_PS_IN_CONTROL                                                     0xa1b6
#define mmSPI_BARYC_CNTL                                                        0xa1b8
#define mmSPI_TMPRING_SIZE                                                      0xa1ba
#define mmSPI_SHADER_POS_FORMAT                                                 0xa1c3
#define mmSPI_SHADER_Z_FORMAT                                                   0xa1c4
#define mmSPI_SHADER_COL_FORMAT                                                 0xa1c5
#define mmSPI_ARB_PRIORITY                                                      0x31c0
#define mmSPI_ARB_CYCLES_0                                                      0x31c1
#define mmSPI_ARB_CYCLES_1                                                      0x31c2
#define mmSPI_CDBG_SYS_GFX                                                      0x31c3
#define mmSPI_CDBG_SYS_HP3D                                                     0x31c4
#define mmSPI_CDBG_SYS_CS0                                                      0x31c5
#define mmSPI_CDBG_SYS_CS1                                                      0x31c6
#define mmSPI_WCL_PIPE_PERCENT_GFX                                              0x31c7
#define mmSPI_WCL_PIPE_PERCENT_HP3D                                             0x31c8
#define mmSPI_WCL_PIPE_PERCENT_CS0                                              0x31c9
#define mmSPI_WCL_PIPE_PERCENT_CS1                                              0x31ca
#define mmSPI_WCL_PIPE_PERCENT_CS2                                              0x31cb
#define mmSPI_WCL_PIPE_PERCENT_CS3                                              0x31cc
#define mmSPI_WCL_PIPE_PERCENT_CS4                                              0x31cd
#define mmSPI_WCL_PIPE_PERCENT_CS5                                              0x31ce
#define mmSPI_WCL_PIPE_PERCENT_CS6                                              0x31cf
#define mmSPI_WCL_PIPE_PERCENT_CS7                                              0x31d0
#define mmSPI_GDBG_WAVE_CNTL                                                    0x31d1
#define mmSPI_GDBG_TRAP_CONFIG                                                  0x31d2
#define mmSPI_GDBG_TRAP_MASK                                                    0x31d3
#define mmSPI_GDBG_TBA_LO                                                       0x31d4
#define mmSPI_GDBG_TBA_HI                                                       0x31d5
#define mmSPI_GDBG_TMA_LO                                                       0x31d6
#define mmSPI_GDBG_TMA_HI                                                       0x31d7
#define mmSPI_GDBG_TRAP_DATA0                                                   0x31d8
#define mmSPI_GDBG_TRAP_DATA1                                                   0x31d9
#define mmSPI_RESET_DEBUG                                                       0x31da
#define mmSPI_COMPUTE_QUEUE_RESET                                               0x31db
#define mmSPI_RESOURCE_RESERVE_CU_0                                             0x31dc
#define mmSPI_RESOURCE_RESERVE_CU_1                                             0x31dd
#define mmSPI_RESOURCE_RESERVE_CU_2                                             0x31de
#define mmSPI_RESOURCE_RESERVE_CU_3                                             0x31df
#define mmSPI_RESOURCE_RESERVE_CU_4                                             0x31e0
#define mmSPI_RESOURCE_RESERVE_CU_5                                             0x31e1
#define mmSPI_RESOURCE_RESERVE_CU_6                                             0x31e2
#define mmSPI_RESOURCE_RESERVE_CU_7                                             0x31e3
#define mmSPI_RESOURCE_RESERVE_CU_8                                             0x31e4
#define mmSPI_RESOURCE_RESERVE_CU_9                                             0x31e5
#define mmSPI_RESOURCE_RESERVE_EN_CU_0                                          0x31e6
#define mmSPI_RESOURCE_RESERVE_EN_CU_1                                          0x31e7
#define mmSPI_RESOURCE_RESERVE_EN_CU_2                                          0x31e8
#define mmSPI_RESOURCE_RESERVE_EN_CU_3                                          0x31e9
#define mmSPI_RESOURCE_RESERVE_EN_CU_4                                          0x31ea
#define mmSPI_RESOURCE_RESERVE_EN_CU_5                                          0x31eb
#define mmSPI_RESOURCE_RESERVE_EN_CU_6                                          0x31ec
#define mmSPI_RESOURCE_RESERVE_EN_CU_7                                          0x31ed
#define mmSPI_RESOURCE_RESERVE_EN_CU_8                                          0x31ee
#define mmSPI_RESOURCE_RESERVE_EN_CU_9                                          0x31ef
#define mmSPI_PS_MAX_WAVE_ID                                                    0x243a
#define mmSPI_CONFIG_CNTL                                                       0x2440
#define mmSPI_DEBUG_CNTL                                                        0x2441
#define mmSPI_DEBUG_READ                                                        0x2442
#define mmSPI_PERFCOUNTER0_SELECT                                               0xd980
#define mmSPI_PERFCOUNTER1_SELECT                                               0xd981
#define mmSPI_PERFCOUNTER2_SELECT                                               0xd982
#define mmSPI_PERFCOUNTER3_SELECT                                               0xd983
#define mmSPI_PERFCOUNTER0_SELECT1                                              0xd984
#define mmSPI_PERFCOUNTER1_SELECT1                                              0xd985
#define mmSPI_PERFCOUNTER2_SELECT1                                              0xd986
#define mmSPI_PERFCOUNTER3_SELECT1                                              0xd987
#define mmSPI_PERFCOUNTER4_SELECT                                               0xd988
#define mmSPI_PERFCOUNTER5_SELECT                                               0xd989
#define mmSPI_PERFCOUNTER_BINS                                                  0xd98a
#define mmSPI_PERFCOUNTER0_HI                                                   0xd180
#define mmSPI_PERFCOUNTER0_LO                                                   0xd181
#define mmSPI_PERFCOUNTER1_HI                                                   0xd182
#define mmSPI_PERFCOUNTER1_LO                                                   0xd183
#define mmSPI_PERFCOUNTER2_HI                                                   0xd184
#define mmSPI_PERFCOUNTER2_LO                                                   0xd185
#define mmSPI_PERFCOUNTER3_HI                                                   0xd186
#define mmSPI_PERFCOUNTER3_LO                                                   0xd187
#define mmSPI_PERFCOUNTER4_HI                                                   0xd188
#define mmSPI_PERFCOUNTER4_LO                                                   0xd189
#define mmSPI_PERFCOUNTER5_HI                                                   0xd18a
#define mmSPI_PERFCOUNTER5_LO                                                   0xd18b
#define mmSPI_CONFIG_CNTL_1                                                     0x244f
#define mmSPI_DEBUG_BUSY                                                        0x2450
#define mmCGTS_SM_CTRL_REG                                                      0xf000
#define mmCGTS_RD_CTRL_REG                                                      0xf001
#define mmCGTS_RD_REG                                                           0xf002
#define mmCGTS_TCC_DISABLE                                                      0xf003
#define mmCGTS_USER_TCC_DISABLE                                                 0xf004
#define mmCGTS_CU0_SP0_CTRL_REG                                                 0xf008
#define mmCGTS_CU0_LDS_SQ_CTRL_REG                                              0xf009
#define mmCGTS_CU0_TA_SQC_CTRL_REG                                              0xf00a
#define mmCGTS_CU0_SP1_CTRL_REG                                                 0xf00b
#define mmCGTS_CU0_TD_TCP_CTRL_REG                                              0xf00c
#define mmCGTS_CU1_SP0_CTRL_REG                                                 0xf00d
#define mmCGTS_CU1_LDS_SQ_CTRL_REG                                              0xf00e
#define mmCGTS_CU1_TA_CTRL_REG                                                  0xf00f
#define mmCGTS_CU1_SP1_CTRL_REG                                                 0xf010
#define mmCGTS_CU1_TD_TCP_CTRL_REG                                              0xf011
#define mmCGTS_CU2_SP0_CTRL_REG                                                 0xf012
#define mmCGTS_CU2_LDS_SQ_CTRL_REG                                              0xf013
#define mmCGTS_CU2_TA_CTRL_REG                                                  0xf014
#define mmCGTS_CU2_SP1_CTRL_REG                                                 0xf015
#define mmCGTS_CU2_TD_TCP_CTRL_REG                                              0xf016
#define mmCGTS_CU3_SP0_CTRL_REG                                                 0xf017
#define mmCGTS_CU3_LDS_SQ_CTRL_REG                                              0xf018
#define mmCGTS_CU3_TA_CTRL_REG                                                  0xf019
#define mmCGTS_CU3_SP1_CTRL_REG                                                 0xf01a
#define mmCGTS_CU3_TD_TCP_CTRL_REG                                              0xf01b
#define mmCGTS_CU4_SP0_CTRL_REG                                                 0xf01c
#define mmCGTS_CU4_LDS_SQ_CTRL_REG                                              0xf01d
#define mmCGTS_CU4_TA_SQC_CTRL_REG                                              0xf01e
#define mmCGTS_CU4_SP1_CTRL_REG                                                 0xf01f
#define mmCGTS_CU4_TD_TCP_CTRL_REG                                              0xf020
#define mmCGTS_CU5_SP0_CTRL_REG                                                 0xf021
#define mmCGTS_CU5_LDS_SQ_CTRL_REG                                              0xf022
#define mmCGTS_CU5_TA_CTRL_REG                                                  0xf023
#define mmCGTS_CU5_SP1_CTRL_REG                                                 0xf024
#define mmCGTS_CU5_TD_TCP_CTRL_REG                                              0xf025
#define mmCGTS_CU6_SP0_CTRL_REG                                                 0xf026
#define mmCGTS_CU6_LDS_SQ_CTRL_REG                                              0xf027
#define mmCGTS_CU6_TA_CTRL_REG                                                  0xf028
#define mmCGTS_CU6_SP1_CTRL_REG                                                 0xf029
#define mmCGTS_CU6_TD_TCP_CTRL_REG                                              0xf02a
#define mmCGTS_CU7_SP0_CTRL_REG                                                 0xf02b
#define mmCGTS_CU7_LDS_SQ_CTRL_REG                                              0xf02c
#define mmCGTS_CU7_TA_CTRL_REG                                                  0xf02d
#define mmCGTS_CU7_SP1_CTRL_REG                                                 0xf02e
#define mmCGTS_CU7_TD_TCP_CTRL_REG                                              0xf02f
#define mmCGTS_CU8_SP0_CTRL_REG                                                 0xf030
#define mmCGTS_CU8_LDS_SQ_CTRL_REG                                              0xf031
#define mmCGTS_CU8_TA_SQC_CTRL_REG                                              0xf032
#define mmCGTS_CU8_SP1_CTRL_REG                                                 0xf033
#define mmCGTS_CU8_TD_TCP_CTRL_REG                                              0xf034
#define mmCGTS_CU9_SP0_CTRL_REG                                                 0xf035
#define mmCGTS_CU9_LDS_SQ_CTRL_REG                                              0xf036
#define mmCGTS_CU9_TA_CTRL_REG                                                  0xf037
#define mmCGTS_CU9_SP1_CTRL_REG                                                 0xf038
#define mmCGTS_CU9_TD_TCP_CTRL_REG                                              0xf039
#define mmCGTS_CU10_SP0_CTRL_REG                                                0xf03a
#define mmCGTS_CU10_LDS_SQ_CTRL_REG                                             0xf03b
#define mmCGTS_CU10_TA_CTRL_REG                                                 0xf03c
#define mmCGTS_CU10_SP1_CTRL_REG                                                0xf03d
#define mmCGTS_CU10_TD_TCP_CTRL_REG                                             0xf03e
#define mmCGTS_CU11_SP0_CTRL_REG                                                0xf03f
#define mmCGTS_CU11_LDS_SQ_CTRL_REG                                             0xf040
#define mmCGTS_CU11_TA_CTRL_REG                                                 0xf041
#define mmCGTS_CU11_SP1_CTRL_REG                                                0xf042
#define mmCGTS_CU11_TD_TCP_CTRL_REG                                             0xf043
#define mmCGTS_CU12_SP0_CTRL_REG                                                0xf044
#define mmCGTS_CU12_LDS_SQ_CTRL_REG                                             0xf045
#define mmCGTS_CU12_TA_SQC_CTRL_REG                                             0xf046
#define mmCGTS_CU12_SP1_CTRL_REG                                                0xf047
#define mmCGTS_CU12_TD_TCP_CTRL_REG                                             0xf048
#define mmCGTS_CU13_SP0_CTRL_REG                                                0xf049
#define mmCGTS_CU13_LDS_SQ_CTRL_REG                                             0xf04a
#define mmCGTS_CU13_TA_CTRL_REG                                                 0xf04b
#define mmCGTS_CU13_SP1_CTRL_REG                                                0xf04c
#define mmCGTS_CU13_TD_TCP_CTRL_REG                                             0xf04d
#define mmCGTS_CU14_SP0_CTRL_REG                                                0xf04e
#define mmCGTS_CU14_LDS_SQ_CTRL_REG                                             0xf04f
#define mmCGTS_CU14_TA_CTRL_REG                                                 0xf050
#define mmCGTS_CU14_SP1_CTRL_REG                                                0xf051
#define mmCGTS_CU14_TD_TCP_CTRL_REG                                             0xf052
#define mmCGTS_CU15_SP0_CTRL_REG                                                0xf053
#define mmCGTS_CU15_LDS_SQ_CTRL_REG                                             0xf054
#define mmCGTS_CU15_TA_CTRL_REG                                                 0xf055
#define mmCGTS_CU15_SP1_CTRL_REG                                                0xf056
#define mmCGTS_CU15_TD_TCP_CTRL_REG                                             0xf057
#define mmCGTT_SPI_CLK_CTRL                                                     0xf080
#define mmCGTT_PC_CLK_CTRL                                                      0xf081
#define mmCGTT_BCI_CLK_CTRL                                                     0xf082
#define mmSPI_WF_LIFETIME_CNTL                                                  0x24aa
#define mmSPI_WF_LIFETIME_LIMIT_0                                               0x24ab
#define mmSPI_WF_LIFETIME_LIMIT_1                                               0x24ac
#define mmSPI_WF_LIFETIME_LIMIT_2                                               0x24ad
#define mmSPI_WF_LIFETIME_LIMIT_3                                               0x24ae
#define mmSPI_WF_LIFETIME_LIMIT_4                                               0x24af
#define mmSPI_WF_LIFETIME_LIMIT_5                                               0x24b0
#define mmSPI_WF_LIFETIME_LIMIT_6                                               0x24b1
#define mmSPI_WF_LIFETIME_LIMIT_7                                               0x24b2
#define mmSPI_WF_LIFETIME_LIMIT_8                                               0x24b3
#define mmSPI_WF_LIFETIME_LIMIT_9                                               0x24b4
#define mmSPI_WF_LIFETIME_STATUS_0                                              0x24b5
#define mmSPI_WF_LIFETIME_STATUS_1                                              0x24b6
#define mmSPI_WF_LIFETIME_STATUS_2                                              0x24b7
#define mmSPI_WF_LIFETIME_STATUS_3                                              0x24b8
#define mmSPI_WF_LIFETIME_STATUS_4                                              0x24b9
#define mmSPI_WF_LIFETIME_STATUS_5                                              0x24ba
#define mmSPI_WF_LIFETIME_STATUS_6                                              0x24bb
#define mmSPI_WF_LIFETIME_STATUS_7                                              0x24bc
#define mmSPI_WF_LIFETIME_STATUS_8                                              0x24bd
#define mmSPI_WF_LIFETIME_STATUS_9                                              0x24be
#define mmSPI_WF_LIFETIME_STATUS_10                                             0x24bf
#define mmSPI_WF_LIFETIME_STATUS_11                                             0x24c0
#define mmSPI_WF_LIFETIME_STATUS_12                                             0x24c1
#define mmSPI_WF_LIFETIME_STATUS_13                                             0x24c2
#define mmSPI_WF_LIFETIME_STATUS_14                                             0x24c3
#define mmSPI_WF_LIFETIME_STATUS_15                                             0x24c4
#define mmSPI_WF_LIFETIME_STATUS_16                                             0x24c5
#define mmSPI_WF_LIFETIME_STATUS_17                                             0x24c6
#define mmSPI_WF_LIFETIME_STATUS_18                                             0x24c7
#define mmSPI_WF_LIFETIME_STATUS_19                                             0x24c8
#define mmSPI_WF_LIFETIME_STATUS_20                                             0x24c9
#define mmSPI_WF_LIFETIME_DEBUG                                                 0x24ca
#define mmSPI_SLAVE_DEBUG_BUSY                                                  0x24d3
#define mmSPI_LB_CTR_CTRL                                                       0x24d4
#define mmSPI_LB_CU_MASK                                                        0x24d5
#define mmSPI_LB_DATA_REG                                                       0x24d6
#define mmSPI_PG_ENABLE_STATIC_CU_MASK                                          0x24d7
#define mmSPI_GDS_CREDITS                                                       0x24d8
#define mmSPI_SX_EXPORT_BUFFER_SIZES                                            0x24d9
#define mmSPI_SX_SCOREBOARD_BUFFER_SIZES                                        0x24da
#define mmSPI_CSQ_WF_ACTIVE_STATUS                                              0x24db
#define mmSPI_CSQ_WF_ACTIVE_COUNT_0                                             0x24dc
#define mmSPI_CSQ_WF_ACTIVE_COUNT_1                                             0x24dd
#define mmSPI_CSQ_WF_ACTIVE_COUNT_2                                             0x24de
#define mmSPI_CSQ_WF_ACTIVE_COUNT_3                                             0x24df
#define mmSPI_CSQ_WF_ACTIVE_COUNT_4                                             0x24e0
#define mmSPI_CSQ_WF_ACTIVE_COUNT_5                                             0x24e1
#define mmSPI_CSQ_WF_ACTIVE_COUNT_6                                             0x24e2
#define mmSPI_CSQ_WF_ACTIVE_COUNT_7                                             0x24e3
#define mmBCI_DEBUG_READ                                                        0x24eb
#define mmSPI_P0_TRAP_SCREEN_PSBA_LO                                            0x24ec
#define mmSPI_P0_TRAP_SCREEN_PSBA_HI                                            0x24ed
#define mmSPI_P0_TRAP_SCREEN_PSMA_LO                                            0x24ee
#define mmSPI_P0_TRAP_SCREEN_PSMA_HI                                            0x24ef
#define mmSPI_P0_TRAP_SCREEN_GPR_MIN                                            0x24f0
#define mmSPI_P1_TRAP_SCREEN_PSBA_LO                                            0x24f1
#define mmSPI_P1_TRAP_SCREEN_PSBA_HI                                            0x24f2
#define mmSPI_P1_TRAP_SCREEN_PSMA_LO                                            0x24f3
#define mmSPI_P1_TRAP_SCREEN_PSMA_HI                                            0x24f4
#define mmSPI_P1_TRAP_SCREEN_GPR_MIN                                            0x24f5
#define mmSPI_SHADER_TBA_LO_PS                                                  0x2c00
#define mmSPI_SHADER_TBA_HI_PS                                                  0x2c01
#define mmSPI_SHADER_TMA_LO_PS                                                  0x2c02
#define mmSPI_SHADER_TMA_HI_PS                                                  0x2c03
#define mmSPI_SHADER_PGM_LO_PS                                                  0x2c08
#define mmSPI_SHADER_PGM_HI_PS                                                  0x2c09
#define mmSPI_SHADER_PGM_RSRC1_PS                                               0x2c0a
#define mmSPI_SHADER_PGM_RSRC2_PS                                               0x2c0b
#define mmSPI_SHADER_PGM_RSRC3_PS                                               0x2c07
#define mmSPI_SHADER_USER_DATA_PS_0                                             0x2c0c
#define mmSPI_SHADER_USER_DATA_PS_1                                             0x2c0d
#define mmSPI_SHADER_USER_DATA_PS_2                                             0x2c0e
#define mmSPI_SHADER_USER_DATA_PS_3                                             0x2c0f
#define mmSPI_SHADER_USER_DATA_PS_4                                             0x2c10
#define mmSPI_SHADER_USER_DATA_PS_5                                             0x2c11
#define mmSPI_SHADER_USER_DATA_PS_6                                             0x2c12
#define mmSPI_SHADER_USER_DATA_PS_7                                             0x2c13
#define mmSPI_SHADER_USER_DATA_PS_8                                             0x2c14
#define mmSPI_SHADER_USER_DATA_PS_9                                             0x2c15
#define mmSPI_SHADER_USER_DATA_PS_10                                            0x2c16
#define mmSPI_SHADER_USER_DATA_PS_11                                            0x2c17
#define mmSPI_SHADER_USER_DATA_PS_12                                            0x2c18
#define mmSPI_SHADER_USER_DATA_PS_13                                            0x2c19
#define mmSPI_SHADER_USER_DATA_PS_14                                            0x2c1a
#define mmSPI_SHADER_USER_DATA_PS_15                                            0x2c1b
#define mmSPI_SHADER_TBA_LO_VS                                                  0x2c40
#define mmSPI_SHADER_TBA_HI_VS                                                  0x2c41
#define mmSPI_SHADER_TMA_LO_VS                                                  0x2c42
#define mmSPI_SHADER_TMA_HI_VS                                                  0x2c43
#define mmSPI_SHADER_PGM_LO_VS                                                  0x2c48
#define mmSPI_SHADER_PGM_HI_VS                                                  0x2c49
#define mmSPI_SHADER_PGM_RSRC1_VS                                               0x2c4a
#define mmSPI_SHADER_PGM_RSRC2_VS                                               0x2c4b
#define mmSPI_SHADER_PGM_RSRC3_VS                                               0x2c46
#define mmSPI_SHADER_LATE_ALLOC_VS                                              0x2c47
#define mmSPI_SHADER_USER_DATA_VS_0                                             0x2c4c
#define mmSPI_SHADER_USER_DATA_VS_1                                             0x2c4d
#define mmSPI_SHADER_USER_DATA_VS_2                                             0x2c4e
#define mmSPI_SHADER_USER_DATA_VS_3                                             0x2c4f
#define mmSPI_SHADER_USER_DATA_VS_4                                             0x2c50
#define mmSPI_SHADER_USER_DATA_VS_5                                             0x2c51
#define mmSPI_SHADER_USER_DATA_VS_6                                             0x2c52
#define mmSPI_SHADER_USER_DATA_VS_7                                             0x2c53
#define mmSPI_SHADER_USER_DATA_VS_8                                             0x2c54
#define mmSPI_SHADER_USER_DATA_VS_9                                             0x2c55
#define mmSPI_SHADER_USER_DATA_VS_10                                            0x2c56
#define mmSPI_SHADER_USER_DATA_VS_11                                            0x2c57
#define mmSPI_SHADER_USER_DATA_VS_12                                            0x2c58
#define mmSPI_SHADER_USER_DATA_VS_13                                            0x2c59
#define mmSPI_SHADER_USER_DATA_VS_14                                            0x2c5a
#define mmSPI_SHADER_USER_DATA_VS_15                                            0x2c5b
#define mmSPI_SHADER_PGM_RSRC2_ES_VS                                            0x2c7c
#define mmSPI_SHADER_PGM_RSRC2_LS_VS                                            0x2c7d
#define mmSPI_SHADER_TBA_LO_GS                                                  0x2c80
#define mmSPI_SHADER_TBA_HI_GS                                                  0x2c81
#define mmSPI_SHADER_TMA_LO_GS                                                  0x2c82
#define mmSPI_SHADER_TMA_HI_GS                                                  0x2c83
#define mmSPI_SHADER_PGM_LO_GS                                                  0x2c88
#define mmSPI_SHADER_PGM_HI_GS                                                  0x2c89
#define mmSPI_SHADER_PGM_RSRC1_GS                                               0x2c8a
#define mmSPI_SHADER_PGM_RSRC2_GS                                               0x2c8b
#define mmSPI_SHADER_PGM_RSRC3_GS                                               0x2c87
#define mmSPI_SHADER_USER_DATA_GS_0                                             0x2c8c
#define mmSPI_SHADER_USER_DATA_GS_1                                             0x2c8d
#define mmSPI_SHADER_USER_DATA_GS_2                                             0x2c8e
#define mmSPI_SHADER_USER_DATA_GS_3                                             0x2c8f
#define mmSPI_SHADER_USER_DATA_GS_4                                             0x2c90
#define mmSPI_SHADER_USER_DATA_GS_5                                             0x2c91
#define mmSPI_SHADER_USER_DATA_GS_6                                             0x2c92
#define mmSPI_SHADER_USER_DATA_GS_7                                             0x2c93
#define mmSPI_SHADER_USER_DATA_GS_8                                             0x2c94
#define mmSPI_SHADER_USER_DATA_GS_9                                             0x2c95
#define mmSPI_SHADER_USER_DATA_GS_10                                            0x2c96
#define mmSPI_SHADER_USER_DATA_GS_11                                            0x2c97
#define mmSPI_SHADER_USER_DATA_GS_12                                            0x2c98
#define mmSPI_SHADER_USER_DATA_GS_13                                            0x2c99
#define mmSPI_SHADER_USER_DATA_GS_14                                            0x2c9a
#define mmSPI_SHADER_USER_DATA_GS_15                                            0x2c9b
#define mmSPI_SHADER_PGM_RSRC2_ES_GS                                            0x2cbc
#define mmSPI_SHADER_TBA_LO_ES                                                  0x2cc0
#define mmSPI_SHADER_TBA_HI_ES                                                  0x2cc1
#define mmSPI_SHADER_TMA_LO_ES                                                  0x2cc2
#define mmSPI_SHADER_TMA_HI_ES                                                  0x2cc3
#define mmSPI_SHADER_PGM_LO_ES                                                  0x2cc8
#define mmSPI_SHADER_PGM_HI_ES                                                  0x2cc9
#define mmSPI_SHADER_PGM_RSRC1_ES                                               0x2cca
#define mmSPI_SHADER_PGM_RSRC2_ES                                               0x2ccb
#define mmSPI_SHADER_PGM_RSRC3_ES                                               0x2cc7
#define mmSPI_SHADER_USER_DATA_ES_0                                             0x2ccc
#define mmSPI_SHADER_USER_DATA_ES_1                                             0x2ccd
#define mmSPI_SHADER_USER_DATA_ES_2                                             0x2cce
#define mmSPI_SHADER_USER_DATA_ES_3                                             0x2ccf
#define mmSPI_SHADER_USER_DATA_ES_4                                             0x2cd0
#define mmSPI_SHADER_USER_DATA_ES_5                                             0x2cd1
#define mmSPI_SHADER_USER_DATA_ES_6                                             0x2cd2
#define mmSPI_SHADER_USER_DATA_ES_7                                             0x2cd3
#define mmSPI_SHADER_USER_DATA_ES_8                                             0x2cd4
#define mmSPI_SHADER_USER_DATA_ES_9                                             0x2cd5
#define mmSPI_SHADER_USER_DATA_ES_10                                            0x2cd6
#define mmSPI_SHADER_USER_DATA_ES_11                                            0x2cd7
#define mmSPI_SHADER_USER_DATA_ES_12                                            0x2cd8
#define mmSPI_SHADER_USER_DATA_ES_13                                            0x2cd9
#define mmSPI_SHADER_USER_DATA_ES_14                                            0x2cda
#define mmSPI_SHADER_USER_DATA_ES_15                                            0x2cdb
#define mmSPI_SHADER_PGM_RSRC2_LS_ES                                            0x2cfd
#define mmSPI_SHADER_TBA_LO_HS                                                  0x2d00
#define mmSPI_SHADER_TBA_HI_HS                                                  0x2d01
#define mmSPI_SHADER_TMA_LO_HS                                                  0x2d02
#define mmSPI_SHADER_TMA_HI_HS                                                  0x2d03
#define mmSPI_SHADER_PGM_LO_HS                                                  0x2d08
#define mmSPI_SHADER_PGM_HI_HS                                                  0x2d09
#define mmSPI_SHADER_PGM_RSRC1_HS                                               0x2d0a
#define mmSPI_SHADER_PGM_RSRC2_HS                                               0x2d0b
#define mmSPI_SHADER_PGM_RSRC3_HS                                               0x2d07
#define mmSPI_SHADER_USER_DATA_HS_0                                             0x2d0c
#define mmSPI_SHADER_USER_DATA_HS_1                                             0x2d0d
#define mmSPI_SHADER_USER_DATA_HS_2                                             0x2d0e
#define mmSPI_SHADER_USER_DATA_HS_3                                             0x2d0f
#define mmSPI_SHADER_USER_DATA_HS_4                                             0x2d10
#define mmSPI_SHADER_USER_DATA_HS_5                                             0x2d11
#define mmSPI_SHADER_USER_DATA_HS_6                                             0x2d12
#define mmSPI_SHADER_USER_DATA_HS_7                                             0x2d13
#define mmSPI_SHADER_USER_DATA_HS_8                                             0x2d14
#define mmSPI_SHADER_USER_DATA_HS_9                                             0x2d15
#define mmSPI_SHADER_USER_DATA_HS_10                                            0x2d16
#define mmSPI_SHADER_USER_DATA_HS_11                                            0x2d17
#define mmSPI_SHADER_USER_DATA_HS_12                                            0x2d18
#define mmSPI_SHADER_USER_DATA_HS_13                                            0x2d19
#define mmSPI_SHADER_USER_DATA_HS_14                                            0x2d1a
#define mmSPI_SHADER_USER_DATA_HS_15                                            0x2d1b
#define mmSPI_SHADER_PGM_RSRC2_LS_HS                                            0x2d3d
#define mmSPI_SHADER_TBA_LO_LS                                                  0x2d40
#define mmSPI_SHADER_TBA_HI_LS                                                  0x2d41
#define mmSPI_SHADER_TMA_LO_LS                                                  0x2d42
#define mmSPI_SHADER_TMA_HI_LS                                                  0x2d43
#define mmSPI_SHADER_PGM_LO_LS                                                  0x2d48
#define mmSPI_SHADER_PGM_HI_LS                                                  0x2d49
#define mmSPI_SHADER_PGM_RSRC1_LS                                               0x2d4a
#define mmSPI_SHADER_PGM_RSRC2_LS                                               0x2d4b
#define mmSPI_SHADER_PGM_RSRC3_LS                                               0x2d47
#define mmSPI_SHADER_USER_DATA_LS_0                                             0x2d4c
#define mmSPI_SHADER_USER_DATA_LS_1                                             0x2d4d
#define mmSPI_SHADER_USER_DATA_LS_2                                             0x2d4e
#define mmSPI_SHADER_USER_DATA_LS_3                                             0x2d4f
#define mmSPI_SHADER_USER_DATA_LS_4                                             0x2d50
#define mmSPI_SHADER_USER_DATA_LS_5                                             0x2d51
#define mmSPI_SHADER_USER_DATA_LS_6                                             0x2d52
#define mmSPI_SHADER_USER_DATA_LS_7                                             0x2d53
#define mmSPI_SHADER_USER_DATA_LS_8                                             0x2d54
#define mmSPI_SHADER_USER_DATA_LS_9                                             0x2d55
#define mmSPI_SHADER_USER_DATA_LS_10                                            0x2d56
#define mmSPI_SHADER_USER_DATA_LS_11                                            0x2d57
#define mmSPI_SHADER_USER_DATA_LS_12                                            0x2d58
#define mmSPI_SHADER_USER_DATA_LS_13                                            0x2d59
#define mmSPI_SHADER_USER_DATA_LS_14                                            0x2d5a
#define mmSPI_SHADER_USER_DATA_LS_15                                            0x2d5b
#define mmSQ_CONFIG                                                             0x2300
#define mmSQC_CONFIG                                                            0x2301
#define mmSQC_CACHES                                                            0xc348
#define mmSQ_RANDOM_WAVE_PRI                                                    0x2303
#define mmSQ_REG_CREDITS                                                        0x2304
#define mmSQ_FIFO_SIZES                                                         0x2305
#define mmSQ_INTERRUPT_AUTO_MASK                                                0x2314
#define mmSQ_INTERRUPT_MSG_CTRL                                                 0x2315
#define mmSQ_PERFCOUNTER_CTRL                                                   0xd9e0
#define mmSQ_PERFCOUNTER_MASK                                                   0xd9e1
#define mmSQ_PERFCOUNTER_CTRL2                                                  0xd9e2
#define mmCC_SQC_BANK_DISABLE                                                   0x2307
#define mmUSER_SQC_BANK_DISABLE                                                 0x2308
#define mmSQ_PERFCOUNTER0_LO                                                    0xd1c0
#define mmSQ_PERFCOUNTER1_LO                                                    0xd1c2
#define mmSQ_PERFCOUNTER2_LO                                                    0xd1c4
#define mmSQ_PERFCOUNTER3_LO                                                    0xd1c6
#define mmSQ_PERFCOUNTER4_LO                                                    0xd1c8
#define mmSQ_PERFCOUNTER5_LO                                                    0xd1ca
#define mmSQ_PERFCOUNTER6_LO                                                    0xd1cc
#define mmSQ_PERFCOUNTER7_LO                                                    0xd1ce
#define mmSQ_PERFCOUNTER8_LO                                                    0xd1d0
#define mmSQ_PERFCOUNTER9_LO                                                    0xd1d2
#define mmSQ_PERFCOUNTER10_LO                                                   0xd1d4
#define mmSQ_PERFCOUNTER11_LO                                                   0xd1d6
#define mmSQ_PERFCOUNTER12_LO                                                   0xd1d8
#define mmSQ_PERFCOUNTER13_LO                                                   0xd1da
#define mmSQ_PERFCOUNTER14_LO                                                   0xd1dc
#define mmSQ_PERFCOUNTER15_LO                                                   0xd1de
#define mmSQ_PERFCOUNTER0_HI                                                    0xd1c1
#define mmSQ_PERFCOUNTER1_HI                                                    0xd1c3
#define mmSQ_PERFCOUNTER2_HI                                                    0xd1c5
#define mmSQ_PERFCOUNTER3_HI                                                    0xd1c7
#define mmSQ_PERFCOUNTER4_HI                                                    0xd1c9
#define mmSQ_PERFCOUNTER5_HI                                                    0xd1cb
#define mmSQ_PERFCOUNTER6_HI                                                    0xd1cd
#define mmSQ_PERFCOUNTER7_HI                                                    0xd1cf
#define mmSQ_PERFCOUNTER8_HI                                                    0xd1d1
#define mmSQ_PERFCOUNTER9_HI                                                    0xd1d3
#define mmSQ_PERFCOUNTER10_HI                                                   0xd1d5
#define mmSQ_PERFCOUNTER11_HI                                                   0xd1d7
#define mmSQ_PERFCOUNTER12_HI                                                   0xd1d9
#define mmSQ_PERFCOUNTER13_HI                                                   0xd1db
#define mmSQ_PERFCOUNTER14_HI                                                   0xd1dd
#define mmSQ_PERFCOUNTER15_HI                                                   0xd1df
#define mmSQ_PERFCOUNTER0_SELECT                                                0xd9c0
#define mmSQ_PERFCOUNTER1_SELECT                                                0xd9c1
#define mmSQ_PERFCOUNTER2_SELECT                                                0xd9c2
#define mmSQ_PERFCOUNTER3_SELECT                                                0xd9c3
#define mmSQ_PERFCOUNTER4_SELECT                                                0xd9c4
#define mmSQ_PERFCOUNTER5_SELECT                                                0xd9c5
#define mmSQ_PERFCOUNTER6_SELECT                                                0xd9c6
#define mmSQ_PERFCOUNTER7_SELECT                                                0xd9c7
#define mmSQ_PERFCOUNTER8_SELECT                                                0xd9c8
#define mmSQ_PERFCOUNTER9_SELECT                                                0xd9c9
#define mmSQ_PERFCOUNTER10_SELECT                                               0xd9ca
#define mmSQ_PERFCOUNTER11_SELECT                                               0xd9cb
#define mmSQ_PERFCOUNTER12_SELECT                                               0xd9cc
#define mmSQ_PERFCOUNTER13_SELECT                                               0xd9cd
#define mmSQ_PERFCOUNTER14_SELECT                                               0xd9ce
#define mmSQ_PERFCOUNTER15_SELECT                                               0xd9cf
#define mmCGTT_SQ_CLK_CTRL                                                      0xf08c
#define mmCGTT_SQG_CLK_CTRL                                                     0xf08d
#define mmSQ_ALU_CLK_CTRL                                                       0xf08e
#define mmSQ_TEX_CLK_CTRL                                                       0xf08f
#define mmSQ_LDS_CLK_CTRL                                                       0xf090
#define mmSQ_POWER_THROTTLE                                                     0xf091
#define mmSQ_POWER_THROTTLE2                                                    0xf092
#define mmSQ_TIME_HI                                                            0x237c
#define mmSQ_TIME_LO                                                            0x237d
#define mmSQ_THREAD_TRACE_BASE                                                  0x2380
#define mmSQ_THREAD_TRACE_BASE2                                                 0x2385
#define mmSQ_THREAD_TRACE_SIZE                                                  0x2381
#define mmSQ_THREAD_TRACE_MASK                                                  0x2382
#define mmSQ_THREAD_TRACE_USERDATA_0                                            0xc340
#define mmSQ_THREAD_TRACE_USERDATA_1                                            0xc341
#define mmSQ_THREAD_TRACE_USERDATA_2                                            0xc342
#define mmSQ_THREAD_TRACE_USERDATA_3                                            0xc343
#define mmSQ_THREAD_TRACE_MODE                                                  0x238e
#define mmSQ_THREAD_TRACE_CTRL                                                  0x238f
#define mmSQ_THREAD_TRACE_TOKEN_MASK                                            0x2383
#define mmSQ_THREAD_TRACE_TOKEN_MASK2                                           0x2386
#define mmSQ_THREAD_TRACE_PERF_MASK                                             0x2384
#define mmSQ_THREAD_TRACE_WPTR                                                  0x238c
#define mmSQ_THREAD_TRACE_STATUS                                                0x238d
#define mmSQ_THREAD_TRACE_CNTR                                                  0x2390
#define mmSQ_THREAD_TRACE_HIWATER                                               0x2392
#define mmSQ_LB_CTR_CTRL                                                        0x2398
#define mmSQ_LB_DATA_ALU_CYCLES                                                 0x2399
#define mmSQ_LB_DATA_TEX_CYCLES                                                 0x239a
#define mmSQ_LB_DATA_ALU_STALLS                                                 0x239b
#define mmSQ_LB_DATA_TEX_STALLS                                                 0x239c
#define mmSQC_SECDED_CNT                                                        0x23a0
#define mmSQ_SEC_CNT                                                            0x23a1
#define mmSQ_DED_CNT                                                            0x23a2
#define mmSQ_DED_INFO                                                           0x23a3
#define mmSQ_BUF_RSRC_WORD0                                                     0x23c0
#define mmSQ_BUF_RSRC_WORD1                                                     0x23c1
#define mmSQ_BUF_RSRC_WORD2                                                     0x23c2
#define mmSQ_BUF_RSRC_WORD3                                                     0x23c3
#define mmSQ_IMG_RSRC_WORD0                                                     0x23c4
#define mmSQ_IMG_RSRC_WORD1                                                     0x23c5
#define mmSQ_IMG_RSRC_WORD2                                                     0x23c6
#define mmSQ_IMG_RSRC_WORD3                                                     0x23c7
#define mmSQ_IMG_RSRC_WORD4                                                     0x23c8
#define mmSQ_IMG_RSRC_WORD5                                                     0x23c9
#define mmSQ_IMG_RSRC_WORD6                                                     0x23ca
#define mmSQ_IMG_RSRC_WORD7                                                     0x23cb
#define mmSQ_IMG_SAMP_WORD0                                                     0x23cc
#define mmSQ_IMG_SAMP_WORD1                                                     0x23cd
#define mmSQ_IMG_SAMP_WORD2                                                     0x23ce
#define mmSQ_IMG_SAMP_WORD3                                                     0x23cf
#define mmSQ_FLAT_SCRATCH_WORD0                                                 0x23d0
#define mmSQ_FLAT_SCRATCH_WORD1                                                 0x23d1
#define mmSQ_IND_INDEX                                                          0x2378
#define mmSQ_IND_CMD                                                            0x237a
#define mmSQ_CMD                                                                0x237b
#define mmSQ_IND_DATA                                                           0x2379
#define mmSQ_REG_TIMESTAMP                                                      0x2374
#define mmSQ_CMD_TIMESTAMP                                                      0x2375
#define mmSQ_HV_VMID_CTRL                                                       0xf840
#define ixSQ_WAVE_INST_DW0                                                      0x1a
#define ixSQ_WAVE_INST_DW1                                                      0x1b
#define ixSQ_WAVE_PC_LO                                                         0x18
#define ixSQ_WAVE_PC_HI                                                         0x19
#define ixSQ_WAVE_IB_DBG0                                                       0x1c
#define ixSQ_WAVE_EXEC_LO                                                       0x27e
#define ixSQ_WAVE_EXEC_HI                                                       0x27f
#define ixSQ_WAVE_STATUS                                                        0x12
#define ixSQ_WAVE_MODE                                                          0x11
#define ixSQ_WAVE_TRAPSTS                                                       0x13
#define ixSQ_WAVE_HW_ID                                                         0x14
#define ixSQ_WAVE_GPR_ALLOC                                                     0x15
#define ixSQ_WAVE_LDS_ALLOC                                                     0x16
#define ixSQ_WAVE_IB_STS                                                        0x17
#define ixSQ_WAVE_M0                                                            0x27c
#define ixSQ_WAVE_TBA_LO                                                        0x26c
#define ixSQ_WAVE_TBA_HI                                                        0x26d
#define ixSQ_WAVE_TMA_LO                                                        0x26e
#define ixSQ_WAVE_TMA_HI                                                        0x26f
#define ixSQ_WAVE_TTMP0                                                         0x270
#define ixSQ_WAVE_TTMP1                                                         0x271
#define ixSQ_WAVE_TTMP2                                                         0x272
#define ixSQ_WAVE_TTMP3                                                         0x273
#define ixSQ_WAVE_TTMP4                                                         0x274
#define ixSQ_WAVE_TTMP5                                                         0x275
#define ixSQ_WAVE_TTMP6                                                         0x276
#define ixSQ_WAVE_TTMP7                                                         0x277
#define ixSQ_WAVE_TTMP8                                                         0x278
#define ixSQ_WAVE_TTMP9                                                         0x279
#define ixSQ_WAVE_TTMP10                                                        0x27a
#define ixSQ_WAVE_TTMP11                                                        0x27b
#define mmSQ_DEBUG_STS_GLOBAL                                                   0x2309
#define mmSQ_DEBUG_STS_GLOBAL2                                                  0x2310
#define mmSQ_DEBUG_STS_GLOBAL3                                                  0x2311
#define ixSQ_DEBUG_STS_LOCAL                                                    0x8
#define ixSQ_DEBUG_CTRL_LOCAL                                                   0x9
#define mmSH_MEM_BASES                                                          0x230a
#define mmSH_MEM_APE1_BASE                                                      0x230b
#define mmSH_MEM_APE1_LIMIT                                                     0x230c
#define mmSH_MEM_CONFIG                                                         0x230d
#define mmSQC_POLICY                                                            0x230e
#define mmSQC_VOLATILE                                                          0x230f
#define mmSQ_THREAD_TRACE_WORD_CMN                                              0x23b0
#define mmSQ_THREAD_TRACE_WORD_INST                                             0x23b0
#define mmSQ_THREAD_TRACE_WORD_INST_PC_1_OF_2                                   0x23b0
#define mmSQ_THREAD_TRACE_WORD_INST_PC_2_OF_2                                   0x23b1
#define mmSQ_THREAD_TRACE_WORD_INST_USERDATA_1_OF_2                             0x23b0
#define mmSQ_THREAD_TRACE_WORD_INST_USERDATA_2_OF_2                             0x23b1
#define mmSQ_THREAD_TRACE_WORD_TIMESTAMP_1_OF_2                                 0x23b0
#define mmSQ_THREAD_TRACE_WORD_TIMESTAMP_2_OF_2                                 0x23b1
#define mmSQ_THREAD_TRACE_WORD_WAVE                                             0x23b0
#define mmSQ_THREAD_TRACE_WORD_MISC                                             0x23b0
#define mmSQ_THREAD_TRACE_WORD_WAVE_START                                       0x23b0
#define mmSQ_THREAD_TRACE_WORD_REG_1_OF_2                                       0x23b0
#define mmSQ_THREAD_TRACE_WORD_REG_2_OF_2                                       0x23b0
#define mmSQ_THREAD_TRACE_WORD_REG_CS_1_OF_2                                    0x23b0
#define mmSQ_THREAD_TRACE_WORD_REG_CS_2_OF_2                                    0x23b0
#define mmSQ_THREAD_TRACE_WORD_EVENT                                            0x23b0
#define mmSQ_THREAD_TRACE_WORD_ISSUE                                            0x23b0
#define mmSQ_THREAD_TRACE_WORD_PERF_1_OF_2                                      0x23b0
#define mmSQ_THREAD_TRACE_WORD_PERF_2_OF_2                                      0x23b1
#define ixSQ_INTERRUPT_WORD_CMN                                                 0x20c0
#define ixSQ_INTERRUPT_WORD_AUTO                                                0x20c0
#define ixSQ_INTERRUPT_WORD_WAVE                                                0x20c0
#define mmSQ_SOP2                                                               0x237f
#define mmSQ_VOP1                                                               0x237f
#define mmSQ_MTBUF_1                                                            0x237f
#define mmSQ_EXP_1                                                              0x237f
#define mmSQ_MUBUF_1                                                            0x237f
#define mmSQ_INST                                                               0x237f
#define mmSQ_EXP_0                                                              0x237f
#define mmSQ_MUBUF_0                                                            0x237f
#define mmSQ_VOP3_0                                                             0x237f
#define mmSQ_VOP2                                                               0x237f
#define mmSQ_MTBUF_0                                                            0x237f
#define mmSQ_SOPP                                                               0x237f
#define mmSQ_FLAT_0                                                             0x237f
#define mmSQ_VOP3_0_SDST_ENC                                                    0x237f
#define mmSQ_MIMG_1                                                             0x237f
#define mmSQ_SMRD                                                               0x237f
#define mmSQ_SOP1                                                               0x237f
#define mmSQ_SOPC                                                               0x237f
#define mmSQ_FLAT_1                                                             0x237f
#define mmSQ_DS_1                                                               0x237f
#define mmSQ_VOP3_1                                                             0x237f
#define mmSQ_MIMG_0                                                             0x237f
#define mmSQ_SOPK                                                               0x237f
#define mmSQ_DS_0                                                               0x237f
#define mmSQ_VOPC                                                               0x237f
#define mmSQ_VINTRP                                                             0x237f
#define mmCGTT_SX_CLK_CTRL0                                                     0xf094
#define mmCGTT_SX_CLK_CTRL1                                                     0xf095
#define mmCGTT_SX_CLK_CTRL2                                                     0xf096
#define mmCGTT_SX_CLK_CTRL3                                                     0xf097
#define mmCGTT_SX_CLK_CTRL4                                                     0xf098
#define mmSX_DEBUG_BUSY                                                         0x2414
#define mmSX_DEBUG_BUSY_2                                                       0x2415
#define mmSX_DEBUG_BUSY_3                                                       0x2416
#define mmSX_DEBUG_BUSY_4                                                       0x2417
#define mmSX_DEBUG_1                                                            0x2418
#define mmSX_PERFCOUNTER0_SELECT                                                0xda40
#define mmSX_PERFCOUNTER1_SELECT                                                0xda41
#define mmSX_PERFCOUNTER2_SELECT                                                0xda42
#define mmSX_PERFCOUNTER3_SELECT                                                0xda43
#define mmSX_PERFCOUNTER0_SELECT1                                               0xda44
#define mmSX_PERFCOUNTER1_SELECT1                                               0xda45
#define mmSX_PERFCOUNTER0_LO                                                    0xd240
#define mmSX_PERFCOUNTER0_HI                                                    0xd241
#define mmSX_PERFCOUNTER1_LO                                                    0xd242
#define mmSX_PERFCOUNTER1_HI                                                    0xd243
#define mmSX_PERFCOUNTER2_LO                                                    0xd244
#define mmSX_PERFCOUNTER2_HI                                                    0xd245
#define mmSX_PERFCOUNTER3_LO                                                    0xd246
#define mmSX_PERFCOUNTER3_HI                                                    0xd247
#define mmTCC_CTRL                                                              0x2b80
#define mmTCC_EDC_COUNTER                                                       0x2b82
#define mmTCC_REDUNDANCY                                                        0x2b83
#define mmTCC_CGTT_SCLK_CTRL                                                    0xf0ac
#define mmTCA_CGTT_SCLK_CTRL                                                    0xf0ad
#define mmTCS_CGTT_SCLK_CTRL                                                    0xf0ae
#define mmTCC_PERFCOUNTER0_SELECT                                               0xdb80
#define mmTCC_PERFCOUNTER1_SELECT                                               0xdb82
#define mmTCC_PERFCOUNTER0_SELECT1                                              0xdb81
#define mmTCC_PERFCOUNTER1_SELECT1                                              0xdb83
#define mmTCC_PERFCOUNTER2_SELECT                                               0xdb84
#define mmTCC_PERFCOUNTER3_SELECT                                               0xdb85
#define mmTCC_PERFCOUNTER0_LO                                                   0xd380
#define mmTCC_PERFCOUNTER1_LO                                                   0xd382
#define mmTCC_PERFCOUNTER2_LO                                                   0xd384
#define mmTCC_PERFCOUNTER3_LO                                                   0xd386
#define mmTCC_PERFCOUNTER0_HI                                                   0xd381
#define mmTCC_PERFCOUNTER1_HI                                                   0xd383
#define mmTCC_PERFCOUNTER2_HI                                                   0xd385
#define mmTCC_PERFCOUNTER3_HI                                                   0xd387
#define mmTCA_CTRL                                                              0x2bc0
#define mmTCA_PERFCOUNTER0_SELECT                                               0xdb90
#define mmTCA_PERFCOUNTER1_SELECT                                               0xdb92
#define mmTCA_PERFCOUNTER0_SELECT1                                              0xdb91
#define mmTCA_PERFCOUNTER1_SELECT1                                              0xdb93
#define mmTCA_PERFCOUNTER2_SELECT                                               0xdb94
#define mmTCA_PERFCOUNTER3_SELECT                                               0xdb95
#define mmTCA_PERFCOUNTER0_LO                                                   0xd390
#define mmTCA_PERFCOUNTER1_LO                                                   0xd392
#define mmTCA_PERFCOUNTER2_LO                                                   0xd394
#define mmTCA_PERFCOUNTER3_LO                                                   0xd396
#define mmTCA_PERFCOUNTER0_HI                                                   0xd391
#define mmTCA_PERFCOUNTER1_HI                                                   0xd393
#define mmTCA_PERFCOUNTER2_HI                                                   0xd395
#define mmTCA_PERFCOUNTER3_HI                                                   0xd397
#define mmTCS_CTRL                                                              0x2be0
#define mmTCS_PERFCOUNTER0_SELECT                                               0xdba0
#define mmTCS_PERFCOUNTER0_SELECT1                                              0xdba1
#define mmTCS_PERFCOUNTER1_SELECT                                               0xdba2
#define mmTCS_PERFCOUNTER2_SELECT                                               0xdba3
#define mmTCS_PERFCOUNTER3_SELECT                                               0xdba4
#define mmTCS_PERFCOUNTER0_LO                                                   0xd3a0
#define mmTCS_PERFCOUNTER1_LO                                                   0xd3a2
#define mmTCS_PERFCOUNTER2_LO                                                   0xd3a4
#define mmTCS_PERFCOUNTER3_LO                                                   0xd3a6
#define mmTCS_PERFCOUNTER0_HI                                                   0xd3a1
#define mmTCS_PERFCOUNTER1_HI                                                   0xd3a3
#define mmTCS_PERFCOUNTER2_HI                                                   0xd3a5
#define mmTCS_PERFCOUNTER3_HI                                                   0xd3a7
#define mmTA_BC_BASE_ADDR                                                       0xa020
#define mmTA_BC_BASE_ADDR_HI                                                    0xa021
#define mmTD_CNTL                                                               0x2525
#define mmTD_STATUS                                                             0x2526
#define mmTD_DEBUG_INDEX                                                        0x2528
#define mmTD_DEBUG_DATA                                                         0x2529
#define mmTD_PERFCOUNTER0_SELECT                                                0xdb00
#define mmTD_PERFCOUNTER1_SELECT                                                0xdb02
#define mmTD_PERFCOUNTER0_SELECT1                                               0xdb01
#define mmTD_PERFCOUNTER0_LO                                                    0xd300
#define mmTD_PERFCOUNTER1_LO                                                    0xd302
#define mmTD_PERFCOUNTER0_HI                                                    0xd301
#define mmTD_PERFCOUNTER1_HI                                                    0xd303
#define mmTD_SCRATCH                                                            0x2533
#define mmTA_CNTL                                                               0x2541
#define mmTA_CNTL_AUX                                                           0x2542
#define mmTA_RESERVED_010C                                                      0x2543
#define mmTA_CS_BC_BASE_ADDR                                                    0xc380
#define mmTA_CS_BC_BASE_ADDR_HI                                                 0xc381
#define mmTA_STATUS                                                             0x2548
#define mmTA_DEBUG_INDEX                                                        0x254c
#define mmTA_DEBUG_DATA                                                         0x254d
#define mmTA_PERFCOUNTER0_SELECT                                                0xdac0
#define mmTA_PERFCOUNTER1_SELECT                                                0xdac2
#define mmTA_PERFCOUNTER0_SELECT1                                               0xdac1
#define mmTA_PERFCOUNTER0_LO                                                    0xd2c0
#define mmTA_PERFCOUNTER1_LO                                                    0xd2c2
#define mmTA_PERFCOUNTER0_HI                                                    0xd2c1
#define mmTA_PERFCOUNTER1_HI                                                    0xd2c3
#define mmTA_SCRATCH                                                            0x2564
#define mmSH_HIDDEN_PRIVATE_BASE_VMID                                           0x2580
#define mmSH_STATIC_MEM_CONFIG                                                  0x2581
#define mmTCP_INVALIDATE                                                        0x2b00
#define mmTCP_STATUS                                                            0x2b01
#define mmTCP_CNTL                                                              0x2b02
#define mmTCP_CHAN_STEER_LO                                                     0x2b03
#define mmTCP_CHAN_STEER_HI                                                     0x2b04
#define mmTCP_ADDR_CONFIG                                                       0x2b05
#define mmTCP_CREDIT                                                            0x2b06
#define mmTCP_PERFCOUNTER0_SELECT                                               0xdb40
#define mmTCP_PERFCOUNTER1_SELECT                                               0xdb42
#define mmTCP_PERFCOUNTER0_SELECT1                                              0xdb41
#define mmTCP_PERFCOUNTER1_SELECT1                                              0xdb43
#define mmTCP_PERFCOUNTER2_SELECT                                               0xdb44
#define mmTCP_PERFCOUNTER3_SELECT                                               0xdb45
#define mmTCP_PERFCOUNTER0_LO                                                   0xd340
#define mmTCP_PERFCOUNTER1_LO                                                   0xd342
#define mmTCP_PERFCOUNTER2_LO                                                   0xd344
#define mmTCP_PERFCOUNTER3_LO                                                   0xd346
#define mmTCP_PERFCOUNTER0_HI                                                   0xd341
#define mmTCP_PERFCOUNTER1_HI                                                   0xd343
#define mmTCP_PERFCOUNTER2_HI                                                   0xd345
#define mmTCP_PERFCOUNTER3_HI                                                   0xd347
#define mmTCP_BUFFER_ADDR_HASH_CNTL                                             0x2b16
#define mmTCP_EDC_COUNTER                                                       0x2b17
#define mmTC_CFG_L1_LOAD_POLICY0                                                0x2b1a
#define mmTC_CFG_L1_LOAD_POLICY1                                                0x2b1b
#define mmTC_CFG_L1_STORE_POLICY                                                0x2b1c
#define mmTC_CFG_L2_LOAD_POLICY0                                                0x2b1d
#define mmTC_CFG_L2_LOAD_POLICY1                                                0x2b1e
#define mmTC_CFG_L2_STORE_POLICY0                                               0x2b1f
#define mmTC_CFG_L2_STORE_POLICY1                                               0x2b20
#define mmTC_CFG_L2_ATOMIC_POLICY                                               0x2b21
#define mmTC_CFG_L1_VOLATILE                                                    0x2b22
#define mmTC_CFG_L2_VOLATILE                                                    0x2b23
#define mmTCP_WATCH0_ADDR_H                                                     0x32a0
#define mmTCP_WATCH1_ADDR_H                                                     0x32a3
#define mmTCP_WATCH2_ADDR_H                                                     0x32a6
#define mmTCP_WATCH3_ADDR_H                                                     0x32a9
#define mmTCP_WATCH0_ADDR_L                                                     0x32a1
#define mmTCP_WATCH1_ADDR_L                                                     0x32a4
#define mmTCP_WATCH2_ADDR_L                                                     0x32a7
#define mmTCP_WATCH3_ADDR_L                                                     0x32aa
#define mmTCP_WATCH0_CNTL                                                       0x32a2
#define mmTCP_WATCH1_CNTL                                                       0x32a5
#define mmTCP_WATCH2_CNTL                                                       0x32a8
#define mmTCP_WATCH3_CNTL                                                       0x32ab
#define mmTD_CGTT_CTRL                                                          0xf09c
#define mmTA_CGTT_CTRL                                                          0xf09d
#define mmCGTT_TCP_CLK_CTRL                                                     0xf09e
#define mmCGTT_TCI_CLK_CTRL                                                     0xf09f
#define mmTCI_STATUS                                                            0x2b61
#define mmTCI_CNTL_1                                                            0x2b62
#define mmTCI_CNTL_2                                                            0x2b63
#define mmGDS_CONFIG                                                            0x25c0
#define mmGDS_CNTL_STATUS                                                       0x25c1
#define mmGDS_ENHANCE                                                           0x25c2
#define mmGDS_PROTECTION_FAULT                                                  0x25c3
#define mmGDS_VM_PROTECTION_FAULT                                               0x25c4
#define mmGDS_SECDED_CNT                                                        0x25c5
#define mmGDS_GRBM_SECDED_CNT                                                   0x25c6
#define mmGDS_OA_DED                                                            0x25c7
#define mmGDS_DEBUG_CNTL                                                        0x25c8
#define mmGDS_DEBUG_DATA                                                        0x25c9
#define mmCGTT_GDS_CLK_CTRL                                                     0xf0a0
#define mmGDS_RD_ADDR                                                           0xc400
#define mmGDS_RD_DATA                                                           0xc401
#define mmGDS_RD_BURST_ADDR                                                     0xc402
#define mmGDS_RD_BURST_COUNT                                                    0xc403
#define mmGDS_RD_BURST_DATA                                                     0xc404
#define mmGDS_WR_ADDR                                                           0xc405
#define mmGDS_WR_DATA                                                           0xc406
#define mmGDS_WR_BURST_ADDR                                                     0xc407
#define mmGDS_WR_BURST_DATA                                                     0xc408
#define mmGDS_WRITE_COMPLETE                                                    0xc409
#define mmGDS_ATOM_CNTL                                                         0xc40a
#define mmGDS_ATOM_COMPLETE                                                     0xc40b
#define mmGDS_ATOM_BASE                                                         0xc40c
#define mmGDS_ATOM_SIZE                                                         0xc40d
#define mmGDS_ATOM_OFFSET0                                                      0xc40e
#define mmGDS_ATOM_OFFSET1                                                      0xc40f
#define mmGDS_ATOM_DST                                                          0xc410
#define mmGDS_ATOM_OP                                                           0xc411
#define mmGDS_ATOM_SRC0                                                         0xc412
#define mmGDS_ATOM_SRC0_U                                                       0xc413
#define mmGDS_ATOM_SRC1                                                         0xc414
#define mmGDS_ATOM_SRC1_U                                                       0xc415
#define mmGDS_ATOM_READ0                                                        0xc416
#define mmGDS_ATOM_READ0_U                                                      0xc417
#define mmGDS_ATOM_READ1                                                        0xc418
#define mmGDS_ATOM_READ1_U                                                      0xc419
#define mmGDS_GWS_RESOURCE_CNTL                                                 0xc41a
#define mmGDS_GWS_RESOURCE                                                      0xc41b
#define mmGDS_GWS_RESOURCE_CNT                                                  0xc41c
#define mmGDS_OA_CNTL                                                           0xc41d
#define mmGDS_OA_COUNTER                                                        0xc41e
#define mmGDS_OA_ADDRESS                                                        0xc41f
#define mmGDS_OA_INCDEC                                                         0xc420
#define ixGDS_DEBUG_REG0                                                        0x0
#define ixGDS_DEBUG_REG1                                                        0x1
#define ixGDS_DEBUG_REG2                                                        0x2
#define ixGDS_DEBUG_REG3                                                        0x3
#define ixGDS_DEBUG_REG4                                                        0x4
#define ixGDS_DEBUG_REG5                                                        0x5
#define ixGDS_DEBUG_REG6                                                        0x6
#define mmGDS_PERFCOUNTER0_SELECT                                               0xda80
#define mmGDS_PERFCOUNTER1_SELECT                                               0xda81
#define mmGDS_PERFCOUNTER2_SELECT                                               0xda82
#define mmGDS_PERFCOUNTER3_SELECT                                               0xda83
#define mmGDS_PERFCOUNTER0_LO                                                   0xd280
#define mmGDS_PERFCOUNTER1_LO                                                   0xd282
#define mmGDS_PERFCOUNTER2_LO                                                   0xd284
#define mmGDS_PERFCOUNTER3_LO                                                   0xd286
#define mmGDS_PERFCOUNTER0_HI                                                   0xd281
#define mmGDS_PERFCOUNTER1_HI                                                   0xd283
#define mmGDS_PERFCOUNTER2_HI                                                   0xd285
#define mmGDS_PERFCOUNTER3_HI                                                   0xd287
#define mmGDS_PERFCOUNTER0_SELECT1                                              0xda84
#define mmGDS_VMID0_BASE                                                        0x3300
#define mmGDS_VMID1_BASE                                                        0x3302
#define mmGDS_VMID2_BASE                                                        0x3304
#define mmGDS_VMID3_BASE                                                        0x3306
#define mmGDS_VMID4_BASE                                                        0x3308
#define mmGDS_VMID5_BASE                                                        0x330a
#define mmGDS_VMID6_BASE                                                        0x330c
#define mmGDS_VMID7_BASE                                                        0x330e
#define mmGDS_VMID8_BASE                                                        0x3310
#define mmGDS_VMID9_BASE                                                        0x3312
#define mmGDS_VMID10_BASE                                                       0x3314
#define mmGDS_VMID11_BASE                                                       0x3316
#define mmGDS_VMID12_BASE                                                       0x3318
#define mmGDS_VMID13_BASE                                                       0x331a
#define mmGDS_VMID14_BASE                                                       0x331c
#define mmGDS_VMID15_BASE                                                       0x331e
#define mmGDS_VMID0_SIZE                                                        0x3301
#define mmGDS_VMID1_SIZE                                                        0x3303
#define mmGDS_VMID2_SIZE                                                        0x3305
#define mmGDS_VMID3_SIZE                                                        0x3307
#define mmGDS_VMID4_SIZE                                                        0x3309
#define mmGDS_VMID5_SIZE                                                        0x330b
#define mmGDS_VMID6_SIZE                                                        0x330d
#define mmGDS_VMID7_SIZE                                                        0x330f
#define mmGDS_VMID8_SIZE                                                        0x3311
#define mmGDS_VMID9_SIZE                                                        0x3313
#define mmGDS_VMID10_SIZE                                                       0x3315
#define mmGDS_VMID11_SIZE                                                       0x3317
#define mmGDS_VMID12_SIZE                                                       0x3319
#define mmGDS_VMID13_SIZE                                                       0x331b
#define mmGDS_VMID14_SIZE                                                       0x331d
#define mmGDS_VMID15_SIZE                                                       0x331f
#define mmGDS_GWS_VMID0                                                         0x3320
#define mmGDS_GWS_VMID1                                                         0x3321
#define mmGDS_GWS_VMID2                                                         0x3322
#define mmGDS_GWS_VMID3                                                         0x3323
#define mmGDS_GWS_VMID4                                                         0x3324
#define mmGDS_GWS_VMID5                                                         0x3325
#define mmGDS_GWS_VMID6                                                         0x3326
#define mmGDS_GWS_VMID7                                                         0x3327
#define mmGDS_GWS_VMID8                                                         0x3328
#define mmGDS_GWS_VMID9                                                         0x3329
#define mmGDS_GWS_VMID10                                                        0x332a
#define mmGDS_GWS_VMID11                                                        0x332b
#define mmGDS_GWS_VMID12                                                        0x332c
#define mmGDS_GWS_VMID13                                                        0x332d
#define mmGDS_GWS_VMID14                                                        0x332e
#define mmGDS_GWS_VMID15                                                        0x332f
#define mmGDS_OA_VMID0                                                          0x3330
#define mmGDS_OA_VMID1                                                          0x3331
#define mmGDS_OA_VMID2                                                          0x3332
#define mmGDS_OA_VMID3                                                          0x3333
#define mmGDS_OA_VMID4                                                          0x3334
#define mmGDS_OA_VMID5                                                          0x3335
#define mmGDS_OA_VMID6                                                          0x3336
#define mmGDS_OA_VMID7                                                          0x3337
#define mmGDS_OA_VMID8                                                          0x3338
#define mmGDS_OA_VMID9                                                          0x3339
#define mmGDS_OA_VMID10                                                         0x333a
#define mmGDS_OA_VMID11                                                         0x333b
#define mmGDS_OA_VMID12                                                         0x333c
#define mmGDS_OA_VMID13                                                         0x333d
#define mmGDS_OA_VMID14                                                         0x333e
#define mmGDS_OA_VMID15                                                         0x333f
#define mmGDS_GWS_RESET0                                                        0x3344
#define mmGDS_GWS_RESET1                                                        0x3345
#define mmGDS_GWS_RESOURCE_RESET                                                0x3346
#define mmGDS_COMPUTE_MAX_WAVE_ID                                               0x3348
#define mmGDS_OA_RESET_MASK                                                     0x3349
#define mmGDS_OA_RESET                                                          0x334a
#define mmCS_COPY_STATE                                                         0xa1f3
#define mmGFX_COPY_STATE                                                        0xa1f4
#define mmVGT_DRAW_INITIATOR                                                    0xa1fc
#define mmVGT_EVENT_INITIATOR                                                   0xa2a4
#define mmVGT_EVENT_ADDRESS_REG                                                 0xa1fe
#define mmVGT_DMA_BASE_HI                                                       0xa1f9
#define mmVGT_DMA_BASE                                                          0xa1fa
#define mmVGT_DMA_INDEX_TYPE                                                    0xa29f
#define mmVGT_DMA_NUM_INSTANCES                                                 0xa2a2
#define mmIA_ENHANCE                                                            0xa29c
#define mmVGT_DMA_SIZE                                                          0xa29d
#define mmVGT_DMA_MAX_SIZE                                                      0xa29e
#define mmVGT_DMA_PRIMITIVE_TYPE                                                0x2271
#define mmVGT_DMA_CONTROL                                                       0x2272
#define mmVGT_IMMED_DATA                                                        0xa1fd
#define mmVGT_INDEX_TYPE                                                        0xc243
#define mmVGT_NUM_INDICES                                                       0xc24c
#define mmVGT_NUM_INSTANCES                                                     0xc24d
#define mmVGT_PRIMITIVE_TYPE                                                    0xc242
#define mmVGT_PRIMITIVEID_EN                                                    0xa2a1
#define mmVGT_PRIMITIVEID_RESET                                                 0xa2a3
#define mmVGT_VTX_CNT_EN                                                        0xa2ae
#define mmVGT_REUSE_OFF                                                         0xa2ad
#define mmVGT_INSTANCE_STEP_RATE_0                                              0xa2a8
#define mmVGT_INSTANCE_STEP_RATE_1                                              0xa2a9
#define mmVGT_MAX_VTX_INDX                                                      0xa100
#define mmVGT_MIN_VTX_INDX                                                      0xa101
#define mmVGT_INDX_OFFSET                                                       0xa102
#define mmVGT_VERTEX_REUSE_BLOCK_CNTL                                           0xa316
#define mmVGT_OUT_DEALLOC_CNTL                                                  0xa317
#define mmVGT_MULTI_PRIM_IB_RESET_INDX                                          0xa103
#define mmVGT_MULTI_PRIM_IB_RESET_EN                                            0xa2a5
#define mmVGT_ENHANCE                                                           0xa294
#define mmVGT_OUTPUT_PATH_CNTL                                                  0xa284
#define mmVGT_HOS_CNTL                                                          0xa285
#define mmVGT_HOS_MAX_TESS_LEVEL                                                0xa286
#define mmVGT_HOS_MIN_TESS_LEVEL                                                0xa287
#define mmVGT_HOS_REUSE_DEPTH                                                   0xa288
#define mmVGT_GROUP_PRIM_TYPE                                                   0xa289
#define mmVGT_GROUP_FIRST_DECR                                                  0xa28a
#define mmVGT_GROUP_DECR                                                        0xa28b
#define mmVGT_GROUP_VECT_0_CNTL                                                 0xa28c
#define mmVGT_GROUP_VECT_1_CNTL                                                 0xa28d
#define mmVGT_GROUP_VECT_0_FMT_CNTL                                             0xa28e
#define mmVGT_GROUP_VECT_1_FMT_CNTL                                             0xa28f
#define mmVGT_VTX_VECT_EJECT_REG                                                0x222c
#define mmVGT_DMA_DATA_FIFO_DEPTH                                               0x222d
#define mmVGT_DMA_REQ_FIFO_DEPTH                                                0x222e
#define mmVGT_DRAW_INIT_FIFO_DEPTH                                              0x222f
#define mmVGT_LAST_COPY_STATE                                                   0x2230
#define mmCC_GC_SHADER_ARRAY_CONFIG                                             0x226f
#define mmGC_USER_SHADER_ARRAY_CONFIG                                           0x2270
#define mmVGT_GS_MODE                                                           0xa290
#define mmVGT_GS_ONCHIP_CNTL                                                    0xa291
#define mmVGT_GS_OUT_PRIM_TYPE                                                  0xa29b
#define mmVGT_CACHE_INVALIDATION                                                0x2231
#define mmVGT_RESET_DEBUG                                                       0x2232
#define mmVGT_STRMOUT_DELAY                                                     0x2233
#define mmVGT_FIFO_DEPTHS                                                       0x2234
#define mmVGT_GS_PER_ES                                                         0xa295
#define mmVGT_ES_PER_GS                                                         0xa296
#define mmVGT_GS_PER_VS                                                         0xa297
#define mmVGT_GS_VERTEX_REUSE                                                   0x2235
#define mmVGT_MC_LAT_CNTL                                                       0x2236
#define mmIA_CNTL_STATUS                                                        0x2237
#define mmVGT_STRMOUT_CONFIG                                                    0xa2e5
#define mmVGT_STRMOUT_BUFFER_SIZE_0                                             0xa2b4
#define mmVGT_STRMOUT_BUFFER_SIZE_1                                             0xa2b8
#define mmVGT_STRMOUT_BUFFER_SIZE_2                                             0xa2bc
#define mmVGT_STRMOUT_BUFFER_SIZE_3                                             0xa2c0
#define mmVGT_STRMOUT_BUFFER_OFFSET_0                                           0xa2b7
#define mmVGT_STRMOUT_BUFFER_OFFSET_1                                           0xa2bb
#define mmVGT_STRMOUT_BUFFER_OFFSET_2                                           0xa2bf
#define mmVGT_STRMOUT_BUFFER_OFFSET_3                                           0xa2c3
#define mmVGT_STRMOUT_VTX_STRIDE_0                                              0xa2b5
#define mmVGT_STRMOUT_VTX_STRIDE_1                                              0xa2b9
#define mmVGT_STRMOUT_VTX_STRIDE_2                                              0xa2bd
#define mmVGT_STRMOUT_VTX_STRIDE_3                                              0xa2c1
#define mmVGT_STRMOUT_BUFFER_CONFIG                                             0xa2e6
#define mmVGT_STRMOUT_BUFFER_FILLED_SIZE_0                                      0xc244
#define mmVGT_STRMOUT_BUFFER_FILLED_SIZE_1                                      0xc245
#define mmVGT_STRMOUT_BUFFER_FILLED_SIZE_2                                      0xc246
#define mmVGT_STRMOUT_BUFFER_FILLED_SIZE_3                                      0xc247
#define mmVGT_STRMOUT_DRAW_OPAQUE_OFFSET                                        0xa2ca
#define mmVGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE                            0xa2cb
#define mmVGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE                                 0xa2cc
#define mmVGT_GS_MAX_VERT_OUT                                                   0xa2ce
#define mmIA_VMID_OVERRIDE                                                      0x2260
#define mmVGT_SHADER_STAGES_EN                                                  0xa2d5
#define mmVGT_LS_HS_CONFIG                                                      0xa2d6
#define mmVGT_DMA_LS_HS_CONFIG                                                  0x2273
#define mmVGT_TF_PARAM                                                          0xa2db
#define mmVGT_TF_RING_SIZE                                                      0xc24e
#define mmVGT_SYS_CONFIG                                                        0x2263
#define mmVGT_HS_OFFCHIP_PARAM                                                  0xc24f
#define mmVGT_TF_MEMORY_BASE                                                    0xc250
#define mmVGT_GS_INSTANCE_CNT                                                   0xa2e4
#define mmIA_MULTI_VGT_PARAM                                                    0xa2aa
#define mmVGT_VS_MAX_WAVE_ID                                                    0x2268
#define mmVGT_ESGS_RING_SIZE                                                    0xc240
#define mmVGT_GSVS_RING_SIZE                                                    0xc241
#define mmVGT_GSVS_RING_OFFSET_1                                                0xa298
#define mmVGT_GSVS_RING_OFFSET_2                                                0xa299
#define mmVGT_GSVS_RING_OFFSET_3                                                0xa29a
#define mmVGT_ESGS_RING_ITEMSIZE                                                0xa2ab
#define mmVGT_GSVS_RING_ITEMSIZE                                                0xa2ac
#define mmVGT_GS_VERT_ITEMSIZE                                                  0xa2d7
#define mmVGT_GS_VERT_ITEMSIZE_1                                                0xa2d8
#define mmVGT_GS_VERT_ITEMSIZE_2                                                0xa2d9
#define mmVGT_GS_VERT_ITEMSIZE_3                                                0xa2da
#define mmWD_CNTL_STATUS                                                        0x223f
#define mmWD_ENHANCE                                                            0xa2a0
#define mmGFX_PIPE_CONTROL                                                      0x226d
#define mmGFX_PIPE_PRIORITY                                                     0xf87f
#define mmCGTT_VGT_CLK_CTRL                                                     0xf084
#define mmCGTT_IA_CLK_CTRL                                                      0xf085
#define mmCGTT_WD_CLK_CTRL                                                      0xf086
#define mmVGT_DEBUG_CNTL                                                        0x2238
#define mmVGT_DEBUG_DATA                                                        0x2239
#define mmIA_DEBUG_CNTL                                                         0x223a
#define mmIA_DEBUG_DATA                                                         0x223b
#define mmVGT_CNTL_STATUS                                                       0x223c
#define mmWD_DEBUG_CNTL                                                         0x223d
#define mmWD_DEBUG_DATA                                                         0x223e
#define mmCC_GC_PRIM_CONFIG                                                     0x2240
#define mmGC_USER_PRIM_CONFIG                                                   0x2241
#define ixWD_DEBUG_REG0                                                         0x0
#define ixWD_DEBUG_REG1                                                         0x1
#define ixWD_DEBUG_REG2                                                         0x2
#define ixWD_DEBUG_REG3                                                         0x3
#define ixWD_DEBUG_REG4                                                         0x4
#define ixWD_DEBUG_REG5                                                         0x5
#define ixIA_DEBUG_REG0                                                         0x0
#define ixIA_DEBUG_REG1                                                         0x1
#define ixIA_DEBUG_REG2                                                         0x2
#define ixIA_DEBUG_REG3                                                         0x3
#define ixIA_DEBUG_REG4                                                         0x4
#define ixIA_DEBUG_REG5                                                         0x5
#define ixIA_DEBUG_REG6                                                         0x6
#define ixIA_DEBUG_REG7                                                         0x7
#define ixIA_DEBUG_REG8                                                         0x8
#define ixIA_DEBUG_REG9                                                         0x9
#define ixVGT_DEBUG_REG0                                                        0x0
#define ixVGT_DEBUG_REG1                                                        0x1
#define ixVGT_DEBUG_REG2                                                        0x1e
#define ixVGT_DEBUG_REG3                                                        0x1f
#define ixVGT_DEBUG_REG4                                                        0x20
#define ixVGT_DEBUG_REG5                                                        0x21
#define ixVGT_DEBUG_REG6                                                        0x22
#define ixVGT_DEBUG_REG7                                                        0x23
#define ixVGT_DEBUG_REG8                                                        0x8
#define ixVGT_DEBUG_REG9                                                        0x9
#define ixVGT_DEBUG_REG10                                                       0xa
#define ixVGT_DEBUG_REG11                                                       0xb
#define ixVGT_DEBUG_REG12                                                       0xc
#define ixVGT_DEBUG_REG13                                                       0xd
#define ixVGT_DEBUG_REG14                                                       0xe
#define ixVGT_DEBUG_REG15                                                       0xf
#define ixVGT_DEBUG_REG16                                                       0x10
#define ixVGT_DEBUG_REG17                                                       0x11
#define ixVGT_DEBUG_REG18                                                       0x7
#define ixVGT_DEBUG_REG19                                                       0x13
#define ixVGT_DEBUG_REG20                                                       0x14
#define ixVGT_DEBUG_REG21                                                       0x15
#define ixVGT_DEBUG_REG22                                                       0x16
#define ixVGT_DEBUG_REG23                                                       0x17
#define ixVGT_DEBUG_REG24                                                       0x18
#define ixVGT_DEBUG_REG25                                                       0x19
#define ixVGT_DEBUG_REG26                                                       0x24
#define ixVGT_DEBUG_REG27                                                       0x1b
#define ixVGT_DEBUG_REG28                                                       0x1c
#define ixVGT_DEBUG_REG29                                                       0x1d
#define ixVGT_DEBUG_REG30                                                       0x25
#define ixVGT_DEBUG_REG31                                                       0x26
#define ixVGT_DEBUG_REG32                                                       0x27
#define ixVGT_DEBUG_REG33                                                       0x28
#define ixVGT_DEBUG_REG34                                                       0x29
#define ixVGT_DEBUG_REG35                                                       0x2a
#define mmVGT_PERFCOUNTER_SEID_MASK                                             0xd894
#define mmVGT_PERFCOUNTER0_SELECT                                               0xd88c
#define mmVGT_PERFCOUNTER1_SELECT                                               0xd88d
#define mmVGT_PERFCOUNTER2_SELECT                                               0xd88e
#define mmVGT_PERFCOUNTER3_SELECT                                               0xd88f
#define mmVGT_PERFCOUNTER0_SELECT1                                              0xd890
#define mmVGT_PERFCOUNTER1_SELECT1                                              0xd891
#define mmVGT_PERFCOUNTER0_LO                                                   0xd090
#define mmVGT_PERFCOUNTER1_LO                                                   0xd092
#define mmVGT_PERFCOUNTER2_LO                                                   0xd094
#define mmVGT_PERFCOUNTER3_LO                                                   0xd096
#define mmVGT_PERFCOUNTER0_HI                                                   0xd091
#define mmVGT_PERFCOUNTER1_HI                                                   0xd093
#define mmVGT_PERFCOUNTER2_HI                                                   0xd095
#define mmVGT_PERFCOUNTER3_HI                                                   0xd097
#define mmIA_PERFCOUNTER0_SELECT                                                0xd884
#define mmIA_PERFCOUNTER1_SELECT                                                0xd885
#define mmIA_PERFCOUNTER2_SELECT                                                0xd886
#define mmIA_PERFCOUNTER3_SELECT                                                0xd887
#define mmIA_PERFCOUNTER0_SELECT1                                               0xd888
#define mmIA_PERFCOUNTER0_LO                                                    0xd088
#define mmIA_PERFCOUNTER1_LO                                                    0xd08a
#define mmIA_PERFCOUNTER2_LO                                                    0xd08c
#define mmIA_PERFCOUNTER3_LO                                                    0xd08e
#define mmIA_PERFCOUNTER0_HI                                                    0xd089
#define mmIA_PERFCOUNTER1_HI                                                    0xd08b
#define mmIA_PERFCOUNTER2_HI                                                    0xd08d
#define mmIA_PERFCOUNTER3_HI                                                    0xd08f
#define mmWD_PERFCOUNTER0_SELECT                                                0xd880
#define mmWD_PERFCOUNTER1_SELECT                                                0xd881
#define mmWD_PERFCOUNTER2_SELECT                                                0xd882
#define mmWD_PERFCOUNTER3_SELECT                                                0xd883
#define mmWD_PERFCOUNTER0_LO                                                    0xd080
#define mmWD_PERFCOUNTER1_LO                                                    0xd082
#define mmWD_PERFCOUNTER2_LO                                                    0xd084
#define mmWD_PERFCOUNTER3_LO                                                    0xd086
#define mmWD_PERFCOUNTER0_HI                                                    0xd081
#define mmWD_PERFCOUNTER1_HI                                                    0xd083
#define mmWD_PERFCOUNTER2_HI                                                    0xd085
#define mmWD_PERFCOUNTER3_HI                                                    0xd087
#define mmDIDT_IND_INDEX                                                        0x3280
#define mmDIDT_IND_DATA                                                         0x3281
#define ixDIDT_SQ_CTRL0                                                         0x0
#define ixDIDT_SQ_CTRL1                                                         0x1
#define ixDIDT_SQ_CTRL2                                                         0x2
#define ixDIDT_SQ_WEIGHT0_3                                                     0x10
#define ixDIDT_SQ_WEIGHT4_7                                                     0x11
#define ixDIDT_SQ_WEIGHT8_11                                                    0x12
#define ixDIDT_DB_CTRL0                                                         0x20
#define ixDIDT_DB_CTRL1                                                         0x21
#define ixDIDT_DB_CTRL2                                                         0x22
#define ixDIDT_DB_WEIGHT0_3                                                     0x30
#define ixDIDT_DB_WEIGHT4_7                                                     0x31
#define ixDIDT_DB_WEIGHT8_11                                                    0x32
#define ixDIDT_TD_CTRL0                                                         0x40
#define ixDIDT_TD_CTRL1                                                         0x41
#define ixDIDT_TD_CTRL2                                                         0x42
#define ixDIDT_TD_WEIGHT0_3                                                     0x50
#define ixDIDT_TD_WEIGHT4_7                                                     0x51
#define ixDIDT_TD_WEIGHT8_11                                                    0x52
#define ixDIDT_TCP_CTRL0                                                        0x60
#define ixDIDT_TCP_CTRL1                                                        0x61
#define ixDIDT_TCP_CTRL2                                                        0x62
#define ixDIDT_TCP_WEIGHT0_3                                                    0x70
#define ixDIDT_TCP_WEIGHT4_7                                                    0x71
#define ixDIDT_TCP_WEIGHT8_11                                                   0x72

#endif /* GFX_7_0_D_H */
