//	PenView.m      (by Mike Mahoney,  1/22/91)
	
#import "PenView.h"

@implementation PenView

- initFrame:(const NXRect *) frameRect
{
	self = [super initFrame:frameRect];							                			//  load pencilCursor
	pencilCursor = [NXCursor newFromImage:[NXImage newFromSection:"pencil.tiff"]];   

	hotSpot.x = 0.0;    hotSpot.y = 15.0;        	//  hotSpot is the point on the  16 x 16  cursor
	[pencilCursor setHotSpot:&hotSpot];   	//    image that's aligned with the mouse
										//   the origin of a cursor is at upper left corner
	return self;
}

						 //  implemented only to get the initial Slider value
- setSliderOutlet:sender	//  it also initializes sliderOutlet, but that would be done
{						//  automatically by the system if this method wasn't here
	sliderOutlet = sender;
	penWidth = [sliderOutlet floatValue];      //  read the value of the Slider (set in IB)
	return self;
}

					 	//   this method is used to initialize the Form text to the
- setFormOutlet:sender	//        penWidth value obtained in setSliderOutlet above
{						//  it also initializes the formOutlet
	formOutlet = sender;
	[formOutlet setFloatValue: penWidth at:0];	return self;
} 

					
- changePenWidth:sender   // gets the penWidth value from the Slider object (the "sender")
{
 	penWidth = [sender floatValue];			       // get the penWidth value
	[formOutlet setFloatValue: penWidth at:0];     //  update Form with new penWidth value
    	return self;
}


- clearView:sender	  					 //   used only to clear PenView 
{										 //   see the drawSelf method below
	[self display];	//  sets up a graphics context and invokes drawSelf below
 	return self;
}


- drawSelf:(NXRect *)rects :(int) rectCount;	  //   used only to clear PenView 
{										  //   see the clearView method above
	PSsetgray (NX_WHITE);
	NXRectFill (&bounds);				//  fill entire PenView with white
	PSsetgray (NX_BLACK);
	NXFrameRect (&bounds);				//  draw a black frame around PenView
	
	return self;
}	


- resetCursorRects				//  resets PenView's cursor rectangle 
{								//    so pencil shows up inside PenView
	[self addCursorRect:&bounds cursor:pencilCursor];      //  set cursor rectangle
	return self;				// for details look up these methods in View class docs.

}


- mouseDown: (NXEvent *) theEvent	//  our own implementation of mouseDown 
{									//   It will be called every time the mouse
	NXPoint	 currentPos, oldPos;		//      button is pressed down   
	NXEvent	 *nextEvent;				//      inside the PenView object (View)
	BOOL	looping = 1;    // true
	int		oldMask;				//  mouse event masks
	int		checkMask;
	
	
	oldMask = [window eventMask];			
										
	checkMask = NX_MOUSEUPMASK | NX_MOUSEDRAGGEDMASK;
	
	[window setEventMask: (oldMask | checkMask)];
	
	[self lockFocus];		//  locks the PS focus on PenView prior to any drawing
						//  lockFocus/unlockFocus not needed in drawSelf
	oldPos = theEvent -> location;		//  get starting location for a very short line
	[self convertPoint: &oldPos fromView:nil];   //  converts oldPos from "My Window"
										     //      coordinates to penView's coords.
	PSsetlinewidth (penWidth);
	
				
	while (looping)  {			//  takes over event loop while mouse is pressed down
		nextEvent = [NXApp getNextEvent: checkMask];
		
		looping = (nextEvent -> type != NX_MOUSEUP);  //  if mouseup, looping = FALSE 
		
		if (looping)  {
			currentPos = nextEvent -> location;
			[self convertPoint: &currentPos fromView:nil];
			
			if ((currentPos.x != oldPos.x) | (currentPos.y != oldPos.y))  {
				PSnewpath ();			             //  We don't use drawSelf because
				PSmoveto (oldPos.x, oldPos.y);    //      of  dynamic drawing                
				PSlineto (currentPos.x, currentPos.y);
				PSstroke ();
				oldPos = currentPos;
				[window flushWindow];     // this message is needed else scribbling is
										//   only displayed when a Slider is moved
			}
		}
	}
	[self unlockFocus];
	
	[window setEventMask: oldMask];
	
	return self;
	
}	/* end of mouseDown */


@end    // implementation
