/* 
 * PlotViewInspector.m -- Implementation file for the PlotViewInspector class 
 *
 * You may freely copy, distribute, and reuse the code in this example.
 * NeXT disclaims any warranty of any kind, expressed or implied, as to its
 * fitness for any particular use.
 *
 */

#import "PlotViewInspector.h"
#import "PlotView.h"
#import <appkit/Application.h>
#import <appkit/Slider.h>
#import <appkit/TextField.h>

@implementation PlotViewInspector

+ finishLoading:(struct mach_header *)header 
{
    NIBDidLoadClass(self, header);
    return nil;
}

+ startUnloading 
{
    NIBWillUnloadClass(self);
    return nil;
}

- init
{
    [super init];
    [NXApp loadNibSection:"PlotViewInspector.nib" owner:self];
    lastRadius = [theSlider floatValue];
    return self;
}

- ok:sender
{
    lastRadius = [theSlider floatValue];
    [object setRadius:lastRadius];
    return self;
}

- revert:sender
{
    [theSlider setFloatValue:lastRadius];
    [theTextField setFloatValue:lastRadius];
    [object setRadius:lastRadius];
    return self;
}

@end
