/* 
 * PlotView.h -- Interface file for the PlotView class 
 *
 * You may freely copy, distribute, and reuse the code in this example.
 * NeXT disclaims any warranty of any kind, expressed or implied, as to its
 * fitness for any particular use.
 *
 */

#import <appkit/View.h>

@interface PlotView:View
{
	id		delegate;
	id		points;
	id		crossCursor;
	id		readOut;
	float		radius;
	BOOL		needsClearing;
}
- initFrame:(const NXRect *)frameRect;
- setDelegate:anObject;
- drawSelf:(const NXRect *)rects :(int)rectCount;
- sizeTo:(NXCoord)width :(NXCoord)height;
- clear:sender;
- plot:sender;
- mouseDown:(NXEvent *)theEvent;
- registerPoint:(NXPoint *)aPoint;
- setRadius:(float)aFloat;
- (float)radius;
- read:(NXTypedStream *)stream;
- write:(NXTypedStream *)stream;
- awake;
- (const char *)inspectorName;
@end

@interface Object(PlotViewDelegate)
- plotView:sender providePoints:(NXStream **)stream;
- plotView:sender pointDidChange:(NXPoint *)aPoint;
@end

