/*
    objc-load.h - Dynamically load in Obj-C modules (Classes, Categories)

    Copyright (C) 1993, Adam Fedor.
    
    objc-load.h,v 1.4 1994/07/18 19:16:59 kamerer Exp
*/

#ifndef _OBJC_LOAD_INCLUDE_
#define _OBJC_LOAD_INCLUDE_

#include <stdio.h>
#include <objc/objc.h>
#include <objc/objc-api.h>

#define objc_lookUpClass objc_lookup_class
extern char *objc_executable_location();

extern long objc_load_module(
	char *module,
	FILE *errorStream,
	void (*loadCallback)(Class*, Category*)
);

extern long objc_unload_module(
	FILE *errorStream,
	void (*unloadCallback)(Class*, Category*)
);

#endif /* _OBJC_LOAD_H_ */
