/* Archiving Category for Window
 *
 * Copyright (C)  1993  The Board of Trustees of
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Imran Qureshi, and Libing Wang
 *
 * This file is part of the nib translator for 
 * an Objective-C class library for X/Motif
 *
 * XmWindow.m,v 1.15 1994/07/19 01:10:58 fxmlk Exp
 */

#include "/NextDeveloper/Headers/objc/typedstream.h"
#include "/NextDeveloper/Headers/objc/Object.h"
#include <stdio.h>
#include <stdlib.h>

#define NXTypedStream TypedStream
#include <appkit/Window.h>

@interface Window (XmArchiving)
- convertCoordToMotif:sender;
- write:(TypedStream *)stream;
@end

#include "archive-def.h"

@implementation Window (XmArchiving)

/* only window should really send a message down to convert Coords */
- convertCoordToMotif:sender
{
    return [contentView convertCoordToMotif:self];
}

- write:(TypedStream *)stream
{
    char	aChar;
    int		anInt;

    [super write:stream];
   
#ifdef DEBUG
    printf("->(Window = %s)", [self title]);
#endif

    objc_write_rect(stream, &frame);
    objc_write_string(stream,[self title], strlen([self title]) + 1);
    objc_write_object(stream, contentView);

    anInt = wFlags.style;
    objc_write_type( stream, "i", &anInt );
    anInt = wFlags.backing;
    objc_write_type( stream, "i", &anInt );
    anInt = wFlags.buttonMask;
    objc_write_type( stream, "i", &anInt );
    
    aChar = wFlags.visible;
    objc_write_type( stream, "c", &aChar );
    aChar = wFlags.isMainWindow;
    objc_write_type( stream, "c", &aChar);
    aChar = wFlags.isKeyWindow;
    objc_write_type( stream, "c", &aChar);
    aChar = wFlags.isPanel;
    objc_write_type( stream, "c", &aChar);
    aChar = wFlags.hideOnDeactivate;
    objc_write_type( stream, "c", &aChar);
    aChar = wFlags.dontFreeWhenClosed;
    objc_write_type( stream, "c", &aChar);
    aChar = wFlags.oneShot;
    objc_write_type( stream, "c", &aChar);
    
    aChar = wFlags2.deferred;
    objc_write_type( stream, "c", &aChar);
    aChar = wFlags2.docEdited;
    objc_write_type( stream, "c", &aChar);
    aChar = wFlags2.dynamicDepthLimit;
    objc_write_type( stream, "c", &aChar);

    return self;
}

@end
