/*  Archiving Category for Object
    Copyright (C)  1993  The Board of Trustees of
    The Leland Stanford Junior University.  All Rights Reserved.

Authors: Imran Qureshi

 * This file is part of the nib translator for 
 * an Objective-C class library for X/Motif

XmObject.m,v 1.14 1994/06/11 03:53:50 pfkeb Exp

*/

#include "XmObject.h"
#include <stdio.h>
#include <stdlib.h>
#include <objc/List.h>

/* declared in Translator.m */
extern List	*list_of_objects;
extern List	*list_of_connections;

@implementation Object (XmArchiving)
- write:(TypedStream *)stream
{
#ifdef DEBUG
	printf("\nWriting Object");
#endif
	return self;
}

/* This is only called for the major objects (I think) */
- awakeFromNib
{
#ifdef DEBUG
    printf("awakeFromNib: %s\n", [self name]);
#endif

 /*
  * Add only Window objects and CustomObjects to the list. Everything else is
  * owned by Window or a subview. 
  */

 /*
  * This should be isKindOfClassNamed: once archiving methods for Panels and
  * Menus are written 
  */
    if ([self isMemberOfClassNamed:"Window"])
	[self addToList:list_of_objects];

    if ([self isMemberOfClassNamed:"Panel"])
	[self addToList:list_of_objects];


 /* make sure CustomObjects come after Windows */
 /* SO use AddObject instead of insertObject */
    if ([self isKindOfClassNamed:"CustomObject"])
	[list_of_objects addObject:self];


    return self;
}

-addToList:list
{
    [list insertObject:self at:0];
    return self;
}

/* This gets called for every object, every time it is unarchived 
  including objects like IBControlConnector */
-awake
{
#ifdef DEBUG
    printf("Awaking %s..\n",[self name]);
#endif
 /*
  * if this object is IBOutletConnector, add it to the list of objects to be
  * archived  
  */
    if ( [self isMemberOfClassNamed:"IBOutletConnector"] ) {
	[list_of_connections insertObject:self at:0];
    }
 /*
  * if this object is IBControlConnector, add it to the list of objects to be
  * archived  
  */

    if ( [self isMemberOfClassNamed: "IBControlConnector"] ) {
	[list_of_connections insertObject:self at:0];
    }
    return self;
}

@end
