/*  Archiving Category for CustomView
    Copyright (C)  1993  The Board of Trustees of
    The Leland Stanford Junior University.  All Rights Reserved.

Authors: Paul Kunz, Imran Qureshi

 * This file is part of the nib translator for 
 * an Objective-C class library for X/Motif

XmCustomView.h,v 1.5 1994/06/11 03:53:29 pfkeb Exp

*/

#include "/NextDeveloper/Headers/objc/typedstream.h"
#include "/NextDeveloper/Headers/appkit/View.h"

#define NXTypedStream TypedStream
#include <apps/InterfaceBuilder.h>


/* This are interfaces for NeXT Custom Objects */

@interface CustomView:View
{
  char	*className;
  id    realObject;
  id    extension;
}
- free;
- write:(NXTypedStream *)s;
- read:(NXTypedStream *)s;
- initFrame:(NXRect*)frameRect;
- awake;
- nibInstantiate;

@end

/* And now the category additions */

@interface CustomView (XmArchiving)
- initFrame:(NXRect*)frameRect;
- free;
- nibInstantiate;
- write:(TypedStream *)stream;
@end

