/*  Archiving Category for CustomObject
    Copyright (C)  1993  The Board of Trustees of
    The Leland Stanford Junior University.  All Rights Reserved.

Authors: Paul Kunz and Imran Qureshi

 * This file is part of the nib translator for 
 * an Objective-C class library for X/Motif

XmCustomObject.m,v 1.4 1994/06/11 03:53:27 pfkeb Exp

*/

#include "XmCustomObject.h"

/* declared in Translator.m */
extern BOOL 	fileOwnerAdded;
extern List	*list_of_objects;

@implementation CustomObject (XmArchiving)
- write:(TypedStream *)stream
{
 /*
  * if realObject exists here, it means this custom object was for the File's
  * Owner. So just write "FileOwner" for class name and we'll connect it
  * properly when this Custom Object is read in 
  */
    if (realObject)
	strcpy(className, "FileOwner");

    [super write:stream];

#ifdef DEBUG
    printf("->(CustomObject = %s)", className);
#endif

    objc_write_type(stream, "*", className);
    return self;
}
- init
{
	[super init];
	printf("CustomObject : init\n");
	return self;
}

- awake
{
    [super awake];
#ifdef DEBUG
    printf("        %s, realObject = %p\n", className, realObject);
#endif
    return self;
}

/* just trap nibInstantiate so it doesn't try to connect */
- nibInstantiate
{
    if ((realObject) && (!fileOwnerAdded)) {
	fileOwnerAdded = YES;
	[list_of_objects addObject:self];
#ifdef DEBUG
	printf("Adding FileOwner CustomObject\n");
#endif
    }
#ifdef DEBUG
    printf("CustomObject = %s: nibInstantiate = %p\n", className, realObject);
#endif
    return self;
}
- free
{
	printf("CustomObject : free\n");
	return [super free];
}
@end

