/*  Archiving Category for Cell
    Copyright (C)  1993  The Board of Trustees of
    The Leland Stanford Junior University.  All Rights Reserved.

Authors: Imran Qureshi

 * This file is part of the nib translator for 
 * an Objective-C class library for X/Motif

XmCell.m,v 1.8 1994/07/18 19:16:57 kamerer Exp

*/

#include "/NextDeveloper/Headers/objc/typedstream.h"
#include "/NextDeveloper/Headers/objc/Object.h"

#define NXTypedStream TypedStream
#include <appkit/Cell.h>

#include <stdlib.h>

@interface Cell (XmArchiving)
- write:(TypedStream *)stream;
@end

@implementation Cell (XmArchiving)
- write:(TypedStream *)stream
{
	int a;

    [super write:stream];

#ifdef DEBUG
    printf("->Cell");
#endif

 /* Let's protect the program from crashing by initializing contents */
    if (!contents) {
	contents = malloc(2);
	strcpy(contents, "");
    }
#ifdef DEBUG
    printf("(title=%s)", contents);
#endif
    objc_write_type(stream, "*", contents);
    a = [self isEnabled];
#ifdef DEBUG
    printf("(enabled=%d)", a);
#endif
	objc_write_type(stream, "i", &a);

    return self;
}
@end
