#
# common makefile
#
#common.make,v 1.2 1994/08/20 18:10:58 pfkeb Exp
#

all::

debug::
	$(MAKE) all CFLAGS="-g -Wall -I$(OSDIR) -DDEBUG"

profile::
	$(MAKE) all CFLAGS="-g -p -Wall -I$(OSDIR) -DDEBUG -DPROFILE"

CFLAGS = -g -O -Wall -I$(OSDIR) -I/usr/local/X11R5/include
OBJCFLAGS = -Wno-import

SUPPORTFILES = Makefile makefile

SRCFILES = $(CLASSES) \
	$(MFILES) $(CFILES) $(HFILES) \
	$(OTHERSRCS)

OFILES = $(CLASSES:.m=.o) $(MFILES:.m=.o) $(CFILES:.c=.o)

MAKEFILES = Makefile 

DIST = $(SRCFILES) $(MAKEFILES)

GARBAGE = $(NAME) *.o gmon.out *~ $(OTHERGARBAGE)

# Various commands:
SHELL  = /bin/sh
CHANGES = /usr/lib/changes
CHOWN  = /etc/chown
CHMOD  = /bin/chmod
TAR    = /bin/tar
STRIP  = /bin/strip
RM     = /bin/rm
ECHO   = /bin/echo
MKDIRS = /bin/mkdir -p
TOUCH  = /usr/bin/touch
AWK    = /bin/awk
INSTALL= /usr/bin/install
CP     = /bin/cp

.SUFFIXES: .m 

# Compilation rules:
.c.o:
	$(CC) $(CFLAGS) $(OTHER_CFLAGS) -c $*.c -o $*.o
.m.o:
	$(CC) $(CFLAGS) $(OTHER_CFLAGS) $(OBJCFLAGS) -c $*.m -o $*.o

# Build a set of dependencies for current level into Makefile.dependencies 
#depend:: Makefile.dependencies
   
#Makefile.dependencies:: $(CLASSES) $(MFILES) $(CFILES) $(HFILES)
depend:: $(CLASSES) $(MFILES) $(CFILES) $(HFILES)
	$(RM) -f Makefile.dependencies
	$(CC) -MM -Wno-import $(CFLAGS) $(OTHER_CFLAGS) \
		$(CLASSES) $(MFILES) $(CFILES) | \
	    $(AWK) '{ if ($$1 != prev) { if (rec != "") print rec; \
		rec = $$0; prev = $$1; } \
		else { if (length(rec $$2) > 70) { print rec; rec = $$0; } \
		else rec = rec " " $$2 } } \
		END { print rec }' > Makefile.dependencies

clean:: 
	$(RM) -f $(GARBAGE)

distclean:: clean

realclean:: distclean
