/*
    bundle - Test out dynamic linking

*/
#include <sys/param.h>
#include "appkit/NXBundle.h"
#include "LoadMe.bproj/LoadMe.h"
#include "LoadMe.bproj/SecondClass.h"
#include "LoadMe.bproj/MyCategory.h"

/* Realize externals that objcX should have */
#define NXArgv argv		/* latest definition? */
char     **NXArgv;

int 
main(int ac, char *av[]) 
{
    id main;
    id bundle;
    id object;
    BOOL ok;
    char path[MAXPATHLEN+1];
    
    NXArgv = av;

    main = [NXBundle mainBundle];
    if (!main) {
	printf("Can't get main bundle\n");
	exit(1);
    }
    printf("Main bundle directory is %s\n", [main directory]);
    ok = [main getPath:path forResource:"LoadMe" ofType:"bundle"];
    if (!ok) {
	printf("Can't find LoadMe bundle in main bundle\n");
	exit(1);
    }
    printf("Found %s\n\n", path);

    bundle = [[NXBundle alloc] initForDirectory:path];
    if (!bundle) {
	printf("Can't init LoadMe bundle\n");
	exit(1);
    }
    ok = [bundle getPath:path forResource:"readme" ofType:"txt"];
    if (!ok) {
	printf("Can't find readme in LoadMe bundle\n");
	exit(1);
    }
    printf("Found %s\n\n", path);

    object = [bundle principalClass];
    if (!object) {
#ifdef HAVE_LIBDLD
	printf("Can't find principal class\n");
	exit(1);
#else
	exit(0);
#endif
    }
    printf("Principal class is: %s\n", [object name]);

    printf("This is LoadMe:\n");
    object = [[[bundle classNamed:"LoadMe"] alloc] init];
    [object afterLoad];
    [object free];

    printf("\nThis is SecondClass:\n");
    object = [[[bundle classNamed:"SecondClass"] alloc] init];
    [object printName];
    [object printMyName];

    return 0;
}
