/* Motif WidgetSet category for implemenation of SliderCell class
 *
 * Copyright (C)  1993  The Board of Trustees of
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, and Libing Wang
 *
 * This file is part of an Objective-C class library for X/Motif
 *
 * xmSliderCell.m,v 1.2 1994/06/19 20:25:16 pfkeb Exp
 */

#include "SliderCell.h"

#include "Motif.h"
#include <Xm/Scale.h>

/* The callback function is at the end of this file */
static void
theCallback(Widget w,
	    XtPointer client_data,
	    XtPointer call_data);
	    
char *SliderCellInstanceName(void)
{
    return "SliderCell";
}

@implementation SliderCell(WidgetSet)

- _init
{
	classname = xmScaleWidgetClass;
	[self _addArg:XmNshowValue :(void *)TRUE];
	[self _addArg:XmNdecimalPoints :(void *)3];
	return self;
}

- _setMinValue
{
    int intValue;

    intValue = 1000.0*minValue;
    [self _setArg:XmNminimum to:(void*)intValue];
    return self;
}

- _setMaxValue
{
    int intValue;

    intValue = (int)(1000.0*maxValue);
    [self _setArg:XmNmaximum to:(void*)intValue];
    return self;
}

- _setValue
{
    int intValue;
    
    intValue = (int)(1000.0*value);
    [self _setArg:XmNvalue to:(void *)intValue];
    return self;
}

- (double)_value
{
    int intValue;
    
    [self _getArg:XmNvalue into:&intValue];
    value = (intValue/1000.0);
    return value;
}

- _setVertical:(BOOL)flag
{
    int val;
    if (flag)
	val = XmVERTICAL;
    else
	val = XmHORIZONTAL;
    /* Cannot be set after widget is "_managedBy" */
    [self _addArg:XmNorientation :(void*)val];
    return self;
}

- (int)_isVertical
{
    int val;
    XtVaGetValues(widgetid, XmNorientation, &val, NULL);
    return (val==XmVERTICAL);
}

- _addCallback
{
    XtAddCallback(widgetid, XmNdragCallback,         theCallback, self);
    XtAddCallback(widgetid, XmNvalueChangedCallback, theCallback, self);
    return self;
}

- _managedBy:parent wid:(void *)widget
{
    [self _setArg:XmNmarginWidth to:0];
    [self _setArg:XmNmarginHeight to:0];
    [super _managedBy:parent wid:widget];
    return self;
}

/* Private methods not declared in interface */
- _wasDragged
{
    wasDragged = YES;
    [self sendAction];
    return self;
}

- _valueChanged
{
    if ( wasDragged ) {
        wasDragged = NO;	/* to one message at end of dragging */
	return self;
    }
    [self sendAction];
    return self;
}

@end

static void
theCallback(Widget w,
	    XtPointer client_data,
	    XtPointer call_data)
{
    SliderCell* slider = (SliderCell *)client_data;
    XmScaleCallbackStruct *cb = (XmScaleCallbackStruct *)call_data;

    switch (cb->reason) {
    case XmCR_DRAG:
      	[slider _wasDragged];
	break;

    case XmCR_VALUE_CHANGED:
        [slider _valueChanged];
	break;

    default:
        break;
    }
}
