/* Motif WidgetSet category for Implemenation of Form class
 *
 * Copyright (C)  1993, 1994  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Fred Harris, Paul Kunz, 
 *          Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for X/Motif
 *
 * xmForm.m,v 1.1 1994/06/13 23:47:55 pfkeb Exp
 */

#include "Form.h"

#include "Application.h"
#include "FormCell.h"
// #include "TextField.h"
#include "Window.h"
#include "Motif.h"
#include <Xm/Text.h>
#include <Xm/LabelG.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xutil.h>

#include <coll/List.h>
// #include <stdlib.h>
// #include "stdmacros.h"

typedef struct {
    XFontStruct     *font;
    XmFontList      fontlist;
    XmString        titleStr;
    Dimension       strWidth;
    Dimension       strHeight;
} title_data, *title_data_ptr;

static XtResource resources[] = {
  {XtNfont, XtCFont, XtRFontStruct, sizeof (XFontStruct *),
     XtOffset(title_data_ptr, font), XtRString, "Fixed"  },
};

char *FormInstanceName(void)
{
    return "Form";
} 

@implementation Form(WidgetSet)

- _calcSize
{
    int		i, count;
    char 	*str;
    title_data	data;

    XtGetApplicationResources([window _shell], &data, resources,
                              XtNumber(resources), NULL, 0);
    data.fontlist = XmFontListCreate(data.font, XmSTRING_DEFAULT_CHARSET);
    count = [cellList count];
    for (i = 0; i < count; i++) {
      str = (char *)[[cellList objectAt:i] title];
      data.titleStr = XmStringCreate(str, XmSTRING_DEFAULT_CHARSET);
      XmStringExtent(data.fontlist, data.titleStr, 
		    &data.strWidth, &data.strHeight);
      if (data.strWidth > maxTitleWidth)
          maxTitleWidth = (NXCoord)data.strWidth;
    }

    return self;
}

- _setEntryWidth:(NXCoord)width
{
    [self _addArg:XmNwidth:(void *)width];
    return self;
}

- _setInterline:(NXCoord)spacing
{
    [self _addArg:XmNspacing:(void *)spacing];
    return self;
}


@end
