/* Additional NeXTSTEP  compatible Objective-C runtime functions
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * object-ivars.c,v 1.7 1994/06/11 03:57:42 pfkeb Exp
 */

#include <objc/objc-api.h>
#include <objc/objc.h>

void
object_find_instance_variable(id anObject, char *variableName,id **memlocation)
{
    id                 *outlet;
    struct objc_class  *parent;
    struct objc_ivar_list *ivars;
    struct objc_ivar   *ivar;
    int                 offset;
    int                 i;

    if (!anObject) {
	*memlocation = NULL;
	return;
    }
/* Find offset of variable */
/* To get class of an object, we have to use class_pointer */
/* For getting superclasses, we only use super_class  */
    parent = anObject->class_pointer;
    offset = -1;
    while (parent) {
	ivars = parent->ivars;
	if (ivars) {
	    ivar = ivars->ivar_list;
	    for (i = 0; i < (ivars->ivar_count); i++) {
		if (strcmp(variableName, ivar[i].ivar_name) == 0) {
		/* if this is the variable record, break */
		    offset = ivar[i].ivar_offset;
		    break;
		}
	    }
	}
	if (offset != -1)
	    break;
	parent = parent->super_class;
    }
/* if offset is still -1 then we were unable to find the variable */
    if (offset == -1) {
	*memlocation = NULL;
	fprintf(stderr,
		"object_set_instance_variable: variable %s not found\n",
		variableName);
	return;
    }
/* get memory location of variable */
    outlet = ((id *)((id)anObject + offset / 4));
    *memlocation = outlet;
    return;
}
void
object_set_instance_variable(id anObject, char *variableName,void *value)
{
    id                 *outlet;

    object_find_instance_variable(anObject, variableName, &outlet);

    if (outlet) {
    /* set variable to new value */
	*outlet = value;
    }
    return;
}

void
object_get_instance_variable(id anObject, char *variableName,void **value)
{
    id                 *outlet;

    object_find_instance_variable(anObject, variableName, &outlet);

    *value = NULL;
    if (outlet) {
    /* get value of variable */
	*value = *outlet;
    }
    return;
}
