/* Implementation Text class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz and Jeff Kamerer (SLAC)
 *	    Mike L. Kienenberger (Alaska)
 *
 * This file is part of an Objective-C class library for a window system
 *
 * Text.m,v 1.15 1994/08/17 05:11:14 fxmlk Exp
 */

#define READTEXT_BUFFERSIZE		100

#include "Text.h"
#include <stdlib.h>             /* for free() */
#ifdef	sgi
#include <malloc.h>   /* although you might need to edit malloc.h */
#endif	/* sgi */

extern char *TextInstanceName( void );

@implementation Text


- initFrame:(const NXRect *)frameRect
{
    return [self initFrame:frameRect text:"" alignment:NX_LEFTALIGNED];
}

- initFrame:(const NXRect *)frameRect text:(const char *)theText
					alignment:(int)mode
{
    [super initFrame:frameRect];

    if (_textString) {
		free(_textString);
	}
    if (theText) {
		_textString = (char *)malloc(strlen(theText) + 1);
		strcpy(_textString, theText);
    } else {
		_textString = (char *)malloc(1);
		*_textString = '\0';
    }
    
    [self _init_Text];
    instancename = TextInstanceName();
    
    return self;
}

- setMonoFont:(BOOL)flag
{
	mono = flag;
	return self;
}

- setEditable:(BOOL)flag
{
	editable = flag;
	return self;
}

- setSelectable:(BOOL)flag
{
	selectable = flag;
	return self;
}

- setFlipped:(BOOL)flag
{
	flipped = flag;
	return self;
}

- read:(TypedStream *)ts;
{
	[super read:ts];
	
        objc_read_type( ts, "c", &mono );
        objc_read_type( ts, "c", &editable );
        objc_read_type( ts, "c", &selectable );
        objc_read_type( ts, "c", &flipped );
	objc_read_string( ts, &_textString);
	
	return self;
}

- awake
{
    [super awake];
    
    [self _init_Text];
    instancename = TextInstanceName();
    
    return self;
}

- write:(TypedStream *)ts
{
    [super write:ts];
    return self;
}

- setText:(const char *)aString
{
    if (aString == _textString)  return self;
    
    if (_textString) {
		free(_textString);
	}
    if (aString) {
		_textString = (char *)malloc(strlen(aString) + 1);
		strcpy(_textString, aString);
    } else {
		_textString = (char *)malloc(1);
		*_textString = '\0';
	}
	[self _setText];
	return self;
}

- (int)textLength
{
    return [self _textLength];
}

- setSel:(int)start :(int)end
{
	return [self _setSel:start :end];
}

- (int)getSubstring:(char *)buf start:(int)startPos length:(int)numChars
{
	return [self _getSubstring:buf start:startPos length:numChars];
}

- (int)charLength
{
    return [self textLength];
}

- replaceSel:(const char *)aString
{
	return [self _replaceSel:aString];
}

- readText:(NXStream *)stream
{
	char buffer[READTEXT_BUFFERSIZE];
	int location = 0;
	int howMany;

	if (!stream) {
		return self;
	}
	[self _preReadText];
	[self setText:""];
	do {
		howMany = NXRead(stream, buffer, READTEXT_BUFFERSIZE);
		[self setSel:location :location];
		if (howMany < 100) {
			buffer[howMany] = '\0';
		}
		[self replaceSel:buffer];
		location += READTEXT_BUFFERSIZE;
	} while (howMany == 100);
	[self _postReadText];
	return self;
}

@end
