// GNU OpenStep implementation file for Responder

// Copyright (C) 1993 Keith Mason. All Rights Reserved.
// Copyright (C) 1993 The Board of Trustees of  
// The Leland Stanford Junior University.  All Rights Reserved.

// Authors: Scott Francis, Paul Kunz, and Libing Wang (SLAC)
//          Keith Mason
//          Mike Kienenberger (Alaska)

#include "Responder.h"

#include "publicWraps.h"

extern char *ResponderInstanceName(void);

@implementation Responder:Object

- init
{
    [super init];
    instancename = ResponderInstanceName();
    return self;
}

// Freeing an instance
- free
{
  /* Insert code to remove self from the hash table used to locate help */
  return [super free];
}

// Setting the next responder
- setNextResponder:aResponder
{
  /* Should I check to see if aResponder is really a responder? */
  nextResponder = aResponder;
  return self;
}

- nextResponder
{
  return nextResponder;
}

// Determining the first responder
- (BOOL)acceptsFirstResponder
{
  return NO;
}

- becomeFirstResponder
{
  return self;
}

- resignFirstResponder
{
  return self;
}

// Aiding event processing
- (BOOL)performKeyEquivalent:(NXEvent *)theEvent
{
  return NO;
}

- (BOOL)tryToPerform:(SEL)anAction
    with:anObject
{
  if ([self respondsTo:anAction] == YES)
    if ([self perform:anAction with:anObject] != nil)
       return YES;

  if (nextResponder == nil)
    return NO;

  // Couldn't respond, or responded with nil
  return [nextResponder tryToPerform:anAction with:anObject];
}

// Forwarding event messages
- mouseDown:(NXEvent *)theEvent
{
  if (nextResponder == nil)
    return [self noResponderFor:(char *)theEvent->type];

  return [nextResponder mouseDown:theEvent];
}

- rightMouseDown:(NXEvent *)theEvent
{
  if (nextResponder == nil)
    return [self noResponderFor:(char *)theEvent->type];

  return [nextResponder rightMouseDown:theEvent];
}

- mouseDragged:(NXEvent *)theEvent
{
  if (nextResponder == nil)
    return [self noResponderFor:(char *)theEvent->type];

  return [nextResponder mouseDragged:theEvent];
}

- rightMouseDragged:(NXEvent *)theEvent
{
  if (nextResponder == nil)
    return [self noResponderFor:(char *)theEvent->type];

  return [nextResponder rightMouseDragged:theEvent];
}

- mouseUp:(NXEvent *)theEvent
{
  if (nextResponder == nil)
    return [self noResponderFor:(char *)theEvent->type];

  return [nextResponder mouseUp:theEvent];
}

- rightMouseUp:(NXEvent *)theEvent
{
  if (nextResponder == nil)
    return [self noResponderFor:(char *)theEvent->type];

  return [nextResponder rightMouseUp:theEvent];
}

- mouseMoved:(NXEvent *)theEvent
{
  if (nextResponder == nil)
    return [self noResponderFor:(char *)theEvent->type];

  return [nextResponder mouseMoved:theEvent];
}

- mouseEntered:(NXEvent *)theEvent
{
  if (nextResponder == nil)
    return [self noResponderFor:(char *)theEvent->type];

  return [nextResponder mouseEntered:theEvent];
}

- mouseExited:(NXEvent *)theEvent
{
  if (nextResponder == nil)
    return [self noResponderFor:(char *)theEvent->type];

  return [nextResponder mouseExited:theEvent];
}

- keyDown:(NXEvent *)theEvent
{
  if (nextResponder == nil)
    return [self noResponderFor:(char *)theEvent->type];

  return [nextResponder keyDown:theEvent];
}

- keyUp:(NXEvent *)theEvent
{
  if (nextResponder == nil)
    return [self noResponderFor:(char *)theEvent->type];

  return [nextResponder keyUp:theEvent];
}

- flagsChanged:(NXEvent *)theEvent
{
  if (nextResponder == nil)
    return [self noResponderFor:(char *)theEvent->type];

  return [nextResponder flagsChanged:theEvent];
}

/* I haven't figured why the argument to noResponderFor: is a char pointer */
- noResponderFor:(const char *)eventType
{
  if ((int)eventType == NX_KEYDOWN)
    NXBeep();

  return nil;
}

// Services menu support
- validRequestorForSendType:(NXAtom)typeSent
    andReturnType:(NXAtom)typeReturned
{
  if (nextResponder == nil)
    return nil;

  return [nextResponder validRequestorForSendType:typeSent
          andReturnType:typeReturned];
}

// Help menu support
- helpRequested:(NXEvent *)eventPtr
{
  if (nextResponder == nil) {
    NXBeep();
    return self;
  }

  return [nextResponder helpRequested:eventPtr];
}

// Archiving
- read:(NXTypedStream *)stream
{
  [super read:stream];
//  Note: put following back in afer translator is fixed
//  nextResponder = NXReadObject(stream);
  return self;
}

- awake
{
    [super awake];
    
    return self;
}

- write:(NXTypedStream *)stream
{
  [super write:stream];
  NXWriteObjectReference(stream, nextResponder);

  return self;
}

@end
 
