/* Interface for Form class
 *
 * Copyright (C)  1993, 1994  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Fred Harris, Paul Kunz, 
 *          Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * Form.h,v 1.31 1994/07/16 23:29:29 pfkeb Exp
 */

 
#ifndef _Form_h_
#define _Form_h_


#include "Matrix.h"

@interface Form : Matrix
{
    NXCoord   maxTitleWidth;
} 

+ setCellClass:factoryId;

- initFrame:(const NXRect *)frameRect;
- calcSize;

// - sizeTo:(NXCoord)width :(NXCoord)height;
// - sizeToFit;

- (int)selectedIndex;
- setEntryWidth:(NXCoord)width;
- setInterline:(NXCoord)spacing;

// - setBordered:(BOOL)flag;
// - setBezeled:(BOOL)flag;
// - setTitleAlignment:(int)mode;
// - setTextAlignment:(int)mode;
// - setFont:fontObj;
// - setTitleFont:fontObj;
// - setTextFont:fontObj;

- drawCellAt:(int)index;
- (const char *)titleAt:(int)index;
- setTitle:(const char *)aString at:(int)index;
- addEntry:(const char *)title;
- addEntry:(const char *)title tag:(int)anInt 
    target:anObject action:(SEL)aSelector;
- insertEntry:(const char *)title at:(int)index;
- insertEntry:(const char *)title at:(int)index tag:(int)anInt 
       target:anObject action:(SEL)aSelector;
- removeEntryAt:(int)index;
- setTag:(int)anInt at:(int)index;
- setTarget:anObject at:(int)index;
- setAction:(SEL)aSelector at:(int)index;
- (int)findIndexWithTag:(int)aTag;
- (const char *)stringValueAt:(int)index;
- setStringValue:(const char *)aString at:(int)index;
- (int)intValueAt:(int)index;
- setIntValue:(int)anInt at:(int)index;
- (float)floatValueAt:(int)index;
- setFloatValue:(float)aFloat at:(int)index;
- (double)doubleValueAt:(int)index;
- setDoubleValue:(double)aDouble at:(int)index;
- selectCell:aCell;	/* not implemented in NeXTStep */
- selectTextAt:(int)index;

// + newFrame:(const NXRect *)frameRect;


/* Methods not in NeXTSTEP class */
- _managedBy:parent wid:(void*)widget;

@end

#endif
