
/* Implementation of CustomObject class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * This file is part of an Objective-C class library for a window system
 *
 * Original author: Imran Qureshi
 * Additional author: Paul Kunz
 * 
 * CustomObject.m,v 1.11 1994/06/11 03:55:37 pfkeb Exp
 */

#include "CustomObject.h"
#include <stdio.h>
#include <stdlib.h>

/* From Application.m */
extern id  nibOwner;


/* Add an archiving category to object so every object can respond to
   -nibInstantiate
*/
@implementation Object(XmArchiving)
-nibInstantiate
{
	return self;
}
@end
 
@implementation CustomObject
- init
{	
	Class	*theClass;

	if (realObject) {
		fprintf(stderr, "CustomObject: object already exists\n");
		return self;
	}
	if (strcmp(realClassName,"FileOwner")==0) {
		realObject = nibOwner;
		return self;
	}
	
		
	theClass = objc_get_class(realClassName);
	realObject = [[theClass alloc] init];
	return self;
} 

- write:(TypedStream *)stream
{
	[super write:stream];
	objc_write_type(stream,"*", realClassName);
	return self;
}
- read:(TypedStream *)stream
{
	[super read:stream];
	objc_read_type(stream,"*",&realClassName);
	return self;

}
- awake
{
	if (amAwake) {
		printf("CustomObject alert: -awake called more than once");
		return self;
	}
	amAwake = YES;
	[self init];

	return self;
}

-nibInstantiate
{
	 return realObject;
}

@end
