/*  Archiving Category for ScrollView
    Copyright (C)  1993  The Board of Trustees of
    The Leland Stanford Junior University.  All Rights Reserved.

Authors: Paul Kunz and Imran Qureshi

 * This file is part of the nib translator for 
 * an Objective-C class library for X/Motif

XmScrollView.m,v 1.5 1994/06/11 03:53:58 pfkeb Exp

*/

#include "/NextDeveloper/Headers/objc/typedstream.h"
#include "objc/typedstream.h"
#define NXTypedStreams TypedStreams
#include <appkit/ScrollView.h>

@implementation ScrollView (XmArchiving)

- write:(TypedStream *)stream
{
    int		type;
    BOOL	vflag, hflag;
    
    [super write:stream];
#ifdef DEBUG
    printf("->ScrollView");
#endif
    type = _sFlags.borderType;
    vflag = _sFlags.vScrollerRequired;
    hflag = _sFlags.hScrollerRequired;
    objc_write_types(stream, "icc", &type, &vflag, &hflag);
    return self;
}

@end
