/*  Archiving Category for Cell
    Copyright (C)  1993  The Board of Trustees of
    The Leland Stanford Junior University.  All Rights Reserved.

Authors: Imran Qureshi

 * This file is part of the nib translator for 
 * an Objective-C class library for X/Motif

XmCell.m,v 1.7 1994/06/11 03:53:15 pfkeb Exp

*/

#include "/NextDeveloper/Headers/objc/typedstream.h"
#include "/NextDeveloper/Headers/objc/Object.h"

#define NXTypedStream TypedStream
#include <appkit/Cell.h>

#include <stdlib.h>

@interface Cell (XmArchiving)
- write:(TypedStream *)stream;
@end

@implementation Cell (XmArchiving)
- write:(TypedStream *)stream
{
    [super write:stream];

#ifdef DEBUG
    printf("->Cell");
#endif

 /* Lat's protect the porgram from crashing by initializing contents */
    if (!contents) {
	contents = malloc(2);
	strcpy(contents, "");
    }
#ifdef DEBUG
    printf("(title=%s)", contents);
#endif
    objc_write_type(stream, "*", contents);

    return self;
}
@end
