
#include <coll/StringTable.h>
#include <stdio.h>



/*  pasted from parse.m */
/* Main, initialization, error routines */

#include "subula.h"
#include "y.tab.h"
#include <objc/objc.h>

/* Global variables */
id	stringTable;




@implementation StringTable
- init
{
	char *akeyDesc, *avalueDesc;
	akeyDesc = (char*)malloc(10);
	avalueDesc =(char*) malloc(10);
	strcpy(akeyDesc,"*");
	strcpy(avalueDesc,"*");
        [super initKeyDesc:akeyDesc valueDesc:avalueDesc];
        return self;
}

- free
{
   return [super free];
}

- (const char *)valueForStringKey: (const char *)aString
{
   return [super valueForKey :aString];
}

- readFromFile: (const char *)fileName 
{
	FILE  *stdinbk;
	printf("readFromFile:%s\n",fileName);
	dup2(stdinbk,stdin);
  	freopen(fileName, "r", stdin);
 	parse(self);
	dup2(stdin,stdinbk);
	return self;
}

- writeToFile:(const char *)fileName
{
	FILE *fp;
        char *key, *value;

	GNUHashState   	state = [super initState];
        fp = fopen(fileName,"w");
	while([super nextState: &state key: &key value: &value])
        	fprintf(fp,"\"%s\"=\"%s\";\n",key, value);
	fflush(fp);
        fclose(fp);
	return self;
}


- readFromStream: (FILE *)stream
{
    return self;
}

- writeToStream:(FILE *)stream
{
	return self;
}
@end

pline()
{
  fprintf(stderr, "Line %d: ", yylineno);
}

yyerror(s) char *s;
{
  /* The line number and token are what LEX has read so far.
     An error detected by YACC usually comes before this place. */

  pline();
  fprintf(stderr, "%s\n", s);
  fprintf(stderr, "Last token was %s\n", yytext);
}

insertAKey(char *key, char*value)
{
	char *keyCpy, *valueCpy;

	if (strcmp(key,value)==0) {
		value = (char*)malloc(strlen(key)+1);
		strcpy(value,key);
	}
		
       *(key+strlen(key)-1) = '\0';
                key ++;
       *(value+strlen(value)-1) = '\0';
                value ++;
        keyCpy = (char*)malloc(strlen(key)+2);
	valueCpy = (char*)malloc(strlen(value)+2);
        strcpy(keyCpy, key);
        strcpy(valueCpy, value);
	printf("Inserting key = %s value = %s\n",key,value);				
	[stringTable insertKey:keyCpy value:valueCpy];
	/*printf("And the value is %s\n",[stringTable valueForKey:keyCpy]);*/
	return;
}
/* Initialize some base types.  Set globals */


parse(id theStringTable)
{
	stringTable = theStringTable;
  lexinit();
  return(yyparse());
}


