/* Motif WidgetSet category for implementation of Box class
 *
 * Copyright (C)  1994  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for X/Motif
 *
 * xmBox.m,v 1.1 1994/06/13 23:03:58 pfkeb Exp
 */

#include "Box.h"

#include <Xm/BulletinB.h>
#include "TextFieldCell.h"

char * BoxInstanceName(void)
{
    return "Box";
}

@implementation Box(WidgetSet)

/* 
 * Overrides View's _init method, but also invokes it.  This is
 * called from View's initFrame method.  It does widget initialization,
 * giving initial values for a few extra resources that a box class
 * should worry about.
 * Box Class should not resize when a window does (at least by default).
 * also, no margin should be enforced between it and its content view.
 * The default shadow type is etched, as with the NeXT box class.  This
 * can be changed to no shadow type as well, of course.  To get rid of
 * the border, set XmNshadowThickness to ZERO.
 */

- _init
{
    // [super _init];

    classname = xmBulletinBoardWidgetClass;
    borderView = [[View alloc] init];
    [self _setBorder:&borderRect];
    [self setFrame:&frame];
    [self _addArg:XmNallowOverlap:(void *)True];
    [self _setArg:XmNresizePolicy  to:(void *)XmRESIZE_NONE];
    [borderView _setResize:(void *)XmRESIZE_NONE];
    [borderView _setOffsets:&offsets];
    [self _setArg:XmNmarginHeight  to:(void *)0];
    [self _setArg:XmNmarginWidth   to:(void *)0];
    [self setBorderType:border];
    return self;
}

- _setBorderType:(int)borderType
{
 [self _setArg:XmNshadowThickness to:(void *)0];
  switch (border) {
  case (NX_NOBORDER):
    [borderView _setBorderShadow:(void *)XmSHADOW_IN andThickness:(void*)0];
    break;
  case (NX_BEZEL):
    [borderView _setBorderShadow:(void *)XmSHADOW_OUT 
    	            andThickness:(void *)BEZEL_THICKNESS];
    break;
  case (NX_GROOVE):
    [borderView _setBorderShadow:(void *)XmSHADOW_ETCHED_IN
    	      	    andThickness:(void *)BEZEL_THICKNESS];
    break;
  case (NX_LINE):
  case (NX_RIDGE):
  default:
    [borderView _setBorderShadow:(void *)XmSHADOW_ETCHED_OUT
    	            andThickness:(void *)BEZEL_THICKNESS];
    break;
  }
  return self;
}

- _managedBy:parent wid:(void *)widget
{
    int dh;

    if (!classname)
       fprintf(stderr, "%s: classname unkonwn\n", [self name]);
    if (widgetid) {
        XtManageChild(widgetid);
    } else {
	widgetid = XtCreateManagedWidget(instancename, classname,
				         widget, [self _arglist], 
					 [self _numargs]);
	[self _addCallback];
    }
    [self _setnumargs:0];
    [borderView _managedBy:self wid:widgetid];
    if (cell) {
    	[cell _managedBy:self wid:widgetid];
    }
    [self _manageChildren];
    dh = [self heightAdjust];
    [contentView sizeTo:(borderRect.size.width - offsets.width*2) 
    		       :(borderRect.size.height) - offsets.height*2 
		        - dh];

    return self;
}

@end

