/* Interface for Scoller class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Paul Kunz, Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * Scroller.h,v 1.21 1994/06/15 18:58:36 pfkeb Exp
 */

 
#ifndef _Scroller_h_
#define _Scroller_h_

#include "Control.h"
#include "graphics.h"

/* Part codes for various parts of the scroller */

#define	NX_NOPART	0
#define NX_DECPAGE	1
#define	NX_KNOB		2
#define	NX_INCPAGE	3
#define NX_DECLINE	4
#define NX_INCLINE	5
#define	NX_KNOBSLOT	6
#define	NX_JUMP		6

#define	NX_SCROLLERWIDTH	18

@interface Scroller:Control
{
    int		curValue;	/* NeXSTEP float rep. time OS_SCALE_FACTOR */
    int		perCent;	/* ditto */
    NXCoord	_knobSize;	
    int		hitPart;
    id		target;
    SEL		action;
    BOOL	isHoriz;
}

- initFrame:(const NXRect *)frameRect;
- target;
- setTarget:anObject;
- (SEL)action;
- setAction:(SEL)aSelector;
- trackKnob:(NXEvent *)theEvent;
- trackScrollButtons:(NXEvent *)theEvent;
- (int) hitPart;
- (float)floatValue;
- setFloatValue:(float)aFloat :(float)percent;
- setFloatValue:(float)aFloat;

- _setHitPart:(int) part;
- _setVertical:(BOOL)flag;

@end

#endif /* _Scroller_h_ */ 









