/* Implementation of PrintInfo class
 *
 * Copyright (C)  1994  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Paul Kunz
 *
 * This file is part of an Objective-C class library for a window system
 *
 * PrintInfo.m,v 1.2 1994/06/11 03:56:45 pfkeb Exp
 */

#include "PrintInfo.h"

@implementation PrintInfo:Object

// + (NXPrinter *)getDefaultPrinter;
// + setDefaultPrinter:(NXPrinter *)pr;

- init
{
    [super init];
  /* set default paper size to US Letter and margins to 1/4 inch */
    paperRect.size.width  = 612;
    paperRect.size.height = 792;
    leftPageMargin   = 18;
    rightPageMargin  = 18;
    topPageMargin    = 18;
    bottomPageMargin = 18;
    return self;
}

// - free;
// - setPaperType:(const char *)type andAdjust:(BOOL)flag;
// - (const char *)paperType;
// - setPaperRect:(const NXRect *)aRect andAdjust:(BOOL)flag;

- (const NXRect *)paperRect
{
    return &paperRect;
}

- setMarginLeft:(NXCoord)leftMargin right:(NXCoord)rightMargin 
            top:(NXCoord)topMargin bottom:(NXCoord)bottomMargin
{
    leftPageMargin   = leftMargin;
    rightPageMargin  = rightMargin;
    topPageMargin    = topMargin;
    bottomPageMargin = bottomMargin;
    return self;
}

- getMarginLeft:(NXCoord *)leftMargin right:(NXCoord *)rightMargin 
            top:(NXCoord *)topMargin bottom:(NXCoord *)bottomMargin
{
    *leftMargin   = leftPageMargin;
    *rightMargin  = rightPageMargin;
    *topMargin    = topPageMargin;
    *bottomMargin = bottomPageMargin;
    return self;
}

// - setScalingFactor:(float)aFloat;
// - (float)scalingFactor;
// - setOrientation:(char)mode andAdjust:(BOOL)flag;
// - (char)orientation;
// - setHorizCentered:(BOOL)flag;
// - (BOOL)isHorizCentered;
// - setVertCentered:(BOOL)flag;
// - (BOOL)isVertCentered;
// - setHorizPagination:(int)mode;
// - (int)horizPagination;
// - setVertPagination:(int)mode;
// - (int)vertPagination;
// - setOutputFile:(const char *)aString;
// - (const char *)outputFile;
// - setPageOrder:(char)mode;
// - (char)pageOrder;
// - setAllPages:(BOOL)flag;
// - (BOOL)isAllPages;
// - setFirstPage:(int)anInt;
// - (int)firstPage;
// - setLastPage:(int)anInt;
// - (int)lastPage;
// - (int)currentPage;
// - setCopies:(int)anInt;
// - (int)copies;
// - setContext:(DPSContext)aContext;
// - (DPSContext)context;
// - setPagesPerSheet:(short)aShort;
// - (short)pagesPerSheet;
// - setReversePageOrder:(BOOL)flag;
// - (BOOL)reversePageOrder;
// - setPrinter:(NXPrinter *)pr;
// - (NXPrinter *)printer;
// - setPaperFeed:(const char *)str;
// - (const char *)paperFeed;
// - initializeJobDefaults;
// - setJobFeature:(const char *)feature toValue:(const char *)string;
// - (const char *)valueForJobFeature:(const char *)feature;
// - removeJobFeature:(const char *)feature;
// - (const char **)jobFeatures;
// - write:(NXTypedStream *)stream;
// - read:(NXTypedStream *)stream;

@end
