/* Interface for PrintInfo class
 *
 * Copyright (C)  1994  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Paul Kunz
 *
 * This file is part of an Objective-C class library for a window system
 *
 * PrintInfo.h,v 1.5 1994/06/11 03:56:43 pfkeb Exp
 */

 
 
#ifndef _print_info_h_
#define	_print_info_h_

#include <objc/Object.h>
#include "graphics.h"

@interface PrintInfo:Object
{
    char               *paperType;
    NXRect              paperRect;
    NXCoord             leftPageMargin;
    NXCoord             rightPageMargin;
    NXCoord             topPageMargin;
    NXCoord             bottomPageMargin;
    float               scalingFactor;
    char                pageOrder;

}

// + (NXPrinter *)getDefaultPrinter;
// + setDefaultPrinter:(NXPrinter *)pr;

- init;
// - free;
// - setPaperType:(const char *)type andAdjust:(BOOL)flag;
// - (const char *)paperType;
// - setPaperRect:(const NXRect *)aRect andAdjust:(BOOL)flag;
- (const NXRect *)paperRect;
- setMarginLeft:(NXCoord)leftMargin right:(NXCoord)rightMargin
            top:(NXCoord)topMargin bottom:(NXCoord)bottomMargin;
- getMarginLeft:(NXCoord *)leftMargin right:(NXCoord *)rightMargin
            top:(NXCoord *)topMargin bottom:(NXCoord *)bottomMargin;
// - setScalingFactor:(float)aFloat;
// - (float)scalingFactor;
// - setOrientation:(char)mode andAdjust:(BOOL)flag;
// - (char)orientation;
// - setHorizCentered:(BOOL)flag;
// - (BOOL)isHorizCentered;
// - setVertCentered:(BOOL)flag;
// - (BOOL)isVertCentered;
// - setHorizPagination:(int)mode;
// - (int)horizPagination;
// - setVertPagination:(int)mode;
// - (int)vertPagination;
// - setOutputFile:(const char *)aString;
// - (const char *)outputFile;
// - setPageOrder:(char)mode;
// - (char)pageOrder;
// - setAllPages:(BOOL)flag;
// - (BOOL)isAllPages;
// - setFirstPage:(int)anInt;
// - (int)firstPage;
// - setLastPage:(int)anInt;
// - (int)lastPage;
// - (int)currentPage;
// - setCopies:(int)anInt;
// - (int)copies;
// - setContext:(DPSContext)aContext;
// - (DPSContext)context;
// - setPagesPerSheet:(short)aShort;
// - (short)pagesPerSheet;
// - setReversePageOrder:(BOOL)flag;
// - (BOOL)reversePageOrder;
// - setPrinter:(NXPrinter *)pr;
// - (NXPrinter *)printer;
// - setPaperFeed:(const char *)str;
// - (const char *)paperFeed;
// - initializeJobDefaults;
// - setJobFeature:(const char *)feature toValue:(const char *)string;
// - (const char *)valueForJobFeature:(const char *)feature;
// - removeJobFeature:(const char *)feature;
// - (const char **)jobFeatures;
// - write:(NXTypedStream *)stream;
// - read:(NXTypedStream *)stream;
@end

#endif