/* Interface for Application class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Fred Harris, Paul Kunz, Tom Pavel, 
 *	    Imran Qureshi, and Libing Wang
 *	    Mike L. Kienenberger (Alaska)
 *
 * This file is part of an Objective-C class library for a window system
 *
 * Application.h,v 1.45 1994/06/15 18:57:25 pfkeb Exp
 */

 
#ifndef _Application_h_
#define _Application_h_

#include "Responder.h"
#include "graphics.h"
#include <objc2/zone.h>
#include <sys/types.h>
#include <dpsclient/dpsfriends.h>

/* compatibility macros */
#define NXGetNamedObject objc_get_named_object
#define NXGetObjectName objc_get_object_name
#define NXNameObject objc_name_object
#define NXUnameObject objc_unname_object
#define NXFreeNames objc_free_names

id          objc_get_named_object(const char *name, id owner);
const char *objc_get_object_name(id theObject);
int         objc_name_object(const char *name, id theObject, id owner);
int         objc_unname_object(const char *name, id owner);
int         objc_free_names();

extern id		NXApp;
extern pid_t 		NXProcessID;
extern char 		**argv;
extern int 		argc;
extern const char 	*XHomeDirectory(void);

#define X_RUNSTOPPED		(-1000)

@class List, Menu, PrintInfo, Window;
@interface Application:Responder
{
    char 	*appName;
    List 	*windowList;
    Window	*mainWindow;  
    id    	delegate;
    BOOL	autoupdate;

    List	*mainWindowList;	/* last one is current mainWindow */
    void 	*app_con;
    void 	*_X_display;
    void 	*_toplevel;
    Menu	*_mainMenu;
    id    	_appIcon;
    PrintInfo	*_printInfo;
    int	  	_modalReturnCode;	/* callback of modal panel
    					 * set this via -stopModal: */
    DPSContext	_context;
}

// + (id <NXWorkspaceRequestProtocol>)workspace;
// + initialize;
// + new;
// + allocFromZone:(NXZone *)zone;
// + alloc;

- free;
- setDelegate:anObject;
- delegate;

- (DPSContext)context;
// - hide:sender;
// - unhide:sender;
// - unhideWithoutActivation:sender;
// - findWindow:(int)windowNum;
// - focusView;

- mainWindow;

// - keyWindow;
// - (port_t)replyPort;

- (const char *)appName;

// - (const char *const *)systemLanguages;
// - (const char *)appListenerPortName;
// - appListener;
// - setAppListener:aListener;
// - appSpeaker;
// - setAppSpeaker:aSpeaker;
// - (int)unhide;
// - (int)openFile:(const char *)fullPath ok:(int *)flag;
// - (int)openTempFile:(const char *)fullPath ok:(int *)flag;
// - (int)powerOffIn:(int)ms andSave:(int)aFlag;
// - (int)unmounting:(const char *)fullPath ok:(int *)flag;
// - (int)unmounted:(const char *)fullPath;
// - (int)mounted:(const char *)fullPath;
// - (int)fileOperationCompleted:(int)operation;
// - (int)applicationWillLaunch:(const char *)applicationName;
// - (int)applicationDidLaunch:(const char *)applicationName;
// - (int)applicationDidTerminate:(const char *)applicationName;
// - (BOOL)isActive;
// - (const char *)hostName;
// - (BOOL)isHidden;
// - (BOOL)isRunning;
// - (int)activeApp;
// - deactivateSelf;

- (int)activateSelf:(BOOL)flag;

// - (int)activate:(int)contextNumber;

- run;
- (int)runModalFor:theWindow;

// - stop:sender;

- stopModal;
- stopModal:(int)returnCode;

// - (void)abortModal;
// - (NXModalSession *)beginModalSession:(NXModalSession *)session 
//                                   for:theWindow;
// - (int)runModalSession:(NXModalSession *)session;
// - endModalSession:(NXModalSession *)session;

- setAutoupdate:(BOOL)flag;
- terminate:sender;

// - (NXEvent *)getNextEvent:(int)mask waitFor:(double)timeout 
//                 threshold:(int)level;
// - (NXEvent *)peekNextEvent:(int)mask into:(NXEvent *)eventPtr 
//                    waitFor:(float)timeout threshold:(int)level;
// - (NXEvent *)getNextEvent:(int)mask;
// - (NXEvent *)peekAndGetNextEvent:(int)mask;
// - (NXEvent *)peekNextEvent:(int)mask into:(NXEvent *)eventPtr;
// - (NXEvent *)currentEvent;
// - powerOff:(NXEvent *)theEvent;
// - applicationDefined:(NXEvent *)theEvent;
// - rightMouseDown:(NXEvent *)theEvent;
// - sendEvent:(NXEvent *)theEvent;
// - preventWindowOrdering;
// - becomeActiveApp;
// - resignActiveApp;

- makeWindowsPerform:(SEL)aSelector inOrder:(BOOL)flag;
- appIcon;
- windowList;

// - getWindowNumbers:(int **)list count:(int *)winCount;

- updateWindows;

// - (BOOL)sendAction:(SEL)theAction to:theTarget from:sender;

- calcTargetForAction:(SEL)theAction;

// - (BOOL)tryToPerform:(SEL)anAction with:anObject;

- printInfo;

// - runPageLayout:sender;
// - orderFrontColorPanel:sender;

- setPrintInfo:info;
- setMainMenu:aMenu;
- mainMenu;
- delayedFree:anObject;

// - getScreens:(const NXScreen **)list count:(int *)count;
// - (const NXScreen *)mainScreen;
// - (const NXScreen *)colorScreen;

- getScreenSize:(NXSize *)theSize;
- loadNibFile:(const char *)fileName owner:anOwner withNames:(BOOL)aFlag
     fromZone:(NXZone *)aZone;
- loadNibFile:(const char *)fileName owner:anOwner withNames:(BOOL)aFlag;
- loadNibFile:(const char *)fileName owner:anOwner;
- loadNibSection:(const char *)sectionName owner:anOwner
       withNames:(BOOL)aFlag;
- loadNibSection:(const char *)sectionName owner:anOwner;

// - loadNibSection:(const char *)sectionName owner:anOwner 
//        withNames:(BOOL)aFlag fromZone:(NXZone *)zone;
// - loadNibSection:(const char *)sectionName owner:anOwner 
//        withNames:(BOOL)flag fromHeader:(const struct mach_header *)mhp;
// - loadNibSection:(const char *)sectionName owner:anOwner 
//        withNames:(BOOL)flag fromHeader:(const struct mach_header *)mhp 
//         fromZone:(NXZone *)zone;
// - validRequestorForSendType:(NXAtom)sendType 
//               andReturnType:(NXAtom)returnType;
// - slaveJournaler;
// - masterJournaler;
// - (BOOL)isJournalable;
// - setJournalable:(BOOL)newStatus;
// - showHelpPanel:sender;


- init;
- initargc:(int)ac argv:(char**)av;
- appWillInit:sender;
- appDidInit:sender;
- setAppName:(const char*)aString;
- (void*) _X_display;
- setAppIcon:anIcon;
- (void *)_toplevel;


@end

// @interface Application(WindowsMenu)
// - windowsMenu;
// - setWindowsMenu:(id)menu;
// - arrangeInFront:sender;
// - removeWindowsItem:(id)win;
// - addWindowsItem:(id)win title:(const char *)aString 
//         filename:(BOOL)isFilename;
// - changeWindowsItem:(id)win title:(const char *)aString
//            filename:(BOOL)isFilename;
// - updateWindowsItem:(id)win;
// - miniaturizeAll:sender;
// @end


/* Application delegate methods. */

@interface Object(ApplicationDelegate)
- appWillInit:sender;
- appDidInit:sender;

// - appDidHide:sender;
//- appDidUnhide:sender;
//- appDidBecomeActive:sender;
// - appDidResignActive:sender;

- appDidUpdate:sender;
- appWillUpdate:sender;

// - appWillTerminate:sender;
// - app:sender willShowHelpPanel:panel;
// - (BOOL)appAcceptsAnotherFile:sender;
// - (int)app:sender openFile:(const char *)filename type:(const char *)aType;
// - (int)app:sender openTempFile:(const char *)filename 
//       type:(const char *)aType;
// - (NXDataLinkManager *)app:sender 
//          openFileWithoutUI:(const char *)filename type:(const char *)aType;
// - app:sender powerOffIn:(int)ms andSave:(int)aFlag;
// - (int)app:sender unmounting:(const char *)fullPath;
// - app:sender unmounted:(const char *)fullPath;
// - app:sender mounted:(const char *)fullPath;
// - app:sender fileOperationCompleted:(int)operation;
// - app:sender applicationWillLaunch:(const char *)appName;
// - app:sender applicationDidLaunch:(const char *)appName;
// - app:sender applicationDidTerminate:(const char *)appName;
// - applicationDefined:(NXEvent *)theEvent;
// - powerOff:(NXEvent *)theEvent;
@end

// @interface Application(ServicesMenu)
// - servicesMenu;
// - setServicesMenu:aMenu;
// - registerServicesMenuSendTypes:(const char *const *)sendTypes 
//                  andReturnTypes:(const char *const *)returnTypes;
// @end

// @interface Application(NXAlphaImport) 
// - setImportAlpha:(BOOL)flag;
// - (BOOL)doesImportAlpha;
// @end

// @interface Object(NXServicesRequests)
// - (BOOL)writeSelectionToPasteboard:pboard types:(NXAtom *)types;
// - readSelectionFromPasteboard:pboard;
// @end

// @interface Object(DelayedPerform)
//- perform:(SEL)aSelector with:anArg afterDelay:(int)ms 
//               cancelPrevious:(BOOL)flag;
//@end

// @interface Object(NXNibNotification)
// - awakeFromNib;
// @end

// @interface NXConnection(NXConnectionHelper) 
// - runFromAppKit;
// - runFromAppKitWithPriority:(int)priority;
// @end


// #ifdef KANJI
// @interface Application(InputManager)
// - inputManager;
// - setInputManager: newIM;
// @end

@interface Application(Private)
- _willBecomeMain:(Window *)aWindow;
@end


#endif /* _Application_h_ */

