/* hashtable.c
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Paul Kunz
 *
 * This file is part of an Objective-C class library for a window system
 * that is like OpenStep
 *
 * hashtable.c,v 1.2 1994/01/20 00:33:50 mfg Exp
 */

/* Implementation notes:
 *
 *  This doesn't have much to do with hash tables but it is where
 *  NeXT put the string copy functions and some other things.
 */
 
#include "objc2/hashtable.h"

#include <string.h>
#include <stdlib.h>


char *NXCopyStringBuffer(const char *buffer)
{
    char               *temp;

    if (!buffer)
	return NULL;
    temp = (char *)malloc((strlen(buffer) + 1) * sizeof(char));
    temp = strcpy(temp, buffer);
    return (temp);
}
