/*  Archiving Category for List
    Copyright (C)  1993  The Board of Trustees of
    The Leland Stanford Junior University.  All Rights Reserved.

Authors: Paul Kunz and Imran Qureshi

 * This file is part of the nib translator for 
 * an Objective-C class library for X/Motif

XmList.m,v 1.4 1994/06/11 03:53:36 pfkeb Exp

*/

#include "/NextDeveloper/Headers/objc/typedstream.h"
#include "/NextDeveloper/Headers/objc/List.h"

@interface List (XmArchiving)
- write:(TypedStream *)stream;
@end

#include <stdio.h>
//#include <stdlib.h>

@implementation List (XmArchiving)
- write:(TypedStream *)stream
{
    [super write:stream];
    
#ifdef DEBUG
    printf("->(List of %d objects)", numElements);
#endif

    objc_write_types(stream, "II", &numElements, &maxElements);
    objc_write_array(stream, "@", numElements, dataPtr);
    return self;
}
@end
