/*  Archiving Category for Control
    Copyright (C)  1993  The Board of Trustees of
    The Leland Stanford Junior University.  All Rights Reserved.

Authors: Scott Francis, Paul Kunz and Imran Qureshi

 * This file is part of the nib translator for 
 * an Objective-C class library for X/Motif

XmControl.m,v 1.11 1994/06/11 03:53:24 pfkeb Exp

*/

#include "/NextDeveloper/Headers/objc/typedstream.h"
#include "/NextDeveloper/Headers/objc/Object.h"

#include "XmControl.h"

#ifdef DEBUG
#include <stdio.h>
#endif

@implementation Control (XmArchiving)
-convertCoordToMotif:sender
{
	[super convertCoordToMotif:sender];

	return self;
}
- write:(TypedStream *)stream
{
    [super write:stream];

#ifdef DEBUG
    if ( [subviews count] ) {
	printf("\n->Control");
    } else {
	printf("->Control");
    }
#endif

    objc_write_object(stream, cell);
    return self;
}
@end
