/*  Archiving Category for ButtonCell
    Copyright (C)  1993  The Board of Trustees of
    The Leland Stanford Junior University.  All Rights Reserved.

Authors: Scott Francis, Paul Kunz and Imran Qureshi

This file is part of the nib translator for 
an Objective-C class library for X/Motif

XmButtonCell.m,v 1.15 1994/06/11 03:53:14 pfkeb Exp

*/

#include "/NextDeveloper/Headers/objc/typedstream.h"
#include "/NextDeveloper/Headers/objc/Object.h"

#define NXTypedStream TypedStream
#include <appkit/ButtonCell.h>
#include <appkit/Font.h>

@interface ButtonCell (XmArchiving)
- write:(TypedStream *)stream;
@end

#include <stdio.h>
#include <stdlib.h>

@class PopUpList;

@implementation ButtonCell (XmArchiving)
- write:(TypedStream *)stream
{
    id		ticon;
    int		flag = 0, localState;

    [super write:stream];

#ifdef DEBUG
    printf("->ButtonCell");
#endif

    if ( target ) {
    	flag = (strcmp( [target name], "PopUpList") == 0);
    }
    objc_write_type(stream, "i", &flag);
    if (flag) {
	objc_write_object(stream, target);
    }

    ticon = icon.bmap.normal;
    if ( ticon 
        && ![ticon isKindOf:[Font class]] 
	&& [ticon name]         ) {
        flag = 1;
    }
    objc_write_type(stream, "i", &flag);
    if ( flag ) {
        objc_write_type(stream, "*", [icon.bmap.normal name] );
    }
    flag = icon.bmap.alternate ? 1 :0;
    objc_write_type(stream, "i", &flag);
    if ( flag ) {
        objc_write_type(stream, "*", [icon.bmap.alternate name] );
    }
    flag = 1;
    localState = [self state];
    objc_write_type(stream, "i", &flag);
    objc_write_type(stream, "i", &localState);

    return self;
}
@end
