/* Collection definitions for the use of subclass implementations only
   Copyright (C) 1993 Free Software Foundation, Inc.

   Written by:  R. Andrew McCallum <mccallum@cs.rochester.edu>
   Dept. of Computer Science, U. of Rochester, Rochester, NY  14627

   This file is part of the GNU Objective-C Collection library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/ 

#ifndef __CollectionPrivate_h_INCLUDE_GNU
#define __CollectionPrivate_h_INCLUDE_GNU

#include <coll/objc-gnu2next.h>
#include <coll/Collection.h>
#ifndef NeXT
#include <objc/objc-api.h>
#else
#include <objc/objc-class.h>
#endif
#include <coll/collstd.h>
#include <coll/eltfuncs.h>

@interface Collection (ArchivingHelpers)
/* These methods should never be called except in order inside 
   -write: and -read: */
- _writeInit: (TypedStream*)aStream;
- _readInit: (TypedStream*)aStream;
- _writeContents: (TypedStream*)aStream;
- _readContents: (TypedStream*)aStream;
@end
  
/* To be used inside methods for getting the element comparison function.
   This macro could be redefined when the comparison function is an
   instance variable or is fixed.
   I'm wondering if I should put _comparison_function back as an instance 
   variable in Collection. */
#define COMPARISON_FUNCTION [self comparisonFunction]

/* Use this for comparing elements in your implementation. */
#define COMPARE_ELEMENTS(ELT1, ELT2) \
  ((*COMPARISON_FUNCTION)(ELT1, ELT2))

#define ELEMENTS_EQUAL(ELT1, ELT2) \
  (COMPARE_ELEMENTS(ELT1, ELT2) == 0)

#define ENCODING_IS_OBJECT(ENCODING) \
  ((*(ENCODING) == _C_ID) || (*(ENCODING) == _C_CLASS))

/* To be used inside a method for determining if the contents  are objects */
#define CONTAINS_OBJECTS \
  (ENCODING_IS_OBJECT([self contentEncoding]))


/* Error Handling */

#define RETURN_BY_CALLING_EXCEPTION_FUNCTION(FUNC) \
return (*FUNC)(__builtin_apply_args())


/* To be used inside a method for making sure the contents are objects.
   typeof(DEFAULT_ERROR_RETURN) must be the same type as the method
   returns. */
#define CHECK_CONTAINS_OBJECTS_ERROR() \
({if (!(CONTAINS_OBJECTS)) \
{ \
  [self error:"in %s, requires object contents", sel_get_name(_cmd)]; \
}})

/* To be used inside a method whenever a particular element isn't found */
#define ELEMENT_NOT_FOUND_ERROR(AN_ELEMENT) \
([self error:"in %s, element not found.", sel_get_name(_cmd)])

/* To be used inside a method whenever there is no element matching the 
   needed criteria */
#define NO_ELEMENT_FOUND_ERROR() \
([self error:"in %s, no element found.", sel_get_name(_cmd)])



/* These aren't used anymore */

#define TRY_DOING_FORWARD(FORWARDSEL) \
{ \
  IMP imp;\
\
  imp = objc_msg_lookup(self, FORWARDSEL);\
  if (imp)\
    {\
      void *args;\
\
      args = __builtin_apply_args();\
      (*imp)(self, FORWARDSEL,  _cmd, args);\
    }\
}

#define TRY_DOING_FORWARD_WITH(FORWARDSEL,ARG)\
{\
  IMP imp;\
\
  imp = objc_msg_lookup(self, FORWARDSEL);\
  if (imp)\
    {\
      void *args;\
\
      args = __builtin_apply_args();\
      (*imp)(self, FORWARDSEL,  _cmd, args, ARG);\
    }\
}


/* Not currently using these forwarding macros. */
#define TRY_DOING_FORWARD_AND_RETURN(FORWARDSEL) \
{ \
  IMP imp;\
\
  imp = objc_msg_lookup(self, FORWARDSEL);\
  if (imp)\
    {\
      void *result, *args;\
\
      args = __builtin_apply_args();\
      result = (*imp)(self, FORWARDSEL,  _cmd, args);\
      __builtin_return(result); /* Perhaps this shouldn't be here */ \
    }\
}

#define TRY_DOING_FORWARD_WITH_AND_RETURN(FORWARDSEL,ARG)\
{\
  IMP imp;\
\
  imp = objc_msg_lookup(self, FORWARDSEL);\
  if (imp)\
    {\
      void *result, *args;\
\
      args = __builtin_apply_args();\
      result = (*imp)(self, FORWARDSEL,  _cmd, args, ARG);\
      __builtin_return(result); /* Perhaps this shouldn't be here */ \
    }\
}


#endif /* __CollectionPrivate_h_INCLUDE_GNU */
