
#include <objc/Object.h>
#include <coll/coll.h>

long random();

@interface Collection (TestingExtras)
- printCount;
@end
@implementation Collection (TestingExtras)
- printCount
{
  printf("%s: count=%d\n", [self name], [self count]);
  return self;
}
@end

void checkSameContents(id colllist)
{
  unsigned i, c = [colllist count];
  
  for (i = 1; i < c; i++)
    if (![[colllist objectAtIndex:0] 
	  contentsEqual:[colllist objectAtIndex:i]])
      printf("collection 0 does not have same contents as collection %d\n", i);
}


int main()
{
  int i, e;

  id array = [[Array alloc] initEncoding:@encode(int)];
  id bag = [[Bag alloc] initEncoding:"i"];
  id stack = [[Stack alloc] initEncoding:"i"];
  id queue = [[Queue alloc] initEncoding:"i"];
  id gaparray = [[GapArray alloc] initEncoding:"i"];
  id llist = [[EltNodeCollector alloc] initEncoding:"i"
	      nodeCollector:[[LinkedList alloc] init]
	      nodeClass:[LinkedListEltNode class]];
  id bt = [[EltNodeCollector alloc] initEncoding:"i"
	   nodeCollector:[[BinaryTree alloc] init]
	   nodeClass:[BinaryTreeEltNode class]];
  id rt = [[EltNodeCollector alloc] initEncoding:"i"
	   nodeCollector:[[RBTree alloc] init]
	   nodeClass:[RBTreeEltNode class]];
  id st = [[EltNodeCollector alloc] initEncoding:"i"
	   nodeCollector:[[SplayTree alloc] init]
	   nodeClass:[BinaryTreeEltNode class]];
  id foo = [[Array alloc] initEncoding:"i"];

  id collections = [DelegateList new];

  [collections delegateListAddObject:array];
  [collections delegateListAddObject:llist];
  [collections delegateListAddObject:bag];
  [collections delegateListAddObject:stack];
  [collections delegateListAddObject:queue];
  [collections delegateListAddObject:gaparray];
  [collections delegateListAddObject:bt];
  [collections delegateListAddObject:rt];
  [collections delegateListAddObject:st];
  [collections delegateListAddObject:foo];

  printf("delegateList filled, count=%d\n",
	 [[collections delegateListCollection] count]);

  [collections addElement:99];
  [collections printCount];

  printf("Adding numbers...\n");
  for (i = 0; i < 17; i++)
    {
      e = random() % 99;
      printf("%2d ", e);
      [collections addElement:e];
    }
  printf("\ncollections filled\n\n");
  [collections printForDebugger];

  {
    BOOL testzero (elt e)
      {
	if (e.void_ptr_u == 0) return NO;
	else return YES;
      }
    if ([array trueForAllElementsByCalling:testzero])
      printf("Array contains no zero's\n");
  }

  checkSameContents([collections delegateListCollection]);

  printf("\nremoving 99\n\n");
  [collections removeElement:99];

  [foo removeElement:[foo minElement]];
  [foo addElement:99];
  printf("Collections 0 and 9 should mismatch\n");
  [collections printForDebugger];

  checkSameContents([collections delegateListCollection]);

  [collections empty];

  exit(0);
}


