/*
    NXBitmapImageRep - image representation for bitmapped images

    Copyright (C) 1993, Adam Fedor.

    Implementation of display specific methods for X/Motif.
*/

#include "NXBitmapImageRep.h"

#include "Motif.h"
#include "Application.h"
#include <stdlib.h>

const char *NXBitmapImageRepInstanceName(void)
{
    return "NXBitmapImageRep";
}


@implementation NXBitmapImageRep(ToolKit)

- (BOOL)_displayDraw
{
    XMotifContext context;
    XImage	  *image;

    context = (XMotifContext)[NXApp context];
    if (!context->gstate->widget) {
        fprintf(stderr, "BitmapImageRep: Focus not locked on any view\n");
        return NO;
    }
    if (!context->gstate->xgstate) {
        fprintf(stderr, "BitmapImageRep: No gstate.\n");
        return NO;
    }
    image = XCreateImage(context->display,
			context->vinfo.visual,
			_repFlags.bitsPerSample*_repFlags.numColors,
			(bitsPerPixel == 1) ? XYBitmap : ZPixmap,
			0,
			_data[0],
			_pixelsWide,
			_pixelsHigh,
			8,
			0);
    if (!image) {
	fprintf(stderr, "BitmapImageRep: Problem creating X image.\n");
	return NO;
    }
    XPutImage(context->display,
			XtWindow(context->gstate->widget),
			context->gstate->xgstate,
			image,
			0,
			0,
			context->gstate->origin.x,
			context->gstate->origin.y,
			_pixelsWide,
			_pixelsHigh);
    XDestroyImage(image);
    return YES;
}

- (BOOL)_displayDrawIn:(const NXRect *)rect
{
    // We can't scale in X11 so just draw it
    return [self _displayDraw];
}

@end
