/* Widget set category implementation of Window class
 *
 * Copyright (C)  1994  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Tom Pavel, 
 *	    Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for X/Motif
 *
 * xmWindow.m,v 1.6 1994/06/11 03:57:59 pfkeb Exp
 */


#include "Window.h"

/* Required for implementation: */
#include "Motif.h"
#include "Application.h"
#include "Menu.h"
#include <Xm/MainW.h>
#include <Xm/DialogS.h>

#ifdef X11R5
#include <X11/Xmu/Editres.h>
#endif

#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <stdlib.h>             /* for free() */
#include "Scroller.h"
#include <stdio.h>
#include <objc2/typedstream2.h>

char *WindowInstanceName( void )
{
    return "Window";
}

@implementation Window(WidgetSet)

/* private methods not declared in interface file. */

- _setTitle
{
    if ( _shell ) {
        XtVaSetValues(_shell,
		      XtNiconName, title,
		      XtNtitle, title,
		      NULL);
    }
    return self;
} 
    
- _initContent:(const NXRect *)contentRect
{
    _shell = XtAppCreateShell( title, "App",
                               applicationShellWidgetClass,
                               [NXApp _X_display], NULL, 0  ); 
#ifdef X11R5
#ifndef	sgi
  /* Register the Editres protocol: */
    XtAddEventHandler( _shell, (EventMask) 0, TRUE,
                       _XEditResCheckMessages, NULL);
#endif	sgi
#endif

    XtVaSetValues(_shell, XmNallowShellResize, FALSE, NULL);
    widgetid = XmCreateMainWindow(_shell, "window1", NULL, 0);
    XtManageChild(widgetid);
    XtVaSetValues(widgetid, XmNwidth,   NX_WIDTH(contentRect),
		            XmNheight, NX_HEIGHT(contentRect), NULL);
   [self _setTitle];
    return self;
}

- _setWindowAreas
{
    if (hasMenu) {
        if (!menu ) {
            menu = [NXApp mainMenu];
            [menu _managedBy:self];
	}
    } else {
        menu = nil;
    }
    [menu _managedBy:self];
    [contentView _managedBy:self];
	
    XmMainWindowSetAreas(widgetid,
			[menu _widget],	/* Menubar */
                         NULL,          /* Command window */
                         NULL,    	/* Horizontal Scroller*/
                         NULL,          /* Vertical   */
                         [contentView _widget]);       /* Contents */

    return self;
}

/* Public methods */

 /*- closeWindow
{
    if (_holder) {
        XtDestroyWidget([self topLevel]);
        printf("%d\n", [self topLevel]);
    }
}  */
 
- _realize
{
    if ( !isVisible) 
	return self;
    
    if (_shell) {
	XtRealizeWidget( (Widget)_shell);
    }
    hasRealized = YES;
    return self;
}

- (BOOL) _hasRealized
{
    return hasRealized;
}

- (void *)_widget
{
    return widgetid;
}

- (void *)_shell
{
    return _shell;
}

@end

