/* Motif WidgetSet category for implementation of PopUpList class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, and Libing Wang (SLAC)
 *          Mike Kienenberger (Alaska)
 *
 * This file is part of an Objective-C class library for X/Motif
 *
 * xmPopUpList.m,v 1.1 1994/06/14 03:21:43 pfkeb Exp
 */
 
#include "PopUpList.h"

#include "Menu.h"
#include <coll/List.h>
#include "MenuCell.h"
#include "Matrix.h"
#include "Motif.h"
#include <Xm/RowColumn.h> /* for XmCreateOptionMenu */
#include <Xm/PushB.h>
#include <string.h>
#include <stdlib.h>

char *PopUpListInstanceName(void)
{
    return "PopUpList";
}

@implementation PopUpList(WidgetSet)

- _initFrame
{
    [self _addArg:XmNx      :(void *)NX_X(&frame)];
    [self _addArg:XmNy      :(void *)NX_Y(&frame)];
    [self _addArg:XmNwidth  :(void *)NX_WIDTH(&frame)];
    [self _addArg:XmNheight :(void *)NX_HEIGHT(&frame)];
    return self;
}
- _realizeNewItem
{
    if ( widgetid ) {
        XtUnmanageChild((Widget) widgetid);
	XtDestroyWidget((Widget) widgetid);
    }
    [self _managedBy:nil wid:_parentwidget];
    
    return self;
}

- _managedBy:parent wid:(void*)widget
{
    List	*cellList = [matrix cellList];
    Widget	menu_pane;
    int		i, num;
    XmString	xs;

    num = [cellList count];
    if ( !num ) {
        widgetid = NULL;
	return self;
    }
    if (!widget) {
    	return self;
    }
    menu_pane = XmCreatePulldownMenu(widget, "menu_pane", NULL, 0);
    for (i = 0; i < num; i++)
         [[cellList objectAt:i] _managedBy:self wid:menu_pane];

    xs = XmStringCreateSimple("");
    [self _addArg:XmNmarginWidth :(void *)0];
    [self _addArg:XmNmarginHeight :(void *)0];
    [self _addArg:XmNsubMenuId :menu_pane];
    [self _addArg:XmNlabelString :(void *)xs]; // set label to empty string!
    
    if (0 == _menu_type)
    {
	widgetid = XmCreateOptionMenu(widget, instancename,
					    arglist, numargs);
    }
    else
    {
	widgetid = XmCreatePulldownMenu(widget, instancename,
					    arglist, numargs);
    }

    _parentwidget = widget;
    XtManageChild(widgetid);
    return self;
}

@end
