/* Implementation of View class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Tom Pavel, 
 *	    Imran Qureshi, and Libing Wang
 *	    Adam Fedor (U Colorado)
 *          Mike Kienenberger (Alaska)
 *
 * This file is part of an Objective-C class library for a window system
 *
 * View.m,v 1.107 1994/06/15 20:27:19 fedor Exp
 */

 
#include "View.h"

/* Required for implementation: */
#include  <coll/List.h>
#include "Application.h"
#include "CustomView.h"
#include <stdlib.h>
#include <stdio.h>
#include <objc2/typedstream2.h>

extern char *ViewInstanceName(void);

/* Are we drawing, printing, or copying PostScript to the scrap? */

short NXDrawingStatus()
{
	return NX_DRAWING;
}

@implementation View:Responder

/* Private methods not declared in interface file */

- _setSuperview:(View *)aView
{
    superview = aView;
    return self;
}

/* Public methods */

- init
{
    NXRect	rect = { {0,0}, {0,0} };
    
    [self initFrame:&rect];
    return self;
 }

- initFrame:(const NXRect *)frameRect
{
    [super init];
    instancename = ViewInstanceName();
    frame.origin.x    = frameRect->origin.x;
    frame.origin.y    = frameRect->origin.y;
    frame.size.width  = frameRect->size.width;
    frame.size.height = frameRect->size.height;
    bounds = frame;
    [self _init];
    return self;
}

- free
{
    if ( subviews ) {
	[subviews freeObjects];
	[subviews free];
    }
    [self removeFromSuperview];
    [self _destroy];
    return [super free];
}

- addSubview:aView
{
    if (!subviews)
    	subviews = [[List alloc] init];
    [subviews addObjectIfAbsent:aView];
    [aView _setSuperview:self];
    if ( widgetid ) {
	[aView _managedBy:self];
    }
    return aView;
}

- addSubview:aView :(int)place relativeTo:otherView;
{
    return [self addSubview:aView];
}

- replaceSubview:oldView with:newView
{
    View	*ret;
    int		i;
    
    if ( ![newView isKindOf:[View class]] ) {
        return nil;
    }
    if ( !subviews ) {
        return nil;
    }
    i = [subviews indexOf:oldView];
    if ( i == GNU_NOT_IN_LIST ) {
        return nil;
    }
    ret = [subviews replaceObject:oldView with:newView];
    if ( ret ) {
        [ret removeFromSuperview];	/* could be that ret == newView */
        [newView _managedBy:self];
    }
    return ret;
}
- superview
{
    return superview;
}

- removeFromSuperview
{
    superview = NULL;
    window = NULL;
    [self _unManage];
//    [self _destroy];
    return self;
}

- notifyAncestorWhenFrameChanged:(BOOL)flag
{
    needsAncestorNotify = flag;
    ancestorNotifyWasEnabled = YES;
    return self;
}
- descendantFrameChanged:sender
{
    return [superview descendantFrameChanged:sender];
}

- moveTo:(NXCoord)x :(NXCoord)y
{
    frame.origin.x = x;
    frame.origin.y = y;
    [self _moveTo:x :y];
    return self;
}

- moveBy: (NXCoord)deltaX :(NXCoord)deltaY
{
    NXPoint	point;

    point.x = frame.origin.x + deltaX;
    point.y = frame.origin.y + deltaY;
    return [self moveTo:point.x :point.y];
}    

- getBounds:(NXRect *)theRect
{
    theRect->origin.x = bounds.origin.x;
    theRect->origin.y = bounds.origin.y;
    theRect->size.width = bounds.size.width;
    theRect->size.height = bounds.size.height;
    return self;
}

- (BOOL)canDraw
{
    if ( window ) {
        return YES;
    }
    return NO;
}

- (BOOL)lockFocus
{
    BOOL retval;
    retval = focusLocked;
    if (!focusLocked) {
	if (superview)
	    [superview lockFocus];
    	[self _displayLockFocus];
    }
    focusLocked = YES;
    return retval;
}

- unlockFocus
{
    if (focusLocked) {
        [self _displayUnlockFocus];
    	if ( superview ) 
	    [superview unlockFocus];
    }
    focusLocked = NO;
    return self;
}

- display:(const NXRect *)rects :(int)rectCount :(BOOL)clipFlag
{
    NXRect	i_rects[3];
    int		rcount;
    
    [self lockFocus];

    if ( (rectCount == 0) || (rects == NULL) ) {
	i_rects[0] = frame;	/* fake it */
	rcount = 1;
	[self drawSelf:i_rects :rcount];
    } else {
        [self drawSelf:rects :rectCount];
    }
    [subviews makeObjectsPerform:@selector(display)];
    [self unlockFocus];
    return self;
}
- display:(const NXRect *)rects :(int)rectCount
{
    [self display:rects :rectCount :NO];
    return self;
}
- display
{
    [self display:(NXRect *)0 :0 :NO];
    return self;
}

- drawSelf:(const NXRect *)rects :(int)rectCount
{
    return self;
}

- setAutoresizeSubviews:(BOOL)flag
{
    autoResize = flag;
    return self;
}

- window
{
    return window;
}

- setFrame:(const NXRect *)frameRect;
{
    frame.size.width  = frameRect->size.width;
    frame.size.height = frameRect->size.height;
    frame.origin.x    = frameRect->origin.x;
    frame.origin.y    = frameRect->origin.y;
    [self _setFrame:&frame];
    bounds = frame;
    return self;
}

- getFrame:(NXRect *)theRect
{
    theRect->size.width = NX_WIDTH(&frame);
    theRect->size.height = NX_HEIGHT(&frame);
    theRect->origin.x = NX_X(&frame);
    theRect->origin.y = NX_Y(&frame);
    return self;
}


- sizeTo:(NXCoord)width :(NXCoord)height;
{
    frame.size.width  = width;
    frame.size.height = height;
    bounds.size.width  = width;
    bounds.size.height = height;
    [self _sizeTo:width :height];
    return self;
}

- convertPoint:(NXPoint *)p fromView:aView
/* This method does absolutely nothing, and should do nothing.
	It is only here to limit the # of #defines necessary in
	Nextstep obj-c code.
*/
{
    return self;
}


- translateCoords:(NXEvent *)nx
{
    /* simply translate the y coordinates! */

    nx->location.y = bounds.size.height - nx->location.y;
    return self;
}


// METHODS TO ADD:
// --------------------------


- (int)gState
{
	return 0;
}


- resizeSubviews:(const NXSize *)oldSize
{
    return self;
}

// END LIST.
// --------------------------




/* Archiving methods */
- read:(TypedStream*)typedStream
{
    [super read:typedStream];
    NXReadRect(typedStream, &frame);
    bounds = frame;
    objc_read_object(typedStream, &subviews);
    return self;
}

- awake
{
    [super awake];
    
    bounds = frame;
    instancename = ViewInstanceName();
    [self _init];
    return self;
}

- awakeFromNib
{
    CustomView	*subview, *custom;
    int		i;
    
    i = [subviews count];
    while ( i-- ) {
	subview = [subviews objectAt:i];
	if ( [subview isKindOf:[CustomView class]] ) {
	    subview = [subview nibInstantiate];
	    custom = [subviews replaceObjectAt:i with:subview];
	    [custom free];
	} else {
	    [subview awakeFromNib];
	}
    }
    return self;
}

- (NXRect *)frame
{
    return &frame;
}

- (void *)_drawingA
{
    return _drawingA;
}

- (void *)_widget
{
    return widgetid;
}

- _addCallback
{
    return self;
}

- _managedBy:parent
{
    if (![parent _widget]) {
    	fprintf(stderr, "%s: parent widget not found\n", [self name]);
	return nil;
    }
    if ( [parent isKindOf:[View class]] ) {
	superview = parent;
	window = [parent window];
    }
    return [self _managedBy:parent wid:[parent _widget]];
}

- _setWindow:(Window *)aWindow
{
    window = aWindow;
    return self;
}

- _manageChildren
{
    View	*view;
    int		i;

    i = [subviews count];
    while ( i-- ) {
	view = [subviews objectAt:i];
	[view _managedBy:self];
    }
    return self;
}

/* really, only boxes should call this method:  
 	Right now, only does a setFrame, but could require special 
	additions later... at first it did, maybe it will again...?
 */
- _setBorderRect:(NXRect *)brect
{
    [self setFrame:brect];
    return self;
}

@end
