/* Implementation of TextFieldCell class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * TextFieldCell.m,v 1.32 1994/06/11 03:57:19 pfkeb Exp
 */
 
#include "TextFieldCell.h"

extern char *TextFieldCellInstanceName(void); /* in widget set category */

@implementation TextFieldCell:ActionCell

- init
{
    [super init];
    instancename = TextFieldCellInstanceName();
    [self _init];
    _isLabel = NO;
    return self;
}

- copy
{
    TextFieldCell	*newCell;
    
    newCell = [super copy];
    if ( _isLabel ) {
        [newCell _initAsLabel];
    }
    return newCell;
}

/* Archiving methods */
- read:(TypedStream*)typedStream
{
	[super read:typedStream];
	[self init];
	return self;
}

- write:(TypedStream*)typedStream
{
	[super write:typedStream];
	return self;
}

- setTextGray:(float)value
{
 /*
  * Only used in HippoDraw to obscure text by setting it same color as
  * background.   We can work around not having it 
  */
    return self;
}

- setStringValue:(const char *)aString
{

 /* Over-ride super class so we can set the widget's contents */
    [super setStringValue:aString];
    [self _setStringValue];
    return self;
}
- (const char *)stringValue
{
    return [self _stringValue];
}

@end
