/* Implemenation of SliderCell class
 *
 * Copyright (C)  1993  The Board of Trustees of
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * SliderCell.m,v 1.15 1994/06/14 22:32:49 pfkeb Exp
 */

#include "SliderCell.h"

#include <stdlib.h>
#include <string.h>
#include <objc2/typedstream2.h>

extern char * SliderCellInstanceName(void);

@interface SliderCell(WidgetSet)
- _init;
- _setMinValue;
- _setMaxValue;
- _setValue;
- (double)_value;
- _setVertical:(BOOL)flag;
- (BOOL)_isVertical;
- _addCallback;
- _managedBy:parent wid:(void *)widget;
@end

@implementation SliderCell : ActionCell

- init
{
	[super init];
	[self _init];
	instancename = SliderCellInstanceName();
	return self;
}
- copy
{
    SliderCell	*newCell;
    
    newCell = [super copy];
    [newCell setMaxValue:maxValue];
    [newCell setMinValue:minValue];
    [newCell setDoubleValue:value];
    return newCell;
}

- (double)minValue
{
    return minValue;
}

- setMinValue:(double)aDouble
{
    minValue = aDouble;
    [self _setMinValue];
    return self;
}

- (double)maxValue
{
    return maxValue;
}

- setMaxValue:(double)aDouble
{
    maxValue = aDouble;
    [self _setMaxValue];
    return self;
}

- setDoubleValue:(double)aDouble
{
    value = aDouble;
    [self _setValue];
    return self;
}

- (double)doubleValue
{
    value = [self _value];
    return value;
}

- setFloatValue:(float)aFloat
{
    value = (double)aFloat;
    [self _setValue];
    return self;
}

- (float)floatValue
{
    float	f;
    
    f = [self _value];
    return f;
}

- setIntValue:(int)anInt
{
    value = anInt;
    [self _setValue];
    return self;
}

- (int)intValue
{
    int intValue;
    
    intValue = [self _value];;
    return intValue;
}

- setStringValue:(const char *)str
{
    double f;
    
    f = atof(str);
    if (f) [self setDoubleValue:f];
    return self;
}

- (const char *)stringValue
{
    float f;
    char *temp;
    
    f = [self floatValue];
    temp = (char *)malloc(sizeof(float)*2);
    sprintf(temp, "%f", f);
    return temp;
}

- setVertical:(BOOL)flag
{
    [self _setVertical:flag];
    return self;
}

- (BOOL)isVertical
{
    return [self _isVertical];;
}

- read:(TypedStream *)ts
{
    int a, b, c;
    [super read:ts];
    objc_read_float(ts, &a);
    objc_read_float(ts, &b);
    objc_read_float(ts, &c);
    objc_read_type(ts, "i", &vert);
    value = (double)a;
    maxValue = (double)b;
    minValue = (double)c;
    
    [self init];
    [self setMaxValue:maxValue];
    [self setMinValue:minValue];
    [self _setVertical:vert];
    return self;
}

@end
