/* Implementation of SavePanel class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Fred Harris, Paul Kunz, Tom Pavel, 
 *	    Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * SavePanel.m,v 1.28 1994/06/15 18:58:30 pfkeb Exp
 */


#include "SavePanel.h"

/* Required for implementation: */
#include "Application.h"

extern char *SavePanelInstanceName(void);

@interface SavePanel(WidgetSet)
- _init;
- (const char *)_filename;
- _setDirectory:(const char *)path;
- _setRequiredFileType:(const char *)type;
- _setTitle:(const char *)aTitle;
- _manageAndPopup;
- _managedBy:parent wid:(void*)widget;
@end

@implementation SavePanel:Panel

- init
{
//    [super init]; Don't use Window's method!
    [self _init];
    instancename = SavePanelInstanceName();
    return self;
}

- ok:sender
{
    return self;
}

- cancel:sender
{
    return self;
}

- (int)runModalForDirectory:(const char *)path file:(const char *)name
{
   [self setDirectory:path];
/*   [self setFilename:name]; */
   return [self runModal];
}
- (int)runModal
{
    [self _manageAndPopup];
    return [NXApp runModalFor:self];
}

- (const char *)filename
{
    return [self _filename];
}


- (const char *)directory
{
   return directory;
}

- setDirectory:(const char *)path
{
   directory = NXCopyStringBuffer(path);
   [self _setDirectory:path];
   return self;
}

- setPrompt:(const char *)prompt
{
    return self;
}

- setTitle:(const char *)aTitle
{
    [super setTitle:aTitle];
    [self _setTitle:aTitle];
    return self;
}

- (const char *)requiredFileType
{
   return requiredType;
}

- setRequiredFileType:(const char *)type
{
   requiredType = NXCopyStringBuffer(type);
   [self _setRequiredFileType:type];
   return self;
}

- setAccessoryView:aView
{
  /* not urgent for phase 1, we can work around not having it */
    return self;
}
@end
