/* Interface for MList class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Fred Harris, Paul Kunz, Tom Pavel, 
 *	    Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for X/Motif
 *
 * Note:  This class is not part of NeXTSTEP or OpenStep.  It is a
 *        wrapper for the Motif xmListWidgetClass and is used,
 *        for example, in the implementation of NXBrowser.
 *
 * MList.h,v 1.15 1994/06/11 03:55:59 pfkeb Exp
 */

#ifndef _MList_h_
#define _MList_h_

#include "Control.h"
#include "graphics.h"

@class List, Matrix;
@interface MList:Control
{
    id		target;
    SEL		action;
    SEL		doubleAction;
}

- initFrame:(const NXRect *)frame;
- fillListFrom:(Matrix *)aMatrix;
- empty;
- getSelectedCells:(List *)aList from:(Matrix *)cellMatrix;
- selectCellAt:(int)row;

- setTarget:anObject;
- target;
- setAction:(SEL)aSelector;
- (SEL)action;
- setDoubleAction:(SEL)aSelector;
- (SEL)doubleAction;
- _addCallback;
- _managedBy:parent wid:(void *)widget;

@end

#endif /* _MList_h_ */

