/* Implementation of FormCell class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * FormCell.m,v 1.40 1994/06/14 00:29:33 pfkeb Exp
 */

#include "FormCell.h"

#include "TextFieldCell.h"
#include "Text.h"
#include <stdlib.h>
#include <string.h>
#include <objc2/hashtable.h>
#include "graphics.h"

extern char *FormCellInstanceName(void);

@interface FormCell(WidgetSet)
- _init;
- (NXCoord)_titleWidth;
@end

@implementation FormCell:ActionCell

- init
{
    [super init];
    titleCell = [[TextFieldCell alloc] _initAsLabel];
    [titleCell setAlignment:NX_RIGHTALIGNED];
    textCell = [[TextFieldCell alloc] init];
    instancename = FormCellInstanceName();
    [self _init];
    return self;
}

- initTextCell:(const char *)aString
{
    [self init];
    [titleCell setStringValue:aString];
    return self;
}

- free
{
    [titleCell free];
    [textCell free];
    return [super free];
}


// - copyFromZone:(NXZone *)zone;
// - (NXCoord)titleWidth:(NXSize *)aSize;

- (NXCoord)titleWidth
{
    return [self _titleWidth];
}

- setTitleWidth:(NXCoord)width
{
    NXSize	size;

    titleWidth = width;
    size.width = titleWidth;
    size.height = _frame.size.height;
    [titleCell _setSize:&size];
    return self;
}

- (const char *)title
{
    return [titleCell stringValue];
}

- setTitle:(const char *)aTitle
{
    [titleCell setStringValue:aTitle]; 
    return self;
}

// - titleFont;
// - setTitleFont:fontObj;

- (int)titleAlignment
{
    return [titleCell alignment];
}

- setTitleAlignment:(int)mode
{
    [titleCell setAlignment:mode];
    return self;
}

- setEnabled:(BOOL)flag
{
    [titleCell setEnabled:flag];
    [textCell  setEnabled:flag];
    return self;
}

- (BOOL)isOpaque
{
    return YES;
}

// - calcCellSize:(NXSize *)theSize inRect:(const NXRect *)aRect;
// - drawInside:(const NXRect *)cellFrame inView:controlView;
// - drawSelf:(const NXRect *)cellFrame inView:controlView;
// - (BOOL)trackMouse:(NXEvent*)event inRect:(const NXRect*)aRect 
//             ofView:controlView;
// - resetCursorRect:(NXRect *)cellFrame inView:controlView;
// - write:(NXTypedStream *)stream;

- read:(TypedStream*)typedStream
{
    char               *cellContents;

    [super read:typedStream];
    objc_read_object(typedStream, &titleCell);
    cellContents = (char *)[titleCell stringValue];
    [self init];
    [self setTitle:cellContents];
    return self;
}


// + new;
// + newTextCell;
// + newTextCell:(const char *)aString;

- setStringValue:(const char *)aString
{
    [textCell setStringValue:aString];
    return self;
}

- (const char *)stringValue
{
    return [textCell stringValue];

}
- setIntValue:(int) anInt
{
    [textCell setIntValue:anInt];
    return self;
}

- (int) intValue
{
    return [textCell intValue];
}

- setFloatValue:(float)aFloat
{
    [textCell setFloatValue:aFloat];
    return self;
}

- (float) floatValue
{
    return [textCell floatValue];
}

- (double) doubleValue
{
    return [textCell doubleValue];
}

- setDoubleValue:(double)aDouble
{
    [textCell setDoubleValue:aDouble];
    return self;
}


- titleCell
{
    return titleCell;
}

- textCell
{
    return textCell;
}

- copy
{
    FormCell	*newCell;

    newCell = [super copy];
    [newCell setTitle:[titleCell stringValue]];
    [newCell setStringValue:[textCell stringValue]];
    return newCell;
}

- _managedBy:parent
{
      NXRect	cellRect;

    [super _managedBy:parent];

/* put title cell in */
    [titleCell _managedBy:self];

/* put in text cell but shift and specify width */
    cellRect.origin.x = [self titleWidth];
    cellRect.origin.y = 0;
    cellRect.size.width  = _frame.size.width - cellRect.origin.x;
    cellRect.size.height = _frame.size.height;
    [textCell _setFrame:&cellRect inView:controlView];
    [textCell _managedBy:self];

    return self;
}

- _destroy
{
    [super _destroy];
    [titleCell _destroy];
    [textCell _destroy];
    return self;
}
@end
