/*  Copyright 1992 John Bovey, University of Kent at Canterbury.
 *
 *  You can do what you like with this source code as long as
 *  you don't try to make money out of it and you include an
 *  unaltered copy of this message (including the copyright).
 *
 * This module has been heavily modifiedby R. Nation
 * (nation@rocket.sanders.lockheed.com).
 * No additional restrictions are applied
 *
 * As usual, the author accepts no responsibility for anything, nor does
 * he guarantee anything whatsoever.
 */

/* @(#)screen.h	1.1 14/7/92 (UKC) */

/*  flags for scr_move()
 */
#define COL_RELATIVE	1	/* column movement is relative */
#define ROW_RELATIVE	2	/* row movement is relative */

#define MAX_SCROLL	50	/* max number of lines that can scroll at once */

/*  arguments to the screen delete functions
 */
#define END	0
#define START	1
#define ENTIRE	2

/* modes for scr_insert_delete_lines()
 */
#define INSERT -1
#define DELETE 1

/* modes for scr_move_up_down
 */
#define UP 1
#define DOWN -1

/*  rendition style flags.
 */
#define RS_NONE		0	/* Normal */
#define RS_BOLD		1	/* Bold face */
#define RS_ULINE	2	/* underline */
#define RS_BLINK	4	/* blinking */
#define RS_RVID		8	/* reverse video */
#define RS_GBFONT      16       /* UK character set */
#define RS_GRFONT      32       /* graphics character set */
#define RS_SELECTED    64       /* graphics character set */

/*  The current selection unit
 */
enum selunit {
	CHAR,
	WORD,
	LINE
};

/* Cursor on/off statuses 
 */
#define ON 1
#define OFF 0


void scr_init(void);
void scr_reset(void);
void scr_power_on(void);
void scr_backspace(void);
void scr_change_screen(int);
void scr_change_rendition(int,int);
void scr_get_size(int *,int *);
void scr_focus(int);
void scr_string(unsigned char *,int,int);
void scr_move(int,int,int);
void scr_index(int);
void scr_save_cursor(void);
void scr_restore_cursor(void);
void scr_erase_line(int);
void scr_erase_screen(int);
void scr_insert_delete_lines(int,int);
void scr_insert_delete_characters(int,int);
void scr_set_margins(int,int);
void scr_set_wrap(int);
void scr_set_decom(int);
void scr_set_insert(int);
void scr_move_to(int);
void scr_move_up_down(int);
void scr_make_selection(int);
void scr_send_selection(int,int,int,int);
void scr_request_selection(int,int,int);
void scr_paste_primary(int,int);
void scr_clear_selection(void);
void scr_extend_selection(int,int);
void scr_start_selection(int,int);
void scr_report_position(void);
void scr_refresh(int,int,int,int);
void scr_set_charset(int set,unsigned char a);
void scr_choose_charset(int set);
void scr_secure(void);

