/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.xmlrpc.example;

/**
 * Iterates over the parameters passed in (or out) of a call.
 * These are used in this Xml-Rpc package for input and output.
 * <p>
 * @see IteratorAdapter How to wrap an existing Iterator
 */
public interface ProvIterator 
{
	/** 
	 * This will return an entity, such as a <code>Subscriber</code>.
	 * @return next parameter
	 * @throws ProvException if there is some problem retrieving the next
	 * parameter.
	 */
	ProvEntity next() 
		throws ProvException;
	
	/** 
	 * @return true if an additional object is available for reading.
	 * @throws ProvException if there is some problem checking for the next
	 * parameter from the stream.
	 */
	boolean hasNext() 
		throws ProvException;

	/** 
	 * This method closes underlying input/output stream.
	 * Calling close() is required, since it will release underlying
	 * resources.
	 * @throws ProvException if the close operation could not be
	 * completed.
	 */
	void close() 
		throws ProvException;
}
