.ig \"-*- nroff -*-
Copyright (C) 1989-2000 Free Software Foundation, Inc.

Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.

Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
..
.TH GROTTY @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
grotty \- groff driver for typewriter-like devices
.SH SYNOPSIS
.B grotty
[
.B \-hfbuodBUv
] [
.BI \-F dir
] [
.IR files \|.\|.\|.
]
.PP
It is possible to have whitespace between the
.B \-F
option and its parameter.
.SH DESCRIPTION
.B grotty
translates the output of GNU
.B troff
into a form suitable for typewriter-like devices.
Normally
.B grotty
should be invoked by using the
.B groff
command
with a
.BR \-Tascii ,
.B \-Tlatin1
or
.B \-Tutf8
option on ASCII based systems, and with
.B \-Tcp1047
on EBCDIC based hosts.
If no files are given,
.B grotty
will read the standard input.
A filename of
.B \-
will also cause
.B grotty
to read the standard input.
Output is written to the standard output.
.LP
Normally
.B grotty
prints a bold character
.I c
using the sequence
.RI ` c
.SM BACKSPACE
.IR c '
and a italic character
.I c
by the sequence
.RB ` _
.SM BACKSPACE
.IR c '.
These sequences can be displayed on a terminal
by piping through
.BR ul (1).
Pagers such as
.BR more (1)
or
.BR less (1)
are also able to display these sequences.
Use either
.B \-B
or
.B \-U
when piping into
.BR less (1);
use
.B \-b
when piping into
.BR more (1).
There is no need to filter the output through
.BR col (1)
since
.B grotty
never outputs reverse line feeds.
.LP
The font description file may contain a command
.IP
.BI internalname\  n
.LP
where
.I n
is a decimal integer.
If the 01 bit in
.I n
is set,
then the font will be treated as an italic font;
if the 02 bit is set,
then it will be treated as a bold font.
The code field in the font description field gives the
code which will be used to output the character.
This code can also be used in the
.B \eN
escape sequence in
.BR troff .
.SH OPTIONS
.TP
.BI \-F dir
Prepend directory
.IB dir /dev name
to the search path for font and device description files;
.I name
is the name of the device, usually
.BR ascii ,
.BR latin1 ,
.BR utf8 ,
or
.BR cp1047 .
.TP
.B \-h
Use horizontal tabs in the output.
Tabs are assumed to be set every 8 columns.
.TP
.B \-f
Use form feeds in the output.
A form feed will be output at the end of each page that has no output
on its last line.
.TP
.B \-b
Suppress the use of overstriking for bold characters.
.TP
.B \-u
Suppress the use of underlining for italic characters.
.TP
.B \-B
Use only overstriking for bold-italic characters.
.TP
.B \-U
Use only underlining for bold-italic characters.
.TP
.B \-o
Suppress overstriking (other than for bold or underlined characters).
.TP
.B \-d
Ignore all
.B \eD
commands.
Without this
.B grotty
will render
.B \eD'l\|.\|.\|.'
commands that have at least at least one zero argument
(and so are either horizontal or vertical)
using
.BR \- ,
.B |
and
.B +
characters.
.TP
.B \-v
Print the version number.
.SH FILES
.TP
.B @FONTDIR@/devascii/DESC
Device description file for
.B ascii
device.
.TP
.BI @FONTDIR@/devascii/ F
Font description file for font
.I F
of
.B ascii
device.
.TP
.B @FONTDIR@/devlatin1/DESC
Device description file for
.B latin1
device.
.TP
.BI @FONTDIR@/devlatin1/ F
Font description file for font
.I F
of
.B latin1
device.
.TP
.B @FONTDIR@/devutf8/DESC
Device description file for
.B utf8
device.
.TP
.BI @FONTDIR@/devutf8/ F
Font description file for font
.I F
of
.B utf8
device.
.TP
.B @FONTDIR@/devcp1047/DESC
Device description file for
.B cp1047
device.
.TP
.BI @FONTDIR@/devcp1047/ F
Font description file for font
.I F
of
.B cp1047
device.
.TP
.B @MACRODIR@/tty.tmac
Macros for use with
.BR grotty .
.TP
.B @MACRODIR@/tty-char.tmac
Additional klugdey character definitions for use with
.BR grotty .
.LP
Note that on EBCDIC hosts, only files for the
.B cp1047
device will be installed.
.SH BUGS
.LP
.B grotty
is intended only for simple documents.
.LP
There is no support for fractional horizontal or vertical motions.
.LP
There is no support for
.B \eD
commands
other than horizontal and vertical lines.
.LP
Characters above the first line (ie with a vertical position of 0)
cannot be printed.
.SH "SEE ALSO"
.BR groff (@MAN1EXT@),
.BR @g@troff (@MAN1EXT@),
.BR groff_out (@MAN5EXT@),
.BR groff_font (@MAN5EXT@),
.BR groff_char (@MAN7EXT@),
.BR ul (1),
.BR more (1),
.BR less (1)
