A function with the `start` attribute was declared with type parameters.

Erroneous code example:

```compile_fail,E0132
#![feature(start)]

#[start]
fn f<T>() {}
```

It is not possible to declare type parameters on a function that has the `start`
attribute. Such a function must have the following type signature (for more
information, view [the unstable book][1]):

[1]: https://doc.rust-lang.org/unstable-book/language-features/start.html

```
# let _:
fn(isize, *const *const u8) -> isize;
```

Example:

```
#![feature(start)]

#[start]
fn my_start(argc: isize, argv: *const *const u8) -> isize {
    0
}
```
