use super::{color, Color, Element};

impl Element {
    /// Returns the color for the element in the jmol software
    ///
    /// ```
    /// use mendeleev::{Element, Color};
    ///
    /// assert_eq!(Element::H.jmol_color(), Some(Color{r: 255, g: 255, b: 255}));
    /// assert_eq!(Element::Og.jmol_color(), None);
    /// assert_eq!(Element::Au.jmol_color(), Some(Color{r: 255, g: 209, b: 35}));
    /// ```
    pub const fn jmol_color(&self) -> Option<Color> {
        match self {
            Element::H => color(255, 255, 255),
            Element::He => color(217, 255, 255),
            Element::Li => color(204, 128, 255),
            Element::Be => color(194, 255, 0),
            Element::B => color(255, 181, 181),
            Element::C => color(144, 144, 144),
            Element::N => color(48, 80, 248),
            Element::O => color(255, 13, 13),
            Element::F => color(144, 224, 80),
            Element::Ne => color(179, 227, 245),
            Element::Na => color(171, 92, 242),
            Element::Mg => color(138, 255, 0),
            Element::Al => color(191, 166, 166),
            Element::Si => color(240, 200, 160),
            Element::P => color(255, 128, 0),
            Element::S => color(255, 255, 48),
            Element::Cl => color(31, 240, 31),
            Element::Ar => color(128, 209, 227),
            Element::K => color(143, 64, 212),
            Element::Ca => color(61, 255, 0),
            Element::Sc => color(230, 230, 230),
            Element::Ti => color(191, 194, 199),
            Element::V => color(166, 166, 171),
            Element::Cr => color(138, 153, 199),
            Element::Mn => color(156, 122, 199),
            Element::Fe => color(224, 102, 51),
            Element::Co => color(240, 144, 160),
            Element::Ni => color(80, 208, 80),
            Element::Cu => color(200, 128, 51),
            Element::Zn => color(125, 128, 176),
            Element::Ga => color(194, 143, 143),
            Element::Ge => color(102, 143, 143),
            Element::As => color(189, 128, 227),
            Element::Se => color(255, 161, 0),
            Element::Br => color(166, 41, 41),
            Element::Kr => color(92, 184, 209),
            Element::Rb => color(112, 46, 176),
            Element::Sr => color(0, 255, 0),
            Element::Y => color(148, 255, 255),
            Element::Zr => color(148, 224, 224),
            Element::Nb => color(115, 194, 201),
            Element::Mo => color(84, 181, 181),
            Element::Tc => color(59, 158, 158),
            Element::Ru => color(36, 143, 143),
            Element::Rh => color(10, 125, 140),
            Element::Pd => color(0, 105, 133),
            Element::Ag => color(192, 192, 192),
            Element::Cd => color(255, 217, 143),
            Element::In => color(166, 117, 115),
            Element::Sn => color(102, 128, 128),
            Element::Sb => color(158, 99, 181),
            Element::Te => color(212, 122, 0),
            Element::I => color(148, 0, 148),
            Element::Xe => color(66, 158, 176),
            Element::Cs => color(87, 23, 143),
            Element::Ba => color(0, 201, 0),
            Element::La => color(112, 212, 255),
            Element::Ce => color(255, 255, 199),
            Element::Pr => color(217, 255, 199),
            Element::Nd => color(199, 255, 199),
            Element::Pm => color(163, 255, 199),
            Element::Sm => color(143, 255, 199),
            Element::Eu => color(97, 255, 199),
            Element::Gd => color(69, 255, 199),
            Element::Tb => color(48, 255, 199),
            Element::Dy => color(31, 255, 199),
            Element::Ho => color(0, 255, 156),
            Element::Er => color(0, 230, 117),
            Element::Tm => color(0, 212, 82),
            Element::Yb => color(0, 191, 56),
            Element::Lu => color(0, 171, 36),
            Element::Hf => color(77, 194, 255),
            Element::Ta => color(77, 166, 255),
            Element::W => color(33, 148, 214),
            Element::Re => color(38, 125, 171),
            Element::Os => color(38, 102, 150),
            Element::Ir => color(23, 84, 135),
            Element::Pt => color(208, 208, 224),
            Element::Au => color(255, 209, 35),
            Element::Hg => color(184, 184, 208),
            Element::Tl => color(166, 84, 77),
            Element::Pb => color(87, 89, 97),
            Element::Bi => color(158, 79, 181),
            Element::Po => color(171, 92, 0),
            Element::At => color(117, 79, 69),
            Element::Rn => color(66, 130, 150),
            Element::Fr => color(66, 0, 102),
            Element::Ra => color(0, 125, 0),
            Element::Ac => color(112, 171, 250),
            Element::Th => color(0, 186, 255),
            Element::Pa => color(0, 161, 255),
            Element::U => color(0, 143, 255),
            Element::Np => color(0, 128, 255),
            Element::Pu => color(0, 107, 255),
            Element::Am => color(84, 92, 242),
            Element::Cm => color(120, 92, 227),
            Element::Bk => color(138, 79, 227),
            Element::Cf => color(161, 54, 212),
            Element::Es => color(179, 31, 212),
            Element::Fm => color(179, 31, 186),
            Element::Md => color(179, 13, 166),
            Element::No => color(189, 13, 135),
            Element::Lr => color(199, 0, 102),
            Element::Rf => color(204, 0, 89),
            Element::Db => color(209, 0, 79),
            Element::Sg => color(217, 0, 69),
            Element::Bh => color(224, 0, 56),
            Element::Hs => color(230, 0, 46),
            Element::Mt => color(235, 0, 38),
            Element::Ds => None,
            Element::Rg => None,
            Element::Cn => None,
            Element::Nh => None,
            Element::Fl => None,
            Element::Mc => None,
            Element::Lv => None,
            Element::Ts => None,
            Element::Og => None,
        }
    }
}
