# ifndef CPPAD_CORE_BOOL_VALUED_HPP
# define CPPAD_CORE_BOOL_VALUED_HPP
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-or-later
// SPDX-FileCopyrightText: Bradley M. Bell <bradbell@seanet.com>
// SPDX-FileContributor: 2003-24 Bradley M. Bell
// ----------------------------------------------------------------------------

/*
{xrst_begin bool_valued}
{xrst_spell
  dyn
  ext
}

Bool Valued Operations and Functions with AD Arguments
######################################################
{xrst_toc_hidden
   include/cppad/core/compare.hpp
   include/cppad/core/near_equal_ext.hpp
   include/cppad/core/bool_fun.hpp
   include/cppad/core/con_dyn_var.hpp
   include/cppad/core/equal_op_seq.hpp
}

.. csv-table::
   :widths: auto

   Compare,:ref:`Compare-title`
   near_equal_ext,:ref:`near_equal_ext-title`
   bool_fun,:ref:`bool_fun-title`
   con_dyn_var,:ref:`con_dyn_var-title`
   EqualOpSeq,:ref:`EqualOpSeq-title`

{xrst_end bool_valued}
*/

# include <cppad/core/compare.hpp>
# include <cppad/core/near_equal_ext.hpp>
# include <cppad/core/bool_fun.hpp>
# include <cppad/core/con_dyn_var.hpp>
# include <cppad/core/equal_op_seq.hpp>

# endif
